/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.util.ServiceUtilConfigError;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServicesUitl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesUitl.class);
    private static final String SERVICEPREFIX = "META-INF/services/";

    private static void fail(Class paramClassIn, String paramStrIn, Throwable paramThrowableIn) throws ServiceUtilConfigError {
        ServiceUtilConfigError tempServiceConfigError = new ServiceUtilConfigError(paramClassIn.getName() + ": " + paramStrIn);
        tempServiceConfigError.initCause(paramThrowableIn);
        throw tempServiceConfigError;
    }

    private static void servicefail(Class paramClassIn, String paramStrIn) throws ServiceUtilConfigError {
        throw new ServiceUtilConfigError(paramClassIn.getName() + ": " + paramStrIn);
    }

    private static void servicefail(Class paramClassIn, URL paramURLIn, int paramIntIn, String paramStrIn) throws ServiceUtilConfigError {
        ServicesUitl.servicefail(paramClassIn, paramURLIn + ":" + paramIntIn + ": " + paramStrIn);
    }

    private static int parseLine(Class paramClassIn, URL paramURLIn, BufferedReader bufferedReaderIn, int paramIntIn, List paramListIn, Set paramSetIn) throws IOException, ServiceUtilConfigError {
        int jTemp;
        String strTemp = bufferedReaderIn.readLine();
        if (strTemp == null) {
            return -1;
        }
        int iTemp = strTemp.indexOf(35);
        if (iTemp >= 0) {
            strTemp = strTemp.substring(0, iTemp);
        }
        if ((jTemp = (strTemp = strTemp.trim()).length()) != 0) {
            int kTemp;
            if (strTemp.indexOf(32) >= 0 || strTemp.indexOf(9) >= 0) {
                ServicesUitl.servicefail(paramClassIn, paramURLIn, paramIntIn, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(kTemp = strTemp.codePointAt(0))) {
                ServicesUitl.servicefail(paramClassIn, paramURLIn, paramIntIn, "Illegal provider-class name: " + strTemp);
            }
            for (int lTemp = Character.charCount(kTemp); lTemp < jTemp; lTemp += Character.charCount(kTemp)) {
                kTemp = strTemp.codePointAt(lTemp);
                if (Character.isJavaIdentifierPart(kTemp) || kTemp == 46) continue;
                ServicesUitl.servicefail(paramClassIn, paramURLIn, paramIntIn, "Illegal provider-class name: " + strTemp);
            }
            if (!paramSetIn.contains(strTemp)) {
                paramListIn.add(strTemp);
                paramSetIn.add(strTemp);
            }
        }
        return paramIntIn + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator servicesparse(Class paramClassIn, URL paramURLIn, Set paramSetIn) throws ServiceUtilConfigError {
        InputStream inputStreamTemp = null;
        BufferedReader bufferedReaderTemp = null;
        ArrayList arrayListTemp = new ArrayList();
        try {
            inputStreamTemp = paramURLIn.openStream();
            bufferedReaderTemp = new BufferedReader(new InputStreamReader(inputStreamTemp, "utf-8"));
            int iTemp = 1;
            while ((iTemp = ServicesUitl.parseLine(paramClassIn, paramURLIn, bufferedReaderTemp, iTemp, arrayListTemp, paramSetIn)) >= 0) {
            }
        }
        catch (IOException tempIOException1) {
            try {
                ServicesUitl.servicefail(paramClassIn, ": " + tempIOException1);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, bufferedReaderTemp);
                StreamUtils.closeStream(null, (InputStream)inputStreamTemp);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)bufferedReaderTemp);
            StreamUtils.closeStream(null, (InputStream)inputStreamTemp);
        }
        StreamUtils.closeResource(null, (Closeable)bufferedReaderTemp);
        StreamUtils.closeStream(null, (InputStream)inputStreamTemp);
        return arrayListTemp.iterator();
    }

    public static Iterator servicesproviders(Class paramClassIn, ClassLoader paramClassLoaderIn) throws ServiceUtilConfigError {
        return new ServicesIterator(paramClassIn, paramClassLoaderIn);
    }

    public static Iterator servicesproviders(Class paramClassIn) throws ServiceUtilConfigError {
        ClassLoader localClassLoaderTemp = Thread.currentThread().getContextClassLoader();
        return ServicesUitl.servicesproviders(paramClassIn, localClassLoaderTemp);
    }

    public static Iterator installedProviders(Class paramClassIn) throws ServiceUtilConfigError {
        ClassLoader tempClassLoaderTwo = null;
        for (ClassLoader tempClassLoaderOne = ClassLoader.getSystemClassLoader(); tempClassLoaderOne != null; tempClassLoaderOne = tempClassLoaderOne.getParent()) {
            tempClassLoaderTwo = tempClassLoaderOne;
        }
        return ServicesUitl.servicesproviders(paramClassIn, tempClassLoaderTwo);
    }

    private static class ServicesIterator
    implements Iterator {
        private Class serviceClass;
        private ClassLoader loaderForClass;
        private Enumeration configsEnumer = null;
        private Iterator pendingIterator = null;
        private Set returnedSet = new TreeSet();
        private String nextNameStr = null;

        private ServicesIterator(Class paramClassIn, ClassLoader paramClassLoaderIn) {
            this.serviceClass = paramClassIn;
            this.loaderForClass = paramClassLoaderIn;
        }

        @Override
        public boolean hasNext() throws ServiceUtilConfigError {
            if (this.nextNameStr != null) {
                return true;
            }
            if (this.configsEnumer == null) {
                try {
                    String stringTemp = ServicesUitl.SERVICEPREFIX + this.serviceClass.getName();
                    this.configsEnumer = this.loaderForClass == null ? ClassLoader.getSystemResources(stringTemp) : this.loaderForClass.getResources(stringTemp);
                }
                catch (IOException tempIOException) {
                    ServicesUitl.servicefail(this.serviceClass, ": " + tempIOException);
                }
            }
            while (this.pendingIterator == null || !this.pendingIterator.hasNext()) {
                if (null == this.configsEnumer) {
                    LOGGER.error("The configsEnumer parameter is null.");
                    return false;
                }
                if (!this.configsEnumer.hasMoreElements()) {
                    return false;
                }
                this.pendingIterator = ServicesUitl.servicesparse(this.serviceClass, (URL)this.configsEnumer.nextElement(), this.returnedSet);
            }
            this.nextNameStr = (String)this.pendingIterator.next();
            return true;
        }

        public Object next() throws ServiceUtilConfigError {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String strNextNameTemp = this.nextNameStr;
            this.nextNameStr = null;
            try {
                return Class.forName(strNextNameTemp, true, this.loaderForClass).newInstance();
            }
            catch (ClassNotFoundException tempClassNotFoundException) {
                ServicesUitl.servicefail(this.serviceClass, "Provider " + strNextNameTemp + " not found");
            }
            catch (Exception tempException) {
                ServicesUitl.fail(this.serviceClass, "Provider " + strNextNameTemp + " could not be instantiated: " + tempException, tempException);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

