/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.text.HintTextField;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui2.module.featuremanager.FeatureItem;
import com.huawei.ism.ui2.module.featuremanager.FeatureItemFactory;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwingUtil.class);
    public static final int UNDEFINE_VALUE = Integer.MIN_VALUE;
    public static final String BLANK_CONTENT = "--";
    private static Map<Event.Level, IsmTableCell.IconCell> levelIconCellMap;

    private SwingUtil() {
    }

    public static boolean validateTextField(Window parent, IsmTextField ... textFileds) {
        return SwingUtil.validateInput(Arrays.asList(textFileds), parent);
    }

    public static TableRow getSelectedTableRow(IsmTable table, DefaultTableModel tableModel) {
        int index = table.getSelectedRow();
        if (index < 0) {
            return null;
        }
        int modelIndex = table.convertRowIndexToModel(index);
        TableRow tableRow = tableModel.getRow(modelIndex);
        return tableRow;
    }

    public static boolean validateInput(List<IsmTextField> inputs, Window parent) {
        String tip = null;
        for (IsmTextField textField : inputs) {
            if (!textField.isEnabled() || null == (tip = textField.validateInput())) continue;
            DialogUtils.showErrorDialog(parent, tip);
            return false;
        }
        return true;
    }

    public static boolean validateHintTextInput(List<HintTextField> inputs, Window parent) {
        if (inputs == null || inputs.isEmpty()) {
            return false;
        }
        String tip = "";
        for (HintTextField textField : inputs) {
            if (!textField.isEnabled() || StringUtils.isNULLStr((String)(tip = textField.validateInput()))) continue;
            DialogUtils.showErrorDialog(parent, tip);
            return false;
        }
        return true;
    }

    public static boolean validatePwdInput(List<IsmPasswordField> inputs, Window parent) {
        String tip = null;
        for (IsmPasswordField textField : inputs) {
            if (!textField.isEnabled() || !textField.isVisible() || null == (tip = textField.validateInput())) continue;
            DialogUtils.showErrorDialog(parent, tip);
            return false;
        }
        return true;
    }

    public static boolean validateInput(List<IsmTextField> inputs) {
        String tip = null;
        boolean isSuccess = true;
        boolean isFirst = true;
        for (IsmTextField textField : inputs) {
            if (!textField.isEnabled() || null == (tip = textField.validateInput())) continue;
            textField.setErrorToolTip(tip);
            isSuccess = false;
            if (!isFirst) continue;
            textField.requestFocus();
            isFirst = false;
        }
        return isSuccess;
    }

    public static void setComponentsEnabled(JComponent panel, boolean enabled) {
        for (Component component : SwingUtil.getChildren(panel)) {
            component.setEnabled(enabled);
        }
    }

    public static void setCloseWhenEscKeyPressed(final JDialog dialog) {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        dialog.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        dialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("user close dialog,dialog title:" + dialog.getTitle());
                }
                dialog.dispose();
            }
        });
    }

    public static void setCloseWhenEscKeyPressed(final JFrame frame) {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        frame.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        frame.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("user close dialog,dialog title:" + frame.getTitle());
                }
                frame.dispose();
            }
        });
    }

    public static void cancelEscKeyToClose(JDialog dialog) {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        dialog.getRootPane().getInputMap(2).remove(escape);
        dialog.getRootPane().getActionMap().remove("ESCAPE");
    }

    public static void putScreenCenter(Window window) {
        Dimension location = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation(location.width / 2 - window.getWidth() / 2, location.height / 2 - window.getHeight() / 2);
        window.setLocationRelativeTo(null);
    }

    public static void putParentCenter(Window child, Window parent) {
        Dimension parentSize = null;
        parentSize = null == parent ? Toolkit.getDefaultToolkit().getScreenSize() : parent.getSize();
        int width = (parentSize.width - child.getWidth()) / 2;
        int height = (parentSize.height - child.getHeight()) / 2;
        child.setLocation(width, height);
        if (null == parent || parent.isMinimumSizeSet()) {
            child.setLocationRelativeTo(null);
        } else {
            child.setLocationRelativeTo(parent);
        }
    }

    public static void initMainFrameSize(Component frame, Dimension min) {
        Dimension max = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension prefer = new Dimension((int)max.getWidth() * 5 / 6, (int)max.getHeight() * 5 / 6);
        SwingUtil.initMainFrameSize(frame, max, min, prefer);
    }

    public static void initMainFrameSize(Component frame) {
        Dimension max = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension min = new Dimension((int)max.getWidth() / 4 * 3, (int)max.getHeight() / 4 * 3);
        Dimension prefer = new Dimension((int)max.getWidth() * 5 / 6, (int)max.getHeight() * 5 / 6);
        SwingUtil.initMainFrameSize(frame, max, min, prefer);
    }

    private static void initMainFrameSize(Component frame, Dimension max, final Dimension min, Dimension prefer) {
        frame.setPreferredSize(prefer);
        frame.setMaximumSize(max);
        frame.setMinimumSize(min);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component component = e.getComponent();
                if (null != component) {
                    if (component.getHeight() < min.height) {
                        component.setSize(component.getWidth(), min.height);
                    }
                    if (component.getWidth() < min.width) {
                        component.setSize(min.width, component.getHeight());
                    }
                }
            }
        });
    }

    public static CompoundBorder getCompoundTitleTableBorder(Border titledBorder) {
        LineBorder lineBorder = new LineBorder(Color.GRAY);
        Border outBorder = UCD.createEmptyBorder();
        return SwingUtil.getCompoundBorder(titledBorder, SwingUtil.getCompoundBorder(outBorder, lineBorder));
    }

    @Deprecated
    public static CompoundBorder getCompoundBorder(Border outer, Border inner) {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outer, inner);
        return compoundBorder;
    }

    public static void runInEventDispatchThread(Runnable run) {
        SwingUtil.runInEventDispatchThread(run, true);
    }

    public static void disPoseDialg(ProgressDialog progressDialog) {
        SwingUtil.runInEventDispatchThread(new DisposeDialogTask(progressDialog));
    }

    public static void runInEventDispatchThread(Runnable run, boolean asyncExecute) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else if (asyncExecute) {
            SwingUtilities.invokeLater(run);
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException e) {
                LOGGER.error("runInEventDispatchThread error:", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("runInEventDispatchThread error:", e.getCause());
            }
        }
    }

    public static void applyKeyBoardLockPatch(final JTextComponent textCom) {
        if (null == textCom || Utils.isWindows()) {
            return;
        }
        final JButton testButton = new JButton();
        textCom.add(testButton);
        textCom.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Component oppComp = e.getOppositeComponent();
                if (oppComp != testButton && textCom != oppComp) {
                    if (!testButton.isFocusable()) {
                        testButton.setFocusable(true);
                    }
                    testButton.requestFocus(true);
                    testButton.transferFocusBackward();
                } else if (testButton.isFocusable()) {
                    testButton.setFocusable(false);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void component2Img(Component c, Window parent) {
        FilterOutputStream out = null;
        Window actualParent = parent;
        try {
            BufferedImage bi = (BufferedImage)c.createImage(c.getWidth(), c.getHeight());
            if (null == bi) {
                throw new NullPointerException();
            }
            c.paint(bi.getGraphics());
            IsmFileChooser fileChooser = new IsmFileChooser("");
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.addFileFilter(new String[]{"jpg", "jpeg"}, "JPEG(*.JPG;*.JPEG)");
            if (actualParent == null) {
                actualParent = Framework.getInstance().getMainFrame();
            }
            if (fileChooser.showSaveDialog(actualParent) != 0) {
                return;
            }
            if (null == fileChooser.getSelectedFile()) {
                return;
            }
            File aFile = fileChooser.getSelectedFile();
            String name = aFile.getName();
            String tmp = aFile.getCanonicalPath();
            String dir = tmp.substring(0, tmp.lastIndexOf(name));
            name = fileChooser.getFileName(name, "jpg");
            String path = dir + name;
            out = new BufferedOutputStream(new FileOutputStream(path));
            ((BufferedOutputStream)out).flush();
        }
        catch (RuntimeException e) {
            DialogUtils.showErrorDialog(actualParent, (Throwable)e);
        }
        catch (Exception e) {
            DialogUtils.showErrorDialog(actualParent, (Throwable)e);
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.error("IOException", (Throwable)e);
                }
            }
        }
    }

    public static JComponent getChild(Class<?> c, Component ... components) {
        JComponent child = null;
        JComponent component2 = null;
        for (Component component : components) {
            if (!(component instanceof JComponent)) continue;
            child = (JComponent)component;
            if (c.isInstance(component)) {
                return (JComponent)component;
            }
            component2 = SwingUtil.getChild(c, child.getComponents());
            if (null == component2) continue;
            return component2;
        }
        return null;
    }

    public static List<JComponent> getChildren(Container container) {
        ArrayList<JComponent> children = new ArrayList<JComponent>(0);
        Component[] components = container.getComponents();
        JComponent child = null;
        for (Component component : components) {
            if (!(component instanceof JComponent)) continue;
            child = (JComponent)component;
            children.add(child);
            children.addAll(SwingUtil.getChildren(child));
        }
        return children;
    }

    public static void setTransparent(Container container) {
        List<JComponent> children = SwingUtil.getChildren(container);
        JPanel pane = null;
        for (JComponent child : children) {
            if (!(child instanceof JPanel)) continue;
            pane = (JPanel)child;
            pane.setOpaque(false);
        }
    }

    public static void setName(Container cont) {
        if (null == cont) {
            return;
        }
        SwingUtil.setName(cont, new HashMap(0));
    }

    private static void setName(Container cont, Map<Class<?>, Integer> counter) {
        boolean isValidType = SwingUtil.checkContainerType(cont);
        if (isValidType) {
            Class<?> clazz = cont.getClass();
            if (!counter.containsKey(clazz)) {
                counter.put(clazz, 0);
            }
            int count = counter.get(clazz);
            counter.put(clazz, ++count);
            String name = cont.getClass().getSimpleName() + '_' + count;
            cont.setName(name);
            if (!(cont instanceof Dialog || cont instanceof Frame || cont instanceof Window || cont instanceof JPanel || cont instanceof JTabbedPane)) {
                return;
            }
        }
        Component[] children = cont.getComponents();
        JComponent jc = null;
        for (Component c : children) {
            if (!(c instanceof JComponent)) continue;
            jc = (JComponent)c;
            SwingUtil.setName(jc, counter);
        }
    }

    private static boolean checkContainerType(Container container) {
        boolean isJlabelInstance = container instanceof JLabel;
        isJlabelInstance = isJlabelInstance || container instanceof AbstractButton;
        isJlabelInstance = isJlabelInstance || container instanceof JTextComponent;
        isJlabelInstance = isJlabelInstance || container instanceof JComboBox;
        isJlabelInstance = isJlabelInstance || container instanceof Dialog || container instanceof Frame;
        isJlabelInstance = isJlabelInstance || container instanceof Window || container instanceof JPanel;
        isJlabelInstance = isJlabelInstance || container instanceof JTable || container instanceof JList;
        isJlabelInstance = isJlabelInstance || container instanceof JTabbedPane;
        return isJlabelInstance;
    }

    public static void postEvent(Window window) {
    }

    public static String formatCommonString(String str) {
        if (null == str || "".equals(str)) {
            return BLANK_CONTENT;
        }
        return str;
    }

    public static String formatPortID(String id) {
        return SwingUtil.formatChassisID(id);
    }

    public static String formatChassisID(String id) {
        if (null == id || "".equals(id)) {
            return BLANK_CONTENT;
        }
        String tem = "00";
        String strId = id;
        String result = tem + strId;
        return result.substring(result.length() - 2);
    }

    public static EmptyBorder getEmptyBorder() {
        Insets insets = new Insets(8, 8, 8, 8);
        EmptyBorder emptyBorder = new EmptyBorder(insets);
        return emptyBorder;
    }

    public static CompoundBorder getCompoundTitleBorder(Border titledBorder) {
        EmptyBorder outBorder = SwingUtil.getEmptyBorder();
        return SwingUtil.getCompoundBorder(titledBorder, outBorder);
    }

    public static String formatControllerId(int controllerId) {
        if (Integer.MIN_VALUE == controllerId) {
            return BLANK_CONTENT;
        }
        return 0 == controllerId ? "A" : "B";
    }

    public static Icon getLevelIcon(Event.Level level) {
        return ResourceManager.getImage(level.getIconKey());
    }

    public static IsmTableCell.IconCell getLevelCell(Event.Level level) {
        if (null == levelIconCellMap) {
            levelIconCellMap = Collections.synchronizedMap(new EnumMap(Event.Level.class));
        }
        if (levelIconCellMap.containsKey((Object)level)) {
            return levelIconCellMap.get((Object)level);
        }
        IsmTableCell.IconCell iconCell = new IsmTableCell.IconCell(SwingUtil.getLevelIcon(level), level.toString(), (Comparable)((Object)level));
        levelIconCellMap.put(level, iconCell);
        return iconCell;
    }

    public static List<FeatureItem> getFeatureItems(String deviceID) {
        ArrayList<FeatureItem> featureItems = new ArrayList<FeatureItem>(0);
        FeatureItem featureItem = FeatureItemFactory.getFeatureItem(deviceID, DeviceType.N8000, "home_dashborder");
        featureItems.add(featureItem);
        featureItem.setTopFeatureItemn(true);
        featureItem = FeatureItemFactory.getFeatureItem(deviceID, DeviceType.N8000, "all_device_view");
        featureItems.add(featureItem);
        featureItem.setTopFeatureItemn(true);
        featureItem = FeatureItemFactory.getFeatureItem(deviceID, DeviceType.N8000, "home_provising");
        featureItems.add(featureItem);
        featureItem.setTopFeatureItemn(true);
        featureItem = FeatureItemFactory.getFeatureItem(deviceID, DeviceType.N8000, "home_event");
        featureItems.add(featureItem);
        featureItem.setTopFeatureItemn(true);
        featureItem = FeatureItemFactory.getFeatureItem(deviceID, DeviceType.N8000, "home_performance");
        featureItems.add(featureItem);
        featureItem.setTopFeatureItemn(true);
        return featureItems;
    }

    private static final class DisposeDialogTask
    implements Runnable {
        private final ProgressDialog progressDialog;

        private DisposeDialogTask(ProgressDialog progressDialog) {
            this.progressDialog = progressDialog;
        }

        @Override
        public void run() {
            this.progressDialog.setVisible(false);
            this.progressDialog.dispose();
        }
    }
}

