/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

abstract class FieldWriterDate<T>
extends FieldWriter<T> {
    protected DateTimeFormatter formatter;
    final boolean formatMillis;
    final boolean formatISO8601;
    final boolean formatyyyyMMdd8;
    final boolean formatyyyyMMddhhmmss14;
    final boolean formatyyyyMMddhhmmss19;
    final boolean formatUnixTime;
    protected ObjectWriter dateWriter;

    protected FieldWriterDate(String fieldName, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field, Method method) {
        super(fieldName, ordinal, features, format, label, fieldType, fieldClass, field, method);
        boolean formatMillis = false;
        boolean formatISO8601 = false;
        boolean formatUnixTime = false;
        boolean formatyyyyMMdd8 = false;
        boolean formatyyyyMMddhhmmss14 = false;
        boolean formatyyyyMMddhhmmss19 = false;
        if (format != null) {
            switch (format) {
                case "millis": {
                    formatMillis = true;
                    break;
                }
                case "iso8601": {
                    formatISO8601 = true;
                    break;
                }
                case "unixtime": {
                    formatUnixTime = true;
                    break;
                }
                case "yyyy-MM-dd HH:mm:ss": {
                    formatyyyyMMddhhmmss19 = true;
                    break;
                }
                case "yyyyMMdd": {
                    formatyyyyMMdd8 = true;
                    break;
                }
                case "yyyyMMddHHmmss": {
                    formatyyyyMMddhhmmss14 = true;
                    break;
                }
            }
        }
        this.formatMillis = formatMillis;
        this.formatISO8601 = formatISO8601;
        this.formatUnixTime = formatUnixTime;
        this.formatyyyyMMdd8 = formatyyyyMMdd8;
        this.formatyyyyMMddhhmmss14 = formatyyyyMMddhhmmss14;
        this.formatyyyyMMddhhmmss19 = formatyyyyMMddhhmmss19;
    }

    @Override
    public boolean isDateFormatMillis() {
        return this.formatMillis;
    }

    @Override
    public boolean isDateFormatISO8601() {
        return this.formatISO8601;
    }

    public DateTimeFormatter getFormatter() {
        if (!(this.formatter != null || this.format == null || this.formatMillis || this.formatISO8601 || this.formatUnixTime)) {
            this.formatter = DateTimeFormatter.ofPattern(this.format);
        }
        return this.formatter;
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        if (valueClass == this.fieldClass) {
            ObjectWriterProvider provider = jsonWriter.context.provider;
            if (this.dateWriter == null) {
                if ((provider.userDefineMask & 0x10L) != 0L) {
                    this.dateWriter = provider.getObjectWriter((Type)valueClass, valueClass, false);
                } else {
                    if (this.format == null) {
                        this.dateWriter = ObjectWriterImplDate.INSTANCE;
                        return this.dateWriter;
                    }
                    this.dateWriter = new ObjectWriterImplDate(this.format, null);
                    return this.dateWriter;
                }
            }
            return this.dateWriter;
        }
        return jsonWriter.getObjectWriter(valueClass);
    }

    @Override
    public void writeDate(JSONWriter jsonWriter, long timeMillis) {
        int month;
        int year;
        boolean formatyyyyMMddhhmmss19;
        if (jsonWriter.jsonb) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeMillis(timeMillis);
            return;
        }
        int SECONDS_PER_DAY = 86400;
        JSONWriter.Context ctx = jsonWriter.context;
        if (this.formatUnixTime || this.format == null && ctx.isDateFormatUnixTime()) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeInt64(timeMillis / 1000L);
            return;
        }
        if (this.formatMillis || this.format == null && ctx.isDateFormatMillis()) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeInt64(timeMillis);
            return;
        }
        ZoneId zoneId = ctx.getZoneId();
        String dateFormat = this.format != null ? this.format : ctx.getDateFormat();
        boolean bl = formatyyyyMMddhhmmss19 = this.formatyyyyMMddhhmmss19 || ctx.isFormatyyyyMMddhhmmss19() && this.format == null;
        if (dateFormat == null || this.formatyyyyMMddhhmmss14 || formatyyyyMMddhhmmss19) {
            long yearEst;
            long doyEst;
            int offsetTotalSeconds;
            long epochSecond = Math.floorDiv(timeMillis, 1000L);
            if (zoneId == DateUtils.SHANGHAI_ZONE_ID || zoneId.getRules() == DateUtils.SHANGHAI_ZONE_RULES) {
                offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
            } else {
                Instant instant = Instant.ofEpochMilli(timeMillis);
                offsetTotalSeconds = zoneId.getRules().getOffset(instant).getTotalSeconds();
            }
            long localSecond = epochSecond + (long)offsetTotalSeconds;
            long localEpochDay = Math.floorDiv(localSecond, 86400L);
            int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
            int DAYS_PER_CYCLE = 146097;
            long DAYS_0000_TO_1970 = 719528L;
            long zeroDay = localEpochDay + 719528L;
            long adjust = 0L;
            if ((zeroDay -= 60L) < 0L) {
                long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
                adjust = adjustCycles * 400L;
                zeroDay += -adjustCycles * 146097L;
            }
            if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
                doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
            }
            yearEst += adjust;
            int marchDoy0 = (int)doyEst;
            int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
            int month2 = (marchMonth0 + 2) % 12 + 1;
            int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
            if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
                throw new DateTimeException("Invalid year " + yearEst);
            }
            int year2 = (int)yearEst;
            int MINUTES_PER_HOUR = 60;
            int SECONDS_PER_MINUTE = 60;
            int SECONDS_PER_HOUR = 3600;
            long secondOfDay = secsOfDay;
            if (secondOfDay < 0L || secondOfDay > 86399L) {
                throw new DateTimeException("Invalid secondOfDay " + secondOfDay);
            }
            int hours = (int)(secondOfDay / 3600L);
            int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
            int hour = hours;
            int minute = minutes;
            int second = (int)(secondOfDay -= (long)(minutes * 60));
            if (year2 >= 0 && year2 <= 9999) {
                if (this.formatyyyyMMddhhmmss14) {
                    this.writeFieldName(jsonWriter);
                    jsonWriter.writeDateTime14(year2, month2, dayOfMonth, hour, minute, second);
                    return;
                }
                if (formatyyyyMMddhhmmss19) {
                    this.writeFieldName(jsonWriter);
                    jsonWriter.writeDateTime19(year2, month2, dayOfMonth, hour, minute, second);
                    return;
                }
                int millis = (int)Math.floorMod(timeMillis, 1000L);
                if (millis != 0) {
                    Instant instant = Instant.ofEpochMilli(timeMillis);
                    int offsetSeconds = ctx.getZoneId().getRules().getOffset(instant).getTotalSeconds();
                    this.writeFieldName(jsonWriter);
                    jsonWriter.writeDateTimeISO8601(year2, month2, dayOfMonth, hour, minute, second, millis, offsetSeconds, false);
                    return;
                }
                this.writeFieldName(jsonWriter);
                jsonWriter.writeDateTime19(year2, month2, dayOfMonth, hour, minute, second);
                return;
            }
        }
        this.writeFieldName(jsonWriter);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), zoneId);
        if ((this.formatISO8601 || ctx.isDateFormatISO8601() && this.format == null) && (year = zdt.getYear()) >= 0 && year <= 9999) {
            month = zdt.getMonthValue();
            int dayOfMonth = zdt.getDayOfMonth();
            int hour = zdt.getHour();
            int minute = zdt.getMinute();
            int second = zdt.getSecond();
            int millis = zdt.getNano() / 1000000;
            int offsetSeconds = zdt.getOffset().getTotalSeconds();
            jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, millis, offsetSeconds, true);
            return;
        }
        if (this.formatyyyyMMdd8 && (year = zdt.getYear()) >= 0 && year <= 9999) {
            month = zdt.getMonthValue();
            int dayOfMonth = zdt.getDayOfMonth();
            jsonWriter.writeDateYYYMMDD8(year, month, dayOfMonth);
            return;
        }
        DateTimeFormatter formatter = this.getFormatter();
        if (formatter == null) {
            formatter = ctx.getDateFormatter();
        }
        if (formatter != null) {
            jsonWriter.writeString(formatter.format(zdt));
        } else {
            jsonWriter.writeZonedDateTime(zdt);
        }
    }
}

