/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.service;

import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.smartkit.frame.ToolManageService;
import com.huawei.yinglong.smartkit.frame.entity.BaseProduct;
import com.huawei.yinglong.smartkit.frame.util.CertsUtil;
import com.huawei.yinglong.virtualization.deploy.starter.VirtualizationServiceStart;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VirtualizationToolService
implements ToolManageService {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationToolService.class);
    public static final List<String> PROCESS_DEFINE_KEYS = Collections.unmodifiableList(Arrays.asList("virtualization-deploy", "a3000-deploy", "component_integrate", "fusioncube-convergent-deploy"));
    private final BpmEngineService bpmEngineService;

    @Override
    public List<? extends BaseProduct> getSupportProducts() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasRunningTask() {
        return PROCESS_DEFINE_KEYS.stream().map(arg_0 -> ((BpmEngineService)this.bpmEngineService).queryAllProcessInstance(arg_0)).flatMap(Collection::stream).anyMatch(process -> ProcessStatus.RUNNING.equals((Object)process.getStatus()));
    }

    @Override
    public void shutdown() {
        try {
            this.bpmEngineService.changeProcessInstanceReadOnly(PROCESS_DEFINE_KEYS);
            CertsUtil.clearDefaultSelfSignedCerts();
        }
        catch (Exception e) {
            log.error("shutdown app failed.", (Throwable)e);
        }
        finally {
            VirtualizationServiceStart.releaseLock();
        }
    }

    @Override
    public void applicationReadyListener() {
        this.bpmEngineService.changeProcessInstanceReadOnly(PROCESS_DEFINE_KEYS);
    }

    public VirtualizationToolService(BpmEngineService bpmEngineService) {
        this.bpmEngineService = bpmEngineService;
    }
}

