/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.starter;

import com.huawei.encryptbase.context.ApplicationContext;
import com.huawei.yinglong.bpm.util.PortCheckUtil;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import com.huawei.yinglong.smartkit.frame.util.CertsUtil;
import com.huawei.yinglong.virtualization.deploy.starter.ProcessApplication;
import com.huawei.yinglong.virtualization.deploy.utils.FilePathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;

public class VirtualizationServiceStart {
    private static final Logger log = LoggerFactory.getLogger(VirtualizationServiceStart.class);
    private static FileChannel channel;
    private static FileLock lock;
    private static FileOutputStream fo;

    public static void main(String ... args) {
        if (VirtualizationServiceStart.checkPortConflict() || !VirtualizationServiceStart.generateLockFlag()) {
            log.error("check port conflict or generate lock flag failed");
            return;
        }
        VirtualizationServiceStart.initEnvLanguage();
        VirtualizationServiceStart.intKmcConfigEnv();
        VirtualizationServiceStart.startSystem(new String[0]);
    }

    public static void releaseLock() {
        Optional.ofNullable(lock).ifPresent(VirtualizationServiceStart::release);
        lock = null;
        Optional.ofNullable(channel).ifPresent(VirtualizationServiceStart::release);
        channel = null;
        Optional.ofNullable(fo).ifPresent(VirtualizationServiceStart::release);
        fo = null;
    }

    static void release(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception exception) {
            log.error("release closeable failed.", (Throwable)exception);
        }
    }

    private static void intKmcConfigEnv() {
        log.info("start kmc");
        FilePathUtils.getNormalizationPath(Paths.get(SystemEnvUtil.getDefaultUserDir(), "..", "..", "config", "mm", "appConfig.properties").toString()).ifPresent(configFile -> ApplicationContext.getInstance().setAppEncryptConfigPath(configFile));
        log.info("finish kmc");
    }

    private static void initEnvLanguage() {
        Locale locale = SystemEnvUtil.getLanguage();
        log.info("current language is {}.", (Object)locale);
        Locale.setDefault(locale);
    }

    private static void startSystem(String ... args) {
        log.info("start sys");
        if (!CertsUtil.generateDefaultSelfSignedCerts()) {
            CertsUtil.clearDefaultSelfSignedCerts();
            log.error("generate default self sign cert failed.");
            return;
        }
        CompletableFuture.runAsync(VirtualizationServiceStart::startBrowser);
        SpringApplication.run(ProcessApplication.class, (String[])args);
    }

    static boolean generateLockFlag() {
        log.info("start to check tool's running status");
        if (lock != null) {
            log.error("current running flag file is already locked");
            return false;
        }
        File flagFile = VirtualizationServiceStart.getRunningFlagFile();
        try {
            if (!flagFile.exists() && !flagFile.createNewFile()) {
                log.error("create flag file error");
            }
            return (lock = (channel = (fo = new FileOutputStream(flagFile)).getChannel()).tryLock()) != null;
        }
        catch (IOException e) {
            VirtualizationServiceStart.releaseLock();
            log.error("create running flag file error.", (Throwable)e);
            return false;
        }
    }

    private static File getRunningFlagFile() {
        return new File(System.getProperty("user.dir") + File.separator + "runningFlag");
    }

    private static boolean checkPortConflict() {
        String serverPort = PortCheckUtil.getYamlPropertyValue((String)"server.port");
        if (!PortCheckUtil.isPortAvailable((int)Integer.parseInt(serverPort))) {
            log.error("port has been used.");
            return true;
        }
        return false;
    }

    private static void startBrowser() {
        try {
            String browser = Paths.get(SystemEnvUtil.getDefaultUserDir(), "electron", "ftd-browser.exe").toString();
            ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", "\"" + browser + "\"", "common");
            String token = SystemEnvUtil.createSmartKitToken();
            SystemEnvUtil.saveSmartkitToken((String)token);
            builder.environment().put("token", token);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            while (process.isAlive()) {
                Thread.sleep(1000L);
                VirtualizationServiceStart.refreshOutput(process.getInputStream());
            }
        }
        catch (Exception e) {
            log.error("start browser exception", (Throwable)e);
        }
    }

    private static void refreshOutput(InputStream is) throws IOException {
        int len;
        if (is == null) {
            return;
        }
        while ((len = is.available()) > 0) {
            byte[] bs = new byte[len];
            int bSize = is.read(bs);
            String outputStr = new String(bs, 0, bSize, Charset.defaultCharset());
            log.info("browser : {}", (Object)outputStr);
        }
    }
}

