/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.filter.route;

import com.huawei.fitframework.broker.client.filter.Fitable;
import com.huawei.fitframework.broker.client.filter.route.AbstractFilter;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FitableIdFilter
extends AbstractFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FitableIdFilter.class);
    private final List<String> fitableIds;

    public FitableIdFilter(String ... fitableIds) {
        this(Stream.of((Object[])ObjectUtils.getIfNull((Object)fitableIds, () -> new String[0])).collect(Collectors.toList()));
    }

    public FitableIdFilter(List<String> fitableIds) {
        this.fitableIds = ((List)ObjectUtils.getIfNull(fitableIds, Collections::emptyList)).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Validation.isTrue((boolean)CollectionUtils.isNotEmpty(this.fitableIds), (String)"No valid fitable id to instantiate FitableIdFilter.", (Object[])new Object[0]);
    }

    @Override
    protected List<Fitable> route(List<Fitable> toFilterFitables, Object[] args) {
        log.debug("Prepare to route by fitable id. [fitableIds={}, toFilterFitables={}]", this.fitableIds, toFilterFitables);
        List<Fitable> filteredFitables = toFilterFitables.stream().filter(toFilterFitable -> toFilterFitable.containsAnyFitableId(this.fitableIds)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredFitables)) {
            log.warn("Fail to route by fitable id. [fitableIds={}, toFilterFitables={}]", this.fitableIds, toFilterFitables);
        } else {
            log.debug("Route by fitable id successfully. [fitableIds={}, targetFitables={}]", this.fitableIds, filteredFitables);
        }
        return filteredFitables;
    }
}

