/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.concurrent.TimeUnit;

public class DefaultInvokeContext
implements InvokeContext {
    private final int retry;
    private final long timeout;
    private final TimeUnit timeUnit;

    public DefaultInvokeContext(int retry, long timeout, TimeUnit timeUnit) {
        this.retry = Validation.greaterThanOrEquals((int)retry, (int)0, (String)"Retry must be greater than or equals 0. [retry={0}]", (Object[])new Object[]{retry});
        this.timeout = Validation.greaterThan((long)timeout, (long)0L, (String)"Timeout must be greater than 0. [timeout={0}]", (Object[])new Object[]{timeout});
        this.timeUnit = timeUnit == null ? TimeUnit.MILLISECONDS : timeUnit;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    @Override
    public int retry() {
        return this.retry;
    }

    public static InvokeContext fromFitAnnotation(Fit fit) {
        if (fit == null) {
            return InvokeContext.defaultContext();
        }
        return new DefaultInvokeContext(fit.retry(), fit.timeout(), fit.timeunit());
    }

    public static final class Builder
    implements InvokeContext.Builder {
        private int retry = 0;
        private long timeout = 3000L;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public Builder(InvokeContext context) {
            if (context == null) {
                return;
            }
            this.retry = context.retry();
            this.timeout = context.timeout();
            this.timeUnit = context.timeUnit();
        }

        @Override
        public InvokeContext.Builder retry(Integer retry) {
            if (retry != null) {
                this.retry = retry;
            }
            return this;
        }

        @Override
        public InvokeContext.Builder timeout(Long timeout) {
            if (timeout != null) {
                this.timeout = timeout;
            }
            return this;
        }

        @Override
        public InvokeContext.Builder timeUnit(TimeUnit timeUnit) {
            if (timeUnit != null) {
                this.timeUnit = timeUnit;
            }
            return this;
        }

        @Override
        public InvokeContext build() {
            return new DefaultInvokeContext(this.retry, this.timeout, this.timeUnit);
        }
    }
}

