/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.mail.auth;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.mail.auth.AbstractAuthStep;
import com.huawei.ism.tool.mail.auth.CertUtil;
import com.huawei.ism.tool.mail.auth.MyTrustManager;
import com.huawei.ism.tool.obase.mails.MailInfo;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;

public class SslEmailServerAuthStep
implements AbstractAuthStep {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AbstractAuthStep.class);
    private static final String[] SSLV3_PROTOCOLS = new String[]{"SSLv3"};
    private static final String[] TLS_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    private String[] agreementType;
    private MailInfo emailAccount;

    public SslEmailServerAuthStep(MailInfo emailAccount, String[] ssltype) {
        this.emailAccount = emailAccount;
        String[] tempSslType = (String[])ssltype.clone();
        this.agreementType = tempSslType;
    }

    @Override
    public int process() {
        TrustManager trustManager = this.getTrustManagerFromFile();
        if (trustManager == null || this.agreementType == null) {
            return -2;
        }
        TrustManager[] tms = new TrustManager[]{trustManager};
        for (String protocol : this.agreementType) {
            int result = this.testContext(tms, protocol);
            if (result == -4) continue;
            return result;
        }
        return -2;
    }

    private TrustManager getTrustManagerFromFile() {
        X509Certificate certificateFromFile = CertUtil.getCertificateFromFile(this.emailAccount.getCertParh());
        if (certificateFromFile == null) {
            LOGGER.error("Not get x509 certificate from file:" + this.emailAccount.getCertParh());
            return null;
        }
        MyTrustManager trustManager = new MyTrustManager(certificateFromFile);
        return trustManager;
    }

    /*
     * Exception decompiling
     */
    private int testContext(TrustManager[] tms, String contextString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setEnabledProtocolsBySocket(String contextString, SSLSocket socket) {
        if (contextString.equals("TLS")) {
            socket.setEnabledProtocols(TLS_PROTOCOLS);
        } else {
            socket.setEnabledProtocols(SSLV3_PROTOCOLS);
        }
    }

    private void closeSocket(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("close socket error.", e);
        }
    }
}

