/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.constant.CliCmdModel;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public interface ICliConnection {
    public static final String CMD_ENTITY = "CMD_ENTITY";

    public String execCmd(String var1) throws ToolException;

    public String execCmdNoLog(String var1) throws ToolException;

    default public String execCmdHasLog(String command) throws ToolException {
        throw new EncapsulatedRuntimeException("method not implements.");
    }

    public String execCmdNoLog(String var1, List<String> var2) throws ToolException;

    public String execCmdNoLogTimout(String var1, int var2) throws ToolException;

    default public String execCmdHasLogTimout(String command, int timeout) throws ToolException {
        throw new EncapsulatedRuntimeException("method not implements.");
    }

    public String execCmdNoLogTimout(String var1, int var2, List<String> var3) throws ToolException;

    public void execCmdWithOutReturn(String var1) throws ToolException;

    public String execCmdWithTimout(String var1, int var2) throws ToolException;

    public void setCLIMode(CliCmdModel var1);

    public void close();

    public void connect() throws ToolException;

    public boolean isConnected();

    public CliRtnEntity asyncExecReturnEntity(String var1, int var2) throws ToolException;

    public CliRtnEntity asyncExecReturnEntity(String var1) throws ToolException;

    public String execCmdWithKeepAlive(String var1, int var2, List<String> var3) throws ToolException;

    public String execCmdWithKeepAlive(String var1, SSHCmdParamEntity var2) throws ToolException;

    public String execCmdWithTimout(String var1, int var2, List<String> var3) throws ToolException;

    public String execCmd(String var1, List<String> var2) throws ToolException;

    public static class SSHCmdParamEntity {
        private volatile Map<String, String> checkEndReplaceMap;
        private Map<String, Object> params;
        private int timeout = -2;
        private String keepAliveMsg;
        private int keepInterval;
        private final Object lock = new Object();
        private boolean ckeckCmdSendResult = true;
        private boolean needLog = true;
        private boolean isProcessKill = true;

        public boolean isNeedLog() {
            return this.needLog;
        }

        public void setNeedLog(boolean isNeedLog) {
            this.needLog = isNeedLog;
        }

        public boolean isCkeckCmdSendResult() {
            return this.ckeckCmdSendResult;
        }

        public void setCkeckCmdSendResult(boolean isCkeckCmdSendResult) {
            this.ckeckCmdSendResult = isCkeckCmdSendResult;
        }

        public List<String> getEndStrs() {
            return this.params == null ? null : (List)this.params.get("_SPEFIC_END_STRS");
        }

        public int getTimeout() {
            return this.timeout;
        }

        public String getKeepAliveMsg() {
            return this.keepAliveMsg;
        }

        public void setKeepAliveMsg(String keepAliveMsg) {
            this.keepAliveMsg = keepAliveMsg;
        }

        public int getKeepInterval() {
            return this.keepInterval;
        }

        public void setKeepInterval(int keepInterval) {
            this.keepInterval = keepInterval;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public Map<String, String> getCheckEndReplaceMap() {
            return this.checkEndReplaceMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEndReplaceMap(String endName, String toRplace) {
            if (this.checkEndReplaceMap == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.checkEndReplaceMap == null) {
                        this.checkEndReplaceMap = new HashMap<String, String>();
                    }
                }
            }
            this.checkEndReplaceMap.put(endName, toRplace);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEndReplaceMap(List<String> endNameList) {
            Iterator<String> iterator = this.lock;
            synchronized (iterator) {
                if (this.checkEndReplaceMap == null) {
                    this.checkEndReplaceMap = new HashMap<String, String>();
                }
            }
            if (endNameList == null) {
                return;
            }
            for (String endName : endNameList) {
                this.checkEndReplaceMap.put(endName, "");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEndStrs(List<String> endStrs) {
            Object object = this.lock;
            synchronized (object) {
                if (this.params == null) {
                    this.params = new HashMap<String, Object>();
                }
            }
            this.params.put("_SPEFIC_END_STRS", endStrs);
        }

        public void setProcessKill(boolean isProcessKill) {
            this.isProcessKill = isProcessKill;
        }

        public boolean isProcessKill() {
            return this.isProcessKill;
        }
    }

    public static final class CliRtnEntity {
        private static final Logger LOGGER = ToolLoggerFactory.getLogger(CliRtnEntity.class);
        private boolean cmdExecOver = true;
        private String execCmd;
        private String cmdReutrn = "";

        public CliRtnEntity(String execCmd) {
            this.execCmd = execCmd;
        }

        public boolean isCmdExecOver() {
            return this.cmdExecOver;
        }

        void setCmdExecOver(boolean cmdExecOver) {
            this.cmdExecOver = cmdExecOver;
        }

        public String getExecCmd() {
            return this.execCmd;
        }

        void setExecCmd(String execCmd) {
            this.execCmd = execCmd;
        }

        public String getCmdReutrn() {
            return this.cmdReutrn;
        }

        public synchronized String getCmdReutrnTillDone() {
            return this.getCmdReutrnTillDone(60000L);
        }

        public synchronized String getCmdReutrnTillDone(long timeOut) {
            try {
                while (!this.cmdExecOver) {
                    this.wait(timeOut);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("exec cmd Interrupted", e);
            }
            catch (Exception e) {
                LOGGER.error("exec cmd other error", e);
            }
            return this.cmdExecOver ? this.cmdReutrn : "";
        }

        void setCmdReutrn(String cmdReutrn) {
            this.cmdReutrn = cmdReutrn;
        }
    }
}

