/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.obase.connection.CustomDefaultSshJudge;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.LocalPortForwarder;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.NetUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class MultiRouteManager
implements Closeable {
    public static final String LOCAL_IP = "127.0.0.1";
    private static final Set<Integer> usingedLocalPorts = new HashSet<Integer>();
    private List<ClientSession> routeTable = new ArrayList<ClientSession>();
    private List<LocalPortForwarder> forwarders = new ArrayList<LocalPortForwarder>();
    private List<MultiRouteNode> multiRouteNodes = new ArrayList<MultiRouteNode>();
    private List<Integer> localListenPorts = new ArrayList<Integer>();

    public MultiRouteManager(List<MultiRouteNode> multiRouteNodes) throws ToolException {
        this.multiRouteNodes.addAll(multiRouteNodes);
        try {
            this.initRoute();
        }
        catch (Exception e) {
            this.close();
            throw new ToolException("sshforward.initforward.err", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRoute() throws ToolException, IOException {
        Set<Integer> set = usingedLocalPorts;
        synchronized (set) {
            this.routeTable = new ArrayList<ClientSession>();
            if (this.multiRouteNodes.isEmpty()) {
                return;
            }
            SshConnection connection = null;
            if (this.multiRouteNodes.size() == 1) {
                MultiRouteNode preNode = this.multiRouteNodes.get(0);
                String pwd = preNode.getPwd();
                connection = new SshConnection(preNode.getHost(), preNode.getUname(), pwd, preNode.getPort());
                connection.initSession();
                this.routeTable.add(connection.getSession());
                pwd = null;
                return;
            }
            Iterator<MultiRouteNode> iters = this.multiRouteNodes.iterator();
            MultiRouteNode curNode = null;
            String preNodeUname = "";
            String preNodePwd = "";
            while (iters.hasNext()) {
                curNode = iters.next();
                if (this.routeTable.isEmpty()) {
                    String pwd = curNode.getPwd();
                    connection = new SshConnection(curNode.getHost(), curNode.getUname(), pwd, curNode.getPort());
                    pwd = null;
                } else {
                    int lastPort = this.localListenPorts.get(this.localListenPorts.size() - 1);
                    connection = new SshConnection(LOCAL_IP, preNodeUname, preNodePwd, lastPort);
                }
                connection.initSession();
                if (iters.hasNext()) {
                    int localAvalibalePort = this.getLocalAviliablePort();
                    MultiRouteNode preNode = this.multiRouteNodes.get(this.multiRouteNodes.indexOf(curNode) + 1);
                    ClientSession session = connection.getSession();
                    LocalPortForwarder fowarder = this.setPortForwardingL(session, localAvalibalePort, preNode.getHost(), preNode.getPort());
                    preNodeUname = preNode.getUname();
                    preNodePwd = preNode.getPwd();
                    this.forwarders.add(fowarder);
                    this.localListenPorts.add(localAvalibalePort);
                    usingedLocalPorts.add(localAvalibalePort);
                }
                this.routeTable.add(connection.getSession());
            }
        }
    }

    private int getLocalAviliablePort() {
        return NetUtil.getValidPort(0);
    }

    public SshConnection getTunnelConnection(DevNode node, ISshJudge iSshJudge, boolean isPwdWillExpireBreak, boolean isDeviceMgr) throws ToolException {
        return this.getTunnelConnection(node, iSshJudge, isPwdWillExpireBreak, isDeviceMgr, sshConnection -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SshConnection getTunnelConnection(DevNode node, ISshJudge iSshJudge, boolean isPwdWillExpireBreak, boolean isDeviceMgr, Consumer<SshConnection> setConnectionCheckingInfo) throws ToolException {
        KeyValue<LocalPortForwarder, Integer> forwarder;
        try {
            forwarder = this.createForwarder(node.getIp(), node.getPort());
        }
        catch (Exception e) {
            throw new ToolException("sshforward.initforward.err", e);
        }
        ToolLoggerFactory.getLogger(this.getClass()).info("getTunnelConnection {}: {} local:{}:{}", node.getIp(), node.getPort(), LOCAL_IP, forwarder.getValue());
        TunnelConnecion targetSshCon = new TunnelConnecion(node, LOCAL_IP, (int)forwarder.getValue(), iSshJudge);
        targetSshCon.setdNode(node);
        setConnectionCheckingInfo.accept(targetSshCon);
        try {
            Set<Integer> set = usingedLocalPorts;
            synchronized (set) {
                targetSshCon.connect(isPwdWillExpireBreak, isDeviceMgr);
            }
        }
        catch (PwdException e) {
            this.handleException(forwarder, e);
            throw e;
        }
        catch (Exception e) {
            this.handleException(forwarder, e);
            throw new ToolException("sshforward.connect2dev.err", e);
        }
        return targetSshCon;
    }

    private void handleException(KeyValue<LocalPortForwarder, Integer> forwarder, Exception e) {
        LocalPortForwarder fw = forwarder.getKey();
        if (null != fw) {
            try {
                fw.close();
            }
            catch (IOException e1) {
                ToolLoggerFactory.getLogger(this.getClass()).error("", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValue<LocalPortForwarder, Integer> createForwarder(String ip, int port) throws IOException {
        Set<Integer> set = usingedLocalPorts;
        synchronized (set) {
            LocalPortForwarder portForwarder = null;
            int avaPort = -1;
            ClientSession session = this.routeTable.get(this.routeTable.size() - 1);
            avaPort = this.getLocalAviliablePort();
            portForwarder = this.setPortForwardingL(session, avaPort, ip, port);
            usingedLocalPorts.add(avaPort);
            this.forwarders.add(portForwarder);
            KeyValue<LocalPortForwarder, Integer> keyValue = new KeyValue<LocalPortForwarder, Integer>(portForwarder, avaPort);
            return keyValue;
        }
    }

    private LocalPortForwarder setPortForwardingL(ClientSession session, int localPort, String host, int port) throws IOException {
        try {
            SshdSocketAddress socketAddress = session.startLocalPortForwarding(localPort, new SshdSocketAddress(host, port));
            return new LocalPortForwarder(session, socketAddress, host, port);
        }
        catch (IOException e) {
            throw new IOException("create forwarder error.", e);
        }
    }

    public int createForwarderLocalPort(String ip, int port) throws IOException {
        return this.createForwarder(ip, port).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Set<Integer> set = usingedLocalPorts;
        synchronized (set) {
            int index;
            ToolLoggerFactory.getLogger(this.getClass()).info("close ssh route manager.");
            if (!this.forwarders.isEmpty()) {
                for (index = this.forwarders.size() - 1; index >= 0; --index) {
                    LocalPortForwarder fw = this.forwarders.get(index);
                    try {
                        fw.close();
                        continue;
                    }
                    catch (Exception e) {
                        ToolLoggerFactory.getLogger(this.getClass()).error("close ssh forward port error.", e);
                    }
                }
                this.forwarders = new ArrayList<LocalPortForwarder>();
            }
            for (index = this.routeTable.size() - 1; index >= 0; --index) {
                ClientSession session = this.routeTable.get(index);
                try {
                    session.close();
                    continue;
                }
                catch (IOException e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("MultiNode close error.", e);
                }
            }
            usingedLocalPorts.removeAll(this.localListenPorts);
        }
    }

    public class TunnelConnecion
    extends SshConnection {
        private String devIp;
        private int devPort;

        public TunnelConnecion(DevNode node, String sshHostname, int port) {
            super(sshHostname, node.getLoginUser(), port, node.getPriKey(), (ISshJudge)new CustomDefaultSshJudge());
            this.devIp = node.getIp();
            this.devPort = node.getPort();
        }

        TunnelConnecion(DevNode node, String sshHostname, int port, ISshJudge sshJudge) {
            super(sshHostname, node.getLoginUser(), port, node.getPriKey(), sshJudge);
            this.devIp = node.getIp();
            this.devPort = node.getPort();
        }

        private MultiRouteManager getMultiRouteManager() {
            return MultiRouteManager.this;
        }

        @Override
        public void close() {
            ToolLoggerFactory.getLogger(this.getClass()).info("Enter tunnelconnection close Method.");
            super.close();
            try {
                this.getMultiRouteManager().close();
                ToolLoggerFactory.getLogger(this.getClass()).info("close TunnelConnecion to the " + super.getHost());
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("close forwarder error.", e);
            }
        }

        @Override
        public synchronized void reConnect() throws ToolException {
            ToolLoggerFactory.getLogger(this.getClass()).info("Enter reConnect Method: " + this.devIp + " " + this.devPort);
            this.close();
            try {
                MultiRouteManager.this.initRoute();
                KeyValue<LocalPortForwarder, Integer> forwarder = MultiRouteManager.this.createForwarder(this.devIp, this.devPort);
                super.rebuildConn(this.getHost(), forwarder.getValue());
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("reBuildConnect error.", e);
                this.close();
                throw new ToolException("reBuildConnect error.", e);
            }
            catch (Exception e1) {
                ToolLoggerFactory.getLogger(this.getClass()).error("reBuildConnect error.", e1);
                this.close();
                throw new ToolException("reBuildConnect error.", e1);
            }
            try {
                this.connect();
                ToolLoggerFactory.getLogger(this.getClass()).info("MultiNode reConnect success.");
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("MultiNode reConnect error.", e);
                this.close();
                throw new ToolException("MultiNode reConnect error.", e);
            }
        }
    }
}

