/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Serializable;

public final class MultiRouteNode
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8746616527932445026L;
    private String host;
    private int port;
    private String uname;
    private String pwd;
    private String rootPwd;

    public MultiRouteNode(String host, int port, String uname, String pwd) {
        this.host = host;
        this.port = port;
        this.uname = uname;
        this.setPwd(pwd);
    }

    public MultiRouteNode(String host, int port, String uname, String pwd, String rootPwd) {
        this(host, port, uname, pwd);
        this.setRootPwd(rootPwd);
    }

    public void setPwd(String pwd) {
        this.pwd = AESEncrypt.encrypt((String)pwd);
    }

    private void setRootPwd(String rootPwd) {
        this.rootPwd = AESEncrypt.encrypt((String)rootPwd);
    }

    public void setEcptPwd(String ecptPwd) {
        this.pwd = ecptPwd;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUname() {
        return this.uname;
    }

    public String getPwd() {
        return AESEncrypt.decrypt((String)this.pwd);
    }

    public String getRootPwd() {
        return AESEncrypt.decrypt((String)this.rootPwd);
    }

    public String getEcptPwd() {
        return this.pwd;
    }

    public boolean isValid() {
        if (!StringUtils.isFullIpAddress(this.host) && !StringUtils.isIpv6Address(this.host)) {
            return false;
        }
        if (StringUtils.hasNULLStr(this.uname, this.pwd)) {
            return false;
        }
        return 0 <= this.port && this.port <= 65535;
    }

    public Object clone() throws CloneNotSupportedException {
        return (MultiRouteNode)super.clone();
    }

    public String toString() {
        return "MultiRouteNode{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

