/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.base.utils.StringUtils;
import java.util.Locale;

public final class SshErrParser {
    private static final String USER_REACHE_UPLIMIT = "The number of users has reached the upper limit.";
    private static final String USER_REACHE_IPLIMIT_KUNPENG = "The number of users that log in through the CLI has reached the upper limit";
    private static final String USER_REACHE_IPLIMIT_A800 = "the number of CLI login accounts reaches 4";
    private static final String USER_REACHE_UPLIMIT_MEMEROY = "the number of users that log in through the CLI reaches";
    private static final String PWD_EXPIRED_CLI_RETURN = "The password has expired. Please change the password and log in to the system using the new password.";
    private static final String PWD_UNSAFE_CLI_RETURN = "For account security, change the password and relog in to the system.";
    private static final String PWD_WILL_EXPIRE_CLI_RETURN = "The password is about to expire. Change the password immediately?(y/n)";
    private static final String INITPWD_NOT_CHANGE_CLI_RETURN = "For security purposes, please change the initial password and log in to the system using the new password.";
    private static final String PWD_NEED_INITIALIZE_CLI_RETURN = "New password:";
    private static final String LOGINCLIS_OVERRUN_LOWER_CLI_RETURN = "Quit one or more logged-in CLIs, or release some memory space and try again later.";
    private static final String LOGINCLIS_OVERRUN_OUTSVP_CLI_RETURN_PRE = "There are more than ";
    private static final String LOGINCLIS_OVERRUN_OUTSVP_CLI_RETURN_POST = "processes of ismcli in system, do not run CLI. Please try again later.";
    private static final String ROOT_INITPWD_NOT_CHANGE_CLI_RETURN = "you are required to change your password immediately (root enforced)";
    private static final String CONNECT_TIME_OUT = "connection timed out";
    private static final String CONNECT_TIME_OUT_ID = "ssh.connect.timed.out";
    private static final String CONNECT_AUTH_FAIL = "auth fail";
    private static final String CONNECT_AUTH_FAIL_ID = "ssh.connect.auth.fail";
    private static final String KEY_FILE_NOFOUND = "filenotfoundexception";
    private static final String KEY_FILE_NOFOUND_ID = "ssh.connect.key.nofound";
    private static final String KEY_AUTH_NOSUPPORT = "shouldn't use publickey";
    private static final String KEY_AUTH_NOSUPPORT_ID = "ssh.connect.auth.nosupport.key";
    private static final String PWD_AUTH_NOSUPPORT = "shouldn't use password";
    private static final String PWD_AUTH_NOSUPPORT_ID = "ssh.connect.auth.nosupport.pwd";
    private static final String CONNECT_UNKNOW_ERR = "ssh.connect.unknow.error";
    private static final String SECURITY_ALGORITHM_ERR_RETURN = "negotiate key exchange for kex algorithms";
    public static final String SECURITY_ALGORITHM_ERR_ID = "ssh.connect.security.algorithm.error";

    private SshErrParser() {
    }

    public static boolean isInitPwdNotChanged(String temp) {
        return temp.contains(INITPWD_NOT_CHANGE_CLI_RETURN);
    }

    public static boolean isNeedInitPassword(String temp) {
        return temp.endsWith(PWD_NEED_INITIALIZE_CLI_RETURN);
    }

    public static boolean isPwdWillExpire(String temp) {
        return temp.contains(PWD_WILL_EXPIRE_CLI_RETURN);
    }

    public static boolean isPwdExpired(String temp) {
        return temp.contains(PWD_EXPIRED_CLI_RETURN);
    }

    public static boolean isSecurityAlgorithmExpired(String errorMsg) {
        return errorMsg.contains(SECURITY_ALGORITHM_ERR_RETURN);
    }

    public static String getConErrId(String message) {
        if (message.toLowerCase(Locale.ENGLISH).contains(CONNECT_TIME_OUT)) {
            return CONNECT_TIME_OUT_ID;
        }
        if (message.toLowerCase(Locale.ENGLISH).contains(CONNECT_AUTH_FAIL)) {
            return CONNECT_AUTH_FAIL_ID;
        }
        if (message.toLowerCase(Locale.ENGLISH).contains(KEY_FILE_NOFOUND)) {
            return KEY_FILE_NOFOUND_ID;
        }
        if (message.toLowerCase(Locale.ENGLISH).contains(KEY_AUTH_NOSUPPORT)) {
            return KEY_AUTH_NOSUPPORT_ID;
        }
        if (message.toLowerCase(Locale.ENGLISH).contains(PWD_AUTH_NOSUPPORT)) {
            return PWD_AUTH_NOSUPPORT_ID;
        }
        return CONNECT_UNKNOW_ERR;
    }

    public static boolean isPwdUnSafe(String result) {
        return !StringUtils.isNULLStr((String)result) && result.contains(PWD_UNSAFE_CLI_RETURN);
    }

    public static boolean isLoginCLIsOverrun(String result) {
        if (result.contains(LOGINCLIS_OVERRUN_OUTSVP_CLI_RETURN_PRE) && result.contains(LOGINCLIS_OVERRUN_OUTSVP_CLI_RETURN_POST)) {
            return true;
        }
        return result.contains(LOGINCLIS_OVERRUN_LOWER_CLI_RETURN) || result.contains(USER_REACHE_UPLIMIT) || result.contains(USER_REACHE_UPLIMIT_MEMEROY) || result.contains(USER_REACHE_IPLIMIT_KUNPENG) || result.contains(USER_REACHE_IPLIMIT_A800);
    }

    public static boolean isRootInitPwdNotChanged(String result) {
        if (StringUtils.isNULLStr((String)result)) {
            return false;
        }
        return result.contains(ROOT_INITPWD_NOT_CHANGE_CLI_RETURN);
    }
}

