/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection.ssh;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshKnownHostsManager {
    private static final Logger log = LoggerFactory.getLogger(SshKnownHostsManager.class);
    private static final Map<String, String> KNOWN_HOSTS = new ConcurrentHashMap<String, String>();
    private static final Map<String, Boolean> SSH_HOST_SHOULD_VERIFY_MAP = new ConcurrentHashMap<String, Boolean>();
    public static final String SSH_HOST_KEY = "sshHostKey";
    public static final String IS_VERIFY_SSH_HOST_KEY = "isVerifySshHostKey";

    public static boolean isHostAdded(String host) {
        return KNOWN_HOSTS.containsKey(host);
    }

    public static void cacheHostKey(String ip, String hostKeyInfo) {
        KNOWN_HOSTS.put(ip, hostKeyInfo);
    }

    public static void removeHost(String host) {
        if (host != null && KNOWN_HOSTS.containsKey(host)) {
            KNOWN_HOSTS.remove(host);
        }
    }

    public static String getHostKeyInfo(String host) {
        return KNOWN_HOSTS.getOrDefault(host, "");
    }

    public static void cacheHostKeyInfoVerifyFlag(String host, boolean shouldVerifyHostKeyInfo) {
        SSH_HOST_SHOULD_VERIFY_MAP.put(host, shouldVerifyHostKeyInfo);
    }

    public static boolean isVerifySshHostKeyInfo(String host) {
        return SSH_HOST_SHOULD_VERIFY_MAP.getOrDefault(host, false);
    }

    private SshKnownHostsManager() {
    }
}

