/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection.support;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;

public class CmdRequestBean {
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final char BACKUP = '\b';
    private static final Logger SSHLOGGER = ToolLoggerFactory.getLogger(CmdRequestBean.class);
    private ByteArrayOutputStream stdoutSB = new ByteArrayOutputStream();
    private ByteArrayOutputStream stderrSB = new ByteArrayOutputStream();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendStdout(byte[] curOutArray) {
        int len = curOutArray.length;
        if (len < 1) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.stdoutSB.write(curOutArray, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendStderr(byte[] curErrArray) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrSB.write(curErrArray, 0, curErrArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStdoutResult(boolean isFlush) {
        Object object = this.lock;
        synchronized (object) {
            String temp = "";
            try {
                temp = new String(this.stdoutSB.toByteArray(), 0, this.stdoutSB.size(), DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                SSHLOGGER.error("get stdout result error!", e);
            }
            temp = this.clearBackChar(temp);
            if (isFlush) {
                this.stdoutSB = new ByteArrayOutputStream();
            }
            return temp;
        }
    }

    private String clearBackChar(String temp) {
        if (-1 == temp.indexOf(8)) {
            return temp;
        }
        StringBuilder sb = new StringBuilder(temp.length());
        for (int index = 0; index < temp.length(); ++index) {
            char currentChar = temp.charAt(index);
            if (currentChar == '\b' && sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                continue;
            }
            if (currentChar == '\b' && sb.length() == 0) continue;
            sb.append(currentChar);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStderrResult(boolean isFlush) {
        Object object = this.lock;
        synchronized (object) {
            String temp = "";
            try {
                temp = new String(this.stderrSB.toByteArray(), 0, this.stderrSB.size(), DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                SSHLOGGER.error("get stderr result error!", e);
            }
            temp = this.clearBackChar(temp);
            if (isFlush) {
                this.stderrSB = new ByteArrayOutputStream();
            }
            return temp;
        }
    }
}

