/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum DiskTypeEnum {
    SAS("sas_disk", null),
    SAS_ENCRYPTED("sas_encrypted", SAS),
    SATA("sata_disk", null),
    SATA_ENCRYPTED("sata_encrypted", SATA),
    SSD("ssd_disk", null),
    SSD_CARD_AND_NVME_SSD("ssd_card", null),
    SSD_CARD_AND_NVME_SSD_ENCRYPTED("ssd_card_encrypted", SSD_CARD_AND_NVME_SSD),
    SSD_CARD_AND_NVME_SSD_NORMAL("ssd_card_normal", null),
    SSD_CARD_AND_NVME_SSD_NORMAL_ENCRYPTED("ssd_card_normal_encrypted", SSD_CARD_AND_NVME_SSD_NORMAL),
    SSD_CARD_AND_NVME_SSD_ZERO_OP("ssd_card_zero_op", SSD_CARD_AND_NVME_SSD),
    SSD_CARD_AND_NVME_SSD_ZERO_OP_ENCRYPTED("ssd_card_zero_op_encrypted", SSD_CARD_AND_NVME_SSD),
    SSD_CARD_AND_NVME_SSD_QLC("ssd_card_qlc", SSD_CARD_AND_NVME_SSD),
    SSD_CARD_AND_NVME_SSD_QLC_ENCRYPTED("ssd_card_qlc_encrypted", SSD_CARD_AND_NVME_SSD),
    ENCRYPT("1", null),
    UNKNOWN("unknown", null);

    private final String diskType;
    public final DiskTypeEnum mainType;

    public String toString() {
        return ResourceUtil.getString("disk.type." + super.toString());
    }

    public static List<DiskTypeEnum> getAllFlashTypes() {
        return Arrays.asList(SSD_CARD_AND_NVME_SSD, SSD_CARD_AND_NVME_SSD_ENCRYPTED, SSD_CARD_AND_NVME_SSD_QLC, SSD_CARD_AND_NVME_SSD_QLC_ENCRYPTED, SSD_CARD_AND_NVME_SSD_ZERO_OP, SSD_CARD_AND_NVME_SSD_ZERO_OP_ENCRYPTED, SSD);
    }

    public static DiskTypeEnum getDiskTypeEnum(String description) {
        if (SSD_CARD_AND_NVME_SSD_NORMAL.toString().equals(description)) {
            return SSD_CARD_AND_NVME_SSD;
        }
        if (SSD_CARD_AND_NVME_SSD_NORMAL_ENCRYPTED.toString().equals(description)) {
            return SSD_CARD_AND_NVME_SSD_ENCRYPTED;
        }
        for (DiskTypeEnum value : DiskTypeEnum.values()) {
            if (!value.toString().equals(description) && !value.getDiskType().equals(description)) continue;
            return value;
        }
        return null;
    }

    public static DiskTypeEnum getDiskType(String diskType) {
        return Arrays.stream(DiskTypeEnum.values()).filter(value -> value.getDiskType().equals(diskType)).findFirst().orElse(UNKNOWN);
    }

    public static boolean isExtendDiskType(DiskTypeEnum typeEnum) {
        return Objects.nonNull((Object)typeEnum.mainType);
    }

    public String toShowInExpansion() {
        if (SSD_CARD_AND_NVME_SSD.equals((Object)this)) {
            return SSD_CARD_AND_NVME_SSD_NORMAL.toString();
        }
        if (SSD_CARD_AND_NVME_SSD_ENCRYPTED.equals((Object)this)) {
            return SSD_CARD_AND_NVME_SSD_NORMAL_ENCRYPTED.toString();
        }
        return this.toString();
    }

    private DiskTypeEnum(String diskType, DiskTypeEnum mainType) {
        this.diskType = diskType;
        this.mainType = mainType;
    }

    public String getDiskType() {
        return this.diskType;
    }
}

