/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.mails;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.mails.EmailEntity;
import com.huawei.ism.tool.obase.mails.MailInfo;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailConfigKeeper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailConfigKeeper.class);
    private static final String MAIL_INFO_FILE_PATH = ApplicationContext.getInstance().getTmpPath() + "callhome_mail_config.properties";
    private static final String MAIL_RECEIVE_ADDRESS = "mail.config.reciveaddress";
    private static final String MAIL_SEND_ADDRESS = "mail.config.sendaddress";
    private static final String MAIL_IS_VALIDATE = "mail.config.isvalidate";
    private static final String SMTP_IP = "mail.config.smtp.ip";
    private static final String SMTP_PORT = "mail.config.smtp.port";
    private static final String SMTP_USER_NAME = "mail.config.smtp.username";
    private static final String SMTP_PSTR = "mail.config.smtp.passdstr";
    private static final String HEART_MAIL_ENABLE = "mail.config.heartmail.enable";
    private static final String HEART_MAIL_RECEIVE_ADDRESS = "mail.config.heartmail.receive.address";
    private static final String SMTP_PWD_TYPE = "mail.config.pwtype";
    private static final String SMTP_PWD_TYPE_VALUE = "encrypt";
    private static final String SMTP_TLS = "mail.config.istls";
    private static final String SMTP_SECURED_TLS = "mail.config.issecuredtls";
    private static final String SMTP_NON = "mail.config.isNon";
    private static final String MAIL_CERT_PATH = "mail.config.certPath";
    private static final MailConfigKeeper INSTANCE = new MailConfigKeeper();
    private MailInfo mailInfo = null;
    private Properties properties = null;
    private final Object lock = new Object();
    private String certParh = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailConfigKeeper() {
        LOGGER.info("just once init");
        Object object = this.lock;
        synchronized (object) {
            this.initSetupMailInfo();
        }
    }

    public static MailConfigKeeper getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailInfo getMailInfo() {
        Object object = this.lock;
        synchronized (object) {
            boolean isnull = StringUtils.isNULLStr(this.mailInfo.getUser().getPassword());
            if (isnull && this.mailInfo.isNeedValidate()) {
                LOGGER.error("Get validate user error.");
                return new MailInfo();
            }
        }
        return this.mailInfo.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveMailInfo(MailInfo info) {
        Object object = this.lock;
        synchronized (object) {
            return this.saveMailInfoPrivate(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveMailInfoPrivate(MailInfo info) {
        File mailFile = this.retrieveFile();
        if (mailFile == null) {
            return false;
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(mailFile));
            if (this.properties != null) {
                this.properties.setProperty(MAIL_RECEIVE_ADDRESS, String.valueOf(info.getReceiveAddressesString()));
                this.properties.setProperty(MAIL_SEND_ADDRESS, String.valueOf(info.getSendAddress()));
                this.properties.setProperty(MAIL_IS_VALIDATE, String.valueOf(info.isNeedValidate()));
                this.properties.setProperty(SMTP_IP, String.valueOf(info.getSmtpIP()));
                this.properties.setProperty(SMTP_PORT, String.valueOf(info.getSmtpPort()));
                this.properties.setProperty(SMTP_USER_NAME, String.valueOf(info.getUser().getUserName()));
                this.properties.setProperty(MAIL_CERT_PATH, info.getCertParh());
                String plaintPstr = String.valueOf(info.getUser().getPassword());
                String pStr = AESEncrypt.encrypt((String)plaintPstr);
                plaintPstr = null;
                if (StringUtils.isNULLStr(pStr)) {
                    pStr = "";
                }
                this.properties.setProperty(SMTP_PSTR, pStr);
                this.properties.setProperty(HEART_MAIL_ENABLE, String.valueOf(info.isEnableMaintainMail()));
                this.properties.setProperty(HEART_MAIL_RECEIVE_ADDRESS, info.getMaintainMailAddress());
                this.properties.setProperty(SMTP_PWD_TYPE, SMTP_PWD_TYPE_VALUE);
                this.properties.setProperty(SMTP_TLS, String.valueOf(info.isTls()));
                this.properties.setProperty(SMTP_SECURED_TLS, String.valueOf(info.isSecuredTls()));
                this.properties.setProperty(SMTP_NON, String.valueOf(info.isNonRadio()));
                this.properties.store(out, "");
            }
        }
        catch (IOException e) {
            LOGGER.error("open alarm setup file outputstream failed!!!", e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e1) {
            LOGGER.error("open alarm setup file outputstream failed!!!", e1);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != this.properties) {
                this.properties.clear();
            }
            StreamUtils.closeResource(out, out);
        }
        this.mailInfo = info.copy();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSetupMailInfoForUpgradeInstall() {
        Object object = this.lock;
        synchronized (object) {
            this.initSetupMailInfo();
        }
    }

    public void initMailInfo(EmailEntity emailEntity) {
        this.mailInfo.setSmtpIP(emailEntity.getStmpServer());
        this.mailInfo.setSmtpPort(emailEntity.getSmtpPort());
        this.mailInfo.setSendAddress(emailEntity.getFromEmail());
        this.mailInfo.setNonRadio(emailEntity.isNonRadio());
        this.mailInfo.setNeedValidate(emailEntity.isAuth());
        String pwd = emailEntity.getPassword();
        User user = new User(emailEntity.getAccount(), pwd);
        this.mailInfo.setUser(user);
        String toMail = emailEntity.getToEmail();
        this.mailInfo.setReceiveAddresses(Arrays.asList(toMail.split(";")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSetupMailInfo() {
        this.mailInfo = new MailInfo();
        this.properties = new Properties();
        File setupFile = this.retrieveFile();
        if (setupFile == null) {
            return;
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(setupFile));
            this.properties.load(is);
            this.mailInfo.setReceiveAddresses(this.parseReceiveAddresses(this.properties));
            this.mailInfo.setSendAddress(this.parseString(this.properties, MAIL_SEND_ADDRESS));
            this.mailInfo.setSmtpIP(this.parseIP(this.properties, SMTP_IP));
            this.mailInfo.setSmtpPort(this.parsePort(this.properties, SMTP_PORT));
            this.mailInfo.setNeedValidate(this.parseBoolean(this.properties, MAIL_IS_VALIDATE, false));
            this.mailInfo.setCertParh(this.parseString(this.properties, MAIL_CERT_PATH));
            if (StringUtils.isNULLStr(this.mailInfo.getSmtpIP())) {
                this.mailInfo.setTls(true);
            } else {
                this.mailInfo.setTls(this.parseBoolean(this.properties, SMTP_TLS, false));
                this.mailInfo.setSecuredTls(this.parseBoolean(this.properties, SMTP_SECURED_TLS, false));
            }
            this.mailInfo.setNonRadio(this.parseBoolean(this.properties, SMTP_NON, false));
            String userName = this.parseString(this.properties, SMTP_USER_NAME);
            String password = this.parseString(this.properties, SMTP_PSTR);
            String pwdType = this.parseString(this.properties, SMTP_PWD_TYPE);
            if (SMTP_PWD_TYPE_VALUE.equals(pwdType)) {
                password = AESEncrypt.decrypt((String)password);
            }
            this.mailInfo.setUser(new User(userName, password));
            this.mailInfo.setEnableMaintainMail(this.parseBoolean(this.properties, HEART_MAIL_ENABLE, Boolean.valueOf(this.parseString(this.properties, HEART_MAIL_ENABLE))));
            this.mailInfo.setMaintainMailAddress(this.parseString(this.properties, HEART_MAIL_RECEIVE_ADDRESS));
            if (!SMTP_PWD_TYPE_VALUE.equals(pwdType)) {
                this.saveMailInfo(this.mailInfo.copy());
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("create alarm setup file stream error!", e);
            return;
        }
        catch (Exception e1) {
            LOGGER.error("create alarm setup file stream error!", e1);
            return;
        }
        finally {
            this.properties.clear();
            StreamUtils.closeResource(null, is);
        }
    }

    private List<String> parseReceiveAddresses(Properties prop) {
        ArrayList<String> receiverList = new ArrayList<String>();
        String addressesString = prop.getProperty(MAIL_RECEIVE_ADDRESS);
        if (!StringUtils.isNULLStr(addressesString)) {
            String[] addresses = addressesString.split(";");
            receiverList.addAll(new ArrayList<String>(Arrays.asList(addresses)));
        }
        return receiverList;
    }

    private String parseString(Properties prop, String key) {
        return this.parseString(prop, key, "");
    }

    private String parseString(Properties prop, String key, String defaultValue) {
        String value = prop.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private int parsePort(Properties prop, String key) {
        String value = prop.getProperty(key);
        if (StringUtils.isNULLStr(value)) {
            return 25;
        }
        return Integer.parseInt(value);
    }

    private boolean parseBoolean(Properties prop, String key, boolean defaultValue) {
        String value = prop.getProperty(key);
        if (StringUtils.isNULLStr(value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private String parseIP(Properties prop, String key) {
        String ip = prop.getProperty(key, "");
        return ip;
    }

    private File retrieveFile() {
        try {
            File setupFile = FilePathUtils.checkFile((File)new File(MAIL_INFO_FILE_PATH));
            if (setupFile.exists()) {
                return setupFile;
            }
            boolean result = false;
            if (!setupFile.getParentFile().exists() && !(result = setupFile.getParentFile().mkdirs())) {
                return null;
            }
            result = setupFile.createNewFile();
            if (result) {
                return setupFile;
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.error("retrieve alarm setup file failed!", e);
            return null;
        }
    }

    public String getCertPath() {
        if ("".equals(this.mailInfo.getCertParh())) {
            return this.certParh;
        }
        return this.mailInfo.getCertParh();
    }

    public void setCertParh(String certParh) {
        this.certParh = certParh;
    }
}

