/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp.utils;

import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPConstants;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPOption;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public final class DHCPResponseFactory {
    private DHCPResponseFactory() {
        throw new UnsupportedOperationException();
    }

    public static DHCPPacket makeDHCPOffer(DHCPPacket request, InetAddress offeredAddress, int leaseTime, InetAddress serverIdentifier, String message, DHCPOption[] options) throws ToolException {
        DHCPResponseFactory.checkRequest(request);
        Byte requestMessageType = request.getDHCPMessageType();
        if (null == requestMessageType || 1 != requestMessageType) {
            throw new ToolException("request is not DHCPDISCOVER");
        }
        if (offeredAddress == null) {
            throw new IllegalArgumentException("offeredAddress must not be null");
        }
        if (!(offeredAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("offeredAddress must be IPv4");
        }
        DHCPPacket response = new DHCPPacket();
        response.setOp((byte)2);
        response.setHtype(request.getHtype());
        response.setHlen(request.getHlen());
        response.setXid(request.getXid());
        response.setFlags(request.getFlags());
        response.setYiaddr(offeredAddress);
        response.setGiaddrRaw(request.getGiaddrRaw());
        response.setChaddr(request.getChaddr());
        response.setDHCPMessageType((byte)2);
        response.setOptionAsInt((byte)51, leaseTime);
        response.setOptionAsInetAddress((byte)54, serverIdentifier);
        response.setOptionAsString((byte)56, message);
        if (options != null) {
            for (DHCPOption opt : options) {
                response.setOption(opt.applyOption(request));
            }
        }
        response.setAddrPort(DHCPResponseFactory.getDefaultSocketAddress(request, (byte)2));
        return response;
    }

    public static DHCPPacket makeDHCPAck(DHCPPacket request, InetAddress offeredAddress, int leaseTime, InetAddress serverIdentifier, String message, DHCPOption[] options) throws ToolException {
        DHCPResponseFactory.checkRequest(request);
        Byte requestMessageType = request.getDHCPMessageType();
        if (null == requestMessageType || 3 != requestMessageType && 8 != requestMessageType) {
            throw new ToolException("request is not DHCPREQUEST/DHCPINFORM");
        }
        if (offeredAddress == null) {
            throw new IllegalArgumentException("offeredAddress must not be null");
        }
        if (!(offeredAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("offeredAddress must be IPv4");
        }
        DHCPPacket resp = new DHCPPacket();
        resp.setOp((byte)2);
        if (requestMessageType != 8) {
            resp.setYiaddr(offeredAddress);
        }
        resp.copyAttributes(request);
        resp.setDHCPMessageType((byte)5);
        if (requestMessageType == 3) {
            resp.setOptionAsInt((byte)51, leaseTime);
        }
        resp.setOptionAsInetAddress((byte)54, serverIdentifier);
        resp.setOptionAsString((byte)56, message);
        if (options != null) {
            for (DHCPOption opt : options) {
                resp.setOption(opt.applyOption(request));
            }
        }
        resp.setAddrPort(DHCPResponseFactory.getDefaultSocketAddress(request, (byte)5));
        return resp;
    }

    public static DHCPPacket makeDHCPNak(DHCPPacket request, InetAddress serverIdentifier, String message) throws ToolException {
        DHCPResponseFactory.checkRequest(request);
        Byte requestMessageType = request.getDHCPMessageType();
        if (null == requestMessageType || requestMessageType != 3) {
            throw new ToolException("request is not DHCPREQUEST");
        }
        DHCPPacket resp = new DHCPPacket();
        resp.setOp((byte)2);
        resp.setHtype(request.getHtype());
        resp.setHlen(request.getHlen());
        resp.setXid(request.getXid());
        resp.setFlags(request.getFlags());
        resp.setGiaddrRaw(request.getGiaddrRaw());
        resp.setChaddr(request.getChaddr());
        resp.setDHCPMessageType((byte)6);
        resp.setOptionAsInetAddress((byte)54, serverIdentifier);
        resp.setOptionAsString((byte)56, message);
        resp.setAddrPort(DHCPResponseFactory.getDefaultSocketAddress(request, (byte)6));
        return resp;
    }

    public static InetSocketAddress getDefaultSocketAddress(DHCPPacket request, byte responseType) {
        InetSocketAddress sockAdr;
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        InetAddress giaddr = request.getGiaddr();
        InetAddress ciaddr = request.getCiaddr();
        switch (responseType) {
            case 2: 
            case 5: {
                if (DHCPConstants.INADDR_ANY.equals(giaddr)) {
                    if (DHCPConstants.INADDR_ANY.equals(ciaddr)) {
                        sockAdr = new InetSocketAddress(DHCPConstants.INADDR_BROADCAST, 68);
                        break;
                    }
                    sockAdr = new InetSocketAddress(ciaddr, 68);
                    break;
                }
                sockAdr = new InetSocketAddress(giaddr, 67);
                break;
            }
            case 6: {
                if (DHCPConstants.INADDR_ANY.equals(giaddr)) {
                    sockAdr = new InetSocketAddress(DHCPConstants.INADDR_BROADCAST, 68);
                    break;
                }
                sockAdr = new InetSocketAddress(giaddr, 67);
                break;
            }
            default: {
                throw new IllegalArgumentException("responseType not valid");
            }
        }
        return sockAdr;
    }

    private static void checkRequest(DHCPPacket request) throws ToolException {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        if (!request.isDhcp()) {
            throw new ToolException("request is BOOTP");
        }
        Byte requestMessageType = request.getDHCPMessageType();
        if (requestMessageType == null) {
            throw new ToolException("request has no message type");
        }
    }
}

