/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp.utils;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPCoreServer;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPPacket;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPServlet;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.slf4j.Logger;

public class DHCPServletDispatcherThread
implements Runnable {
    private static final Logger DISPATCHERLOGGER = ToolLoggerFactory.getLogger(DHCPServletDispatcherThread.class);
    private final DHCPCoreServer server;
    private final DHCPServlet dispatchServlet;
    private final DatagramPacket dispatchPacket;

    public DHCPServletDispatcherThread(DHCPCoreServer server, DHCPServlet servlet, DatagramPacket req) {
        this.server = server;
        this.dispatchServlet = servlet;
        this.dispatchPacket = req;
    }

    @Override
    public void run() {
        try {
            DHCPPacket response = this.dispatchServlet.serviceDatagram(this.dispatchPacket);
            if (response == null) {
                return;
            }
            InetAddress address = response.getAddress();
            if (address == null) {
                String errorMsg = "Address/port address of the machine,\n which this datagram is being sent to is null.";
                DISPATCHERLOGGER.error(errorMsg);
                return;
            }
            int port = response.getPort();
            byte[] responseBuf = response.serialize();
            DatagramPacket responseDatagram = new DatagramPacket(responseBuf, responseBuf.length, address, port);
            this.dispatchServlet.postProcess(this.dispatchPacket, responseDatagram);
            this.server.sendResponse(responseDatagram);
            if (response.isOfferIpPacket()) {
                String clientMac = response.getChaddrMac();
                InetAddress inetAddress = response.getYiaddr();
                String offerIpAddress = "";
                if (null != inetAddress) {
                    offerIpAddress = inetAddress.getHostAddress();
                    this.dispatchServlet.addOfferIP(clientMac, offerIpAddress);
                }
                InetAddress maskAddress = response.getOptionAsInetAddr((byte)1);
                String mask = "";
                if (null != maskAddress) {
                    mask = maskAddress.getHostAddress();
                }
                if (DISPATCHERLOGGER.isInfoEnabled()) {
                    DISPATCHERLOGGER.info("Rent ip: " + offerIpAddress + " netmask: " + mask + " to client " + clientMac);
                }
            }
        }
        catch (Exception e) {
            DISPATCHERLOGGER.error("Datagram dispatch error.", e);
        }
    }
}

