/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.simu;

import com.huawei.ism.tool.obase.simu.EchoMeta;
import com.huawei.ism.tool.obase.simu.LimitQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EchoCache {
    private List<EchoMeta> allEchos = new ArrayList<EchoMeta>();
    private Map<String, Integer> commonEchoMap = new HashMap<String, Integer>();
    private Map<String, List<Integer>> extraEchoMap = new HashMap<String, List<Integer>>();
    private int index = 0;
    private EchoMeta lastEcho;
    private LimitQueue<String> historyCmdQueue = new LimitQueue(15);
    private static List<String> qaucliEndStr = new ArrayList<String>();
    private static List<String> formatEndStr = new ArrayList<String>();
    private static List<String> specialSqlCmds = new ArrayList<String>();

    public void put(String cmd, EchoMeta echoMeta) {
        this.saveCommonCmd(cmd, echoMeta);
        if (cmd.endsWith("qaucli")) {
            this.saveQaucliCmd(cmd, echoMeta, "qaucli", qaucliEndStr);
        } else if (cmd.contains("format")) {
            this.saveQaucliCmd(cmd, echoMeta, "format", formatEndStr);
        } else if (cmd.contains("interactivecmd")) {
            this.saveInteractiveCmd(cmd, echoMeta);
        }
        echoMeta.setData(null);
    }

    private void saveQaucliCmd(String cmd, EchoMeta echoMeta, String maincmd, List<String> endStrs) {
        Pattern pattern = Pattern.compile("echo\\s+[-e]{2}(.*)\\|.*");
        Matcher matcher = pattern.matcher(cmd);
        if (!matcher.matches()) {
            return;
        }
        String temp = matcher.group(1).trim();
        temp = temp.substring(1, temp.length() - 1);
        String[] cmds = temp.split("\\\\n");
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(maincmd);
        for (int i = 0; i < cmds.length; ++i) {
            cmdList.add(cmds[i].trim());
        }
        this.saveQaucliCmd(cmdList, echoMeta, endStrs);
    }

    private void saveQaucliCmd(List<String> cmdList, EchoMeta echoMeta, List<String> endStrs) {
        String[] datas = echoMeta.getData().split("\n");
        ArrayList<String> echos = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < datas.length; ++i) {
            boolean isEndLine = false;
            for (String endStr : endStrs) {
                if (!datas[i].contains(endStr)) continue;
                if (!datas[i].trim().endsWith(endStr)) {
                    int endIndex = datas[i].indexOf(endStr) + endStr.length();
                    sb.append(datas[i].substring(0, endIndex));
                    echos.add(sb.toString());
                    sb = new StringBuilder();
                    sb.append(datas[i].substring(endIndex + 1));
                    sb.append(System.lineSeparator());
                } else {
                    sb.append(datas[i]);
                    echos.add(sb.toString());
                    sb = new StringBuilder();
                }
                isEndLine = true;
                break;
            }
            if (isEndLine) continue;
            sb.append(datas[i]);
            sb.append(System.lineSeparator());
        }
        ArrayList<String> comboCmds = new ArrayList<String>();
        comboCmds.add("qaucli");
        comboCmds.add("2");
        comboCmds.add("3");
        boolean isFirstQaucli = this.commonEchoMap.containsKey("qaucli");
        for (int i = 0; i < cmdList.size(); ++i) {
            if (cmdList.get(0).equals("qaucli") && isFirstQaucli && comboCmds.contains(cmdList.get(i))) {
                comboCmds.remove(cmdList.get(i));
                continue;
            }
            EchoMeta tempMeta = new EchoMeta();
            tempMeta.setCmd(cmdList.get(i));
            if (i >= echos.size()) {
                tempMeta.setData("");
            } else {
                tempMeta.setData((String)echos.get(i));
            }
            this.saveCommonCmd(cmdList.get(i), tempMeta);
        }
    }

    private void saveInteractiveCmd(String cmd, EchoMeta echoMeta) {
        String[] datas = echoMeta.getData().split(System.lineSeparator());
        ArrayList<String> cmdList = new ArrayList<String>();
        ArrayList<String> echoList = new ArrayList<String>();
        boolean isCmdEnd = false;
        boolean enterSql = false;
        StringBuilder oneCmdEcho = new StringBuilder();
        for (String data : datas) {
            if (data.contains("####InteractiveEcho####")) {
                isCmdEnd = true;
                continue;
            }
            if (!isCmdEnd) {
                if ((data = data.trim()).startsWith("sqlplus") || data.startsWith("qaucli")) {
                    enterSql = true;
                }
                if (this.judgeContinueByEnterSql(enterSql, data) || this.specialCmdProcess(data)) continue;
                cmdList.add(data);
                continue;
            }
            if (cmdList.contains("qaucli")) {
                this.saveQaucliCmd(cmdList, echoMeta, qaucliEndStr);
                return;
            }
            if (!data.contains("SQL>")) {
                oneCmdEcho.append(data);
            } else {
                data = data.trim();
                String tail = "";
                if (!data.endsWith("SQL>")) {
                    int dataIdx = data.lastIndexOf("SQL>") + 4;
                    tail = data.substring(dataIdx + 1);
                    data = data.substring(0, dataIdx);
                }
                if ("SQL>".equals(data)) {
                    oneCmdEcho = this.getOneCmdEchoAndInitEchoList(echoList, oneCmdEcho);
                } else {
                    String[] sqlEchos;
                    if (data.indexOf("SQL>") != 0) {
                        data = data.substring(data.indexOf("SQL>"));
                        data = "SQL>" + data;
                    }
                    data = data.replaceAll("SQL>", "SQL> ");
                    for (String sqlEcho : sqlEchos = data.trim().split("SQL>")) {
                        oneCmdEcho.append(sqlEcho);
                        oneCmdEcho = this.getOneCmdEchoAndInitEchoList(echoList, oneCmdEcho);
                    }
                }
                if (!"".equals(tail.trim())) {
                    oneCmdEcho.append(tail);
                }
            }
            oneCmdEcho.append(System.lineSeparator());
        }
        this.saveCommonCmd(cmdList, echoList);
    }

    private StringBuilder getOneCmdEchoAndInitEchoList(List<String> echoList, StringBuilder oneCmdEcho) {
        oneCmdEcho.append("SQL>");
        echoList.add(oneCmdEcho.toString());
        oneCmdEcho = new StringBuilder();
        return oneCmdEcho;
    }

    private boolean judgeContinueByEnterSql(boolean enterSql, String data) {
        if (!enterSql) {
            EchoMeta tempEchoMeta = new EchoMeta();
            tempEchoMeta.setData("");
            this.saveCommonCmd(data, tempEchoMeta);
            return true;
        }
        return false;
    }

    private void saveCommonCmd(List<String> cmdList, List<String> echoList) {
        int size = Math.min(cmdList.size(), echoList.size());
        for (int i = 0; i < size; ++i) {
            EchoMeta tempMeta = new EchoMeta();
            tempMeta.setCmd(cmdList.get(i));
            tempMeta.setData(echoList.get(i));
            this.saveCommonCmd(cmdList.get(i), tempMeta);
        }
    }

    private boolean specialCmdProcess(String cmd) {
        String cmdKey = cmd.trim();
        if (cmd.contains(" ")) {
            cmdKey = cmd.split(" ")[0];
        }
        if (specialSqlCmds.contains(cmdKey)) {
            EchoMeta echoMeta = new EchoMeta();
            echoMeta.setData("");
            this.saveCommonCmd(cmd, echoMeta);
            return true;
        }
        return false;
    }

    private void saveCommonCmd(String cmd, EchoMeta echoMeta) {
        echoMeta.setNo(this.index);
        this.allEchos.add(echoMeta);
        if (!this.commonEchoMap.containsKey(cmd)) {
            this.commonEchoMap.put(cmd, this.index);
        } else if (!this.extraEchoMap.containsKey(cmd)) {
            ArrayList<Integer> echoMetas = new ArrayList<Integer>();
            echoMetas.add(this.commonEchoMap.get(cmd));
            echoMetas.add(this.index);
            this.extraEchoMap.put(cmd, echoMetas);
        } else {
            this.extraEchoMap.get(cmd).add(this.index);
        }
        ++this.index;
    }

    public EchoMeta get(String cmd) {
        EchoMeta echo = this.getInner(cmd);
        this.historyCmdQueue.offer(cmd);
        if (null != echo) {
            this.lastEcho = echo;
        }
        return echo;
    }

    private EchoMeta getInner(String cmd) {
        if (!this.extraEchoMap.containsKey(cmd)) {
            if (!this.commonEchoMap.containsKey(cmd)) {
                return null;
            }
            return this.allEchos.get(this.commonEchoMap.get(cmd));
        }
        List<Integer> echoMetas = this.extraEchoMap.get(cmd);
        List<Integer> matchedEchos = this.filterEchoByLastEcho(echoMetas);
        if (matchedEchos.size() == 1) {
            return this.allEchos.get(matchedEchos.get(0));
        }
        matchedEchos = this.filterEchoByHistoryCmd(echoMetas);
        if (matchedEchos.size() == 1) {
            return this.allEchos.get(matchedEchos.get(0));
        }
        Integer matchedEcho = this.smartFilterEchoByHistoryCmd(echoMetas);
        return this.allEchos.get(matchedEcho);
    }

    private List<Integer> filterEchoByHistoryCmd(List<Integer> echos) {
        List<Integer> ret = new ArrayList<Integer>();
        for (int level = this.historyCmdQueue.size() - 1; level >= 0; --level) {
            if (ret.size() == 1) {
                return ret;
            }
            ret = this.filterEchoByHistoryCmd(ret, level);
        }
        return ret;
    }

    private Integer smartFilterEchoByHistoryCmd(List<Integer> echos) {
        Integer maxEcho = -1;
        Integer maxHitCount = -1;
        for (Integer echo : echos) {
            int hitCount = 0;
            int cmdNum = 0;
            block1: for (int level = this.historyCmdQueue.size() - 1; level >= 0; --level) {
                String tempCmd = this.historyCmdQueue.get(level);
                while (cmdNum < 15) {
                    int historyIndex = echo - cmdNum;
                    if (historyIndex >= 0 && tempCmd.equals(this.allEchos.get(historyIndex).getCmd())) {
                        ++hitCount;
                        ++cmdNum;
                        continue block1;
                    }
                    ++cmdNum;
                }
            }
            if (hitCount <= maxHitCount) continue;
            maxHitCount = hitCount;
            maxEcho = echo;
        }
        return maxEcho;
    }

    private List<Integer> filterEchoByHistoryCmd(List<Integer> echos, int level) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Integer echo : echos) {
            String tempCmd = this.historyCmdQueue.get(level);
            int historyCmd = echo - level;
            if (historyCmd < 0 || !tempCmd.equals(this.allEchos.get(historyCmd).getCmd())) continue;
            ret.add(echo);
        }
        return ret;
    }

    private List<Integer> filterEchoByLastEcho(List<Integer> echos) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Integer echo : echos) {
            if (echo == 0) {
                ret.add(0);
                break;
            }
            int lastNo = echo - 1;
            EchoMeta lastcmd = this.allEchos.get(lastNo);
            if (!lastcmd.equals(this.lastEcho)) continue;
            ret.add(echo);
        }
        return ret;
    }

    static {
        qaucliEndStr.add("Please Enter Selection: ");
        qaucliEndStr.add("Press <Enter> to continue:");
        specialSqlCmds.add("exit");
        specialSqlCmds.add("export");
        specialSqlCmds.add("su");
        formatEndStr.add("Specify disk (enter its number):");
        formatEndStr.add("format>");
    }
}

