/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.simu;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.FileConnection;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.info.monitorenter.util.encoding.EncodingDetect;
import com.huawei.ism.tool.obase.simu.EchoCache;
import com.huawei.ism.tool.obase.simu.EchoMeta;
import com.huawei.ism.tool.obase.utils.CommonEncodeDetectUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.slf4j.Logger;

public class EchoMgr {
    private String filePath = "";
    private static final String END_CMD = "EndCmd:";
    private static final String START_CMD = "StartCmd:";
    public static final char ATTR_SEP = ':';
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FileConnection.class);
    private static final Integer ENCODE_DETECT_LENGTH = 2048;
    private EchoCache echoCache = new EchoCache();
    private RandomAccessFile raf = null;
    private String charSet = "";

    public EchoMgr(String filePath) throws ToolException {
        this.filePath = filePath;
        try {
            this.charSet = CommonEncodeDetectUtils.encodeDetectByBom(new File(filePath));
            this.raf = new RandomAccessFile(new File(filePath), "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.error("init randomfile failed.");
        }
        this.parseFile();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseFile() throws ToolException {
        MyRandomAccessFile rafile = null;
        try {
            rafile = new MyRandomAccessFile(new File(this.filePath), "r");
            String line = null;
            boolean isStartMatch = false;
            String key = "";
            StringBuilder data = new StringBuilder();
            int startPos = -1;
            int pos = 0;
            int lastPos = 0;
            while ((line = rafile.myRead()) != null) {
                pos += line.length() + 1;
                if (line.startsWith(START_CMD)) {
                    data = new StringBuilder();
                    key = line.substring(line.indexOf(58) + 1).trim();
                    isStartMatch = true;
                    startPos = pos;
                } else if (isStartMatch && line.trim().equals(END_CMD + key)) {
                    isStartMatch = false;
                    EchoMeta echoMeta = new EchoMeta();
                    echoMeta.setCmd(key);
                    echoMeta.setStartIndex(startPos);
                    echoMeta.setEndIndex(lastPos);
                    echoMeta.setData(data.toString());
                    this.echoCache.put(key, echoMeta);
                } else if (isStartMatch && !StringUtils.isNULLStr((String)line.trim())) {
                    data.append(line);
                    data.append(System.lineSeparator());
                }
                lastPos = pos;
            }
        }
        catch (FileNotFoundException e) {
            try {
                LOGGER.error("file not found:{}", (Object)new File(this.filePath).getName());
                throw new ToolException("parse file exception");
                catch (Exception e2) {
                    LOGGER.error("execute cmd error", e2);
                    throw new ToolException("parse file exception");
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, rafile);
                throw throwable;
            }
        }
        StreamUtils.closeResource(null, (Closeable)rafile);
    }

    public String getEcho(String cmd, List<String> endStrs) throws ToolException {
        EchoMeta echoMeta = this.echoCache.get(cmd);
        if (null == echoMeta) {
            throw new ToolException("no the cmd.");
        }
        String ret = "";
        ret = null != echoMeta.getData() ? echoMeta.getData() : this.getContent(echoMeta.getStartIndex(), echoMeta.getEndIndex());
        return ret;
    }

    private String getContent(int startPos, int endPos) {
        try {
            this.raf.seek(startPos);
            int len = endPos - startPos;
            if (len <= 0) {
                return "";
            }
            byte[] bys = new byte[len];
            int actualLen = this.raf.read(bys);
            if (actualLen != len) {
                LOGGER.error("the read actual length is not equal the length.");
            }
            if (!StringUtils.isNULLStr((String)this.charSet)) {
                return new String(bys, this.charSet);
            }
            String tmpCharSet = EncodingDetect.detect(bys, ENCODE_DETECT_LENGTH);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("tempCharset=" + tmpCharSet);
            }
            return new String(bys, tmpCharSet);
        }
        catch (IOException e) {
            LOGGER.error("getContent failed", e);
            return "";
        }
    }

    private class MyRandomAccessFile
    extends RandomAccessFile {
        public MyRandomAccessFile(File file, String mode) throws FileNotFoundException {
            super(file, mode);
        }

        public String myRead() throws IOException {
            StringBuffer input = new StringBuffer();
            int c = -1;
            boolean eol = false;
            if ((c = this.getC(input, c, eol)) == -1 && input.length() == 0) {
                return null;
            }
            return input.toString();
        }

        private int getC(StringBuffer input, int c, boolean eol) throws IOException {
            block3: while (!eol) {
                c = this.read();
                switch (c) {
                    case -1: 
                    case 10: {
                        eol = true;
                        continue block3;
                    }
                }
                input.append((char)c);
            }
            return c;
        }
    }
}

