/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.taskexecutor;

import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.taskexecutor.ThreadListener;
import com.huawei.ism.tool.obase.taskexecutor.UIListener;
import com.huawei.ism.tool.obase.ui.dialogs.ProgressNumDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskExecutor
implements ThreadListener {
    private static final int INTERVAL_TIME = 2;
    private static final int TIMEOUT = 52;
    private static UIListener listener = new UIListener();
    private JDialog progressDialog = null;
    private volatile TaskResult result = null;
    private volatile boolean needCloseProgressDialog = false;
    private volatile boolean needShowProgressDialog = true;
    private boolean isNeedWait = true;
    private final Object lock = new Object();
    private int waitTime = 300000;

    public ServiceTaskExecutor(ProgressDialog proDialog) {
        long currentTime = System.currentTimeMillis();
        long lastTime = listener.getUILastOpertionTime();
        if ((currentTime - lastTime) / 1000L < 2L) {
            this.progressDialog = proDialog;
        }
    }

    public ServiceTaskExecutor(ProgressDialog waitingDialog, boolean showWaitingDialog) {
        this(waitingDialog);
        if (showWaitingDialog) {
            this.progressDialog = waitingDialog;
        }
    }

    public ServiceTaskExecutor(ProgressNumDialog progressDialog) {
        long currTime = System.currentTimeMillis();
        long lastTime = listener.getUILastOpertionTime();
        if ((currTime - lastTime) / 1000L < 2L) {
            this.progressDialog = progressDialog;
        }
    }

    public TaskResult execute(ServiceTask sTask) {
        this.result = null;
        this.startTask(sTask);
        return this.result;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setNeedWait(boolean needwait) {
        this.isNeedWait = needwait;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void threadFinished(TaskResult executeTaskResult) {
        this.setResult(executeTaskResult);
        if (null != this.progressDialog) {
            Object object = this.lock;
            synchronized (object) {
                this.needShowProgressDialog = false;
                this.lock.notifyAll();
            }
            if (this.needCloseProgressDialog) {
                this.progressDialog.dispose();
            }
            listener.setTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask(ServiceTask sTask) {
        this.needShowProgressDialog = true;
        this.needCloseProgressDialog = false;
        sTask.addListener(this);
        sTask.start();
        boolean needWait = this.isNeedWait;
        if (null != this.progressDialog) {
            Object object = this.lock;
            synchronized (object) {
                this.waitForBusyDialog();
                this.needCloseProgressDialog = this.needShowProgressDialog;
            }
            if (this.needCloseProgressDialog) {
                SwingUtil.putScreenCenter((Window)this.progressDialog);
                this.progressDialog.setVisible(true);
                needWait = false;
            }
        }
        if (needWait) {
            try {
                sTask.join();
            }
            catch (InterruptedException e) {
                Logger logger = LoggerFactory.getLogger(this.getClass());
                logger.error(e.getMessage(), e);
                TaskResult ret = new TaskResult();
                ret.setResult(TaskResult.Result.FAILED);
                this.setResult(ret);
            }
        }
    }

    private void waitForBusyDialog() {
        try {
            for (int i = 0; i < 1; ++i) {
                this.lock.wait(52L);
            }
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(this.getClass()).error("Interrupted exception!");
        }
    }

    private synchronized void setResult(TaskResult taskResult) {
        if (null == taskResult) {
            return;
        }
        if (null == this.result) {
            this.result = taskResult;
        }
    }
}

