/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.threadpool;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.threadpool.ToolThreadFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.util.CommonUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import org.slf4j.Logger;

public final class ThreadPoolHelper {
    private static ExecutorService fixedNumThreadPool = null;
    private static int addDeviceThreadNum;
    private static final Logger LOGGER;

    private ThreadPoolHelper() {
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                    ToolLoggerFactory.getLogger(ThreadPoolHelper.class).error("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static ExecutorService getFixedThreadPool(int poolSize, String poolName) {
        ToolThreadFactory factory = new ToolThreadFactory(poolName);
        return new ThreadPoolExecutor(0, poolSize, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ExecutorService getFixedNumThreadPool(int poolSize, String poolName) {
        ToolThreadFactory factory = new ToolThreadFactory(poolName);
        return Executors.newFixedThreadPool(poolSize, factory);
    }

    public static ExecutorService getFixedNumThreadPool(int poolSize, String poolName, Thread.UncaughtExceptionHandler handler) {
        ToolThreadFactory factory = new ToolThreadFactory(poolName, handler);
        return new ThreadPoolExecutor(poolSize, poolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
    }

    public static ExecutorService getFixedNumThreadPool(int poolSize, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, poolSize, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ExecutorService getCachedThreadPool(String poolName) {
        ToolThreadFactory factory = new ToolThreadFactory(poolName);
        ExecutorService executorService = Executors.newCachedThreadPool(factory);
        return executorService;
    }

    public static ScheduledThreadPoolExecutor getScheduledExecutorServicePool(int poolSize, String poolName) {
        ToolThreadFactory factory = new ToolThreadFactory(poolName);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(poolSize, factory);
        return executor;
    }

    public static <T> List<T> concurrentExecute(Window parent, final List<Callable<T>> calls) {
        Callable call = new Callable<List<T>>(){

            @Override
            public List<T> call() {
                ArrayList futures = new ArrayList();
                ArrayList result = new ArrayList();
                for (Callable call : calls) {
                    Future f = fixedNumThreadPool.submit(call);
                    futures.add(f);
                }
                try {
                    this.waitResult(futures, result);
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("get result error.", e);
                }
                return result;
            }

            private void waitResult(List<Future<T>> futures, List<T> result) throws InterruptedException, ExecutionException {
                for (Future f : futures) {
                    result.add(f.get());
                }
            }
        };
        if (parent instanceof JFrame) {
            return (List)AsyncExcutor.execute((Window)((Window)CommonUtil.convertObject((Object)parent, JFrame.class)), (Callable[])new Callable[]{call}).get(0);
        }
        if (parent instanceof JDialog) {
            return (List)AsyncExcutor.execute((Window)((Window)CommonUtil.convertObject((Object)parent, JDialog.class)), (Callable[])new Callable[]{call}).get(0);
        }
        List list = AsyncExcutor.execute((boolean)false, (Callable[])new Callable[]{call});
        if (null == list || list.isEmpty()) {
            return null;
        }
        return (List)list.get(0);
    }

    public static <T> List<T> concurrentExecuteWithProcessBar(Window parent, JProgressBar progressBar, List<Callable<T>> calls) {
        ConcurrentCallable<T> call = new ConcurrentCallable<T>(calls, progressBar);
        if (parent instanceof JFrame || parent instanceof JDialog) {
            return (List)AsyncExcutor.execute((Window)parent, (JProgressBar)progressBar, (Callable[])new Callable[]{call}).get(0);
        }
        List list = AsyncExcutor.execute((boolean)false, (Callable[])new Callable[]{call});
        if (null == list || list.isEmpty()) {
            return null;
        }
        return (List)list.get(0);
    }

    public static <T> List<T> executeWithCustomBar(Window parent, JProgressBar progressBar, String custMizeMsg, List<Callable<T>> calls) {
        ConcurrentCallable<T> call = new ConcurrentCallable<T>(calls, progressBar);
        return (List)AsyncExcutor.execute((Window)parent, (JProgressBar)progressBar, (String)custMizeMsg, (Callable[])new Callable[]{call}).get(0);
    }

    static {
        LOGGER = ToolLoggerFactory.getLogger(ThreadPoolHelper.class);
        addDeviceThreadNum = ApplicationContext.getInstance().getMaxImportThreadSize();
        fixedNumThreadPool = ThreadPoolHelper.getFixedThreadPool(addDeviceThreadNum, "tool_fixed_num_pool");
    }

    static class ConcurrentCallable<T>
    implements Callable<List<T>> {
        private List<Callable<T>> calls;
        private int taskNumber;
        private int currentProcess = 0;
        private JProgressBar progressBar;
        private int allTaskStartProcess = 70;
        private int waitTaskEndProcess = 100 - this.allTaskStartProcess;

        public ConcurrentCallable(List<Callable<T>> calls, JProgressBar progressBar) {
            this.calls = calls;
            this.taskNumber = calls.size();
            this.progressBar = progressBar;
        }

        @Override
        public List<T> call() throws Exception {
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
            ArrayList result = new ArrayList();
            this.currentProcess = 1;
            this.progressBar.setValue(this.currentProcess);
            int hasStartTaskNum = 0;
            int calprocess = 0;
            for (Callable<T> call : this.calls) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("get result error.", e);
                }
                Future<T> f = fixedNumThreadPool.submit(call);
                calprocess = ++hasStartTaskNum * this.allTaskStartProcess / this.taskNumber;
                if (calprocess > this.currentProcess) {
                    this.currentProcess = calprocess;
                }
                this.progressBar.setValue(this.currentProcess);
                futures.add(f);
            }
            this.progressBar.setValue(this.allTaskStartProcess);
            try {
                this.waitResult(futures, result);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("get result error.", e);
            }
            return result;
        }

        private void waitResult(List<Future<T>> futures, List<T> result) throws InterruptedException, ExecutionException {
            int hasEndTaskNum = 0;
            int calprocess = 0;
            for (Future<T> f : futures) {
                try {
                    ++hasEndTaskNum;
                    result.add(f.get());
                }
                catch (Exception e) {
                    LOGGER.error("Future get error: " + e);
                }
                calprocess = hasEndTaskNum * this.waitTaskEndProcess / this.taskNumber + this.allTaskStartProcess;
                if (calprocess > this.currentProcess) {
                    this.currentProcess = calprocess;
                }
                this.progressBar.setValue(this.currentProcess);
            }
            this.progressBar.setValue(100);
            Thread.sleep(1000L);
        }
    }
}

