/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.base;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;

public class SingleProcessSupport {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SingleProcessSupport.class);
    private static final int SLEEP_TIME = 300000;
    private static final int TIMEOUT = 1;
    private List<FileLock> filLocks = new ArrayList<FileLock>();

    public TaskResult checkSingleProcess(String lockFileName) {
        if (!this.isNeedLock()) {
            return null;
        }
        List<String> lockFilesPath = this.getLockFilePath(lockFileName);
        for (String lockFilePath : lockFilesPath) {
            try {
                Future fu = AsyncExcutor.submit((Callable)new SleepForeverFreeLock(lockFilePath));
                Object taskResult = fu.get(1L, TimeUnit.SECONDS);
                if (null == taskResult) continue;
                return (TaskResult)taskResult;
            }
            catch (TimeoutException e) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("get lock success. The shared path is " + this.isSharePath(lockFilePath));
            }
            catch (Exception e) {
                LOGGER.error("get lock error!! The shared path is " + this.isSharePath(lockFilePath));
            }
        }
        return null;
    }

    private String isSharePath(String lockFilePath) {
        if (lockFilePath.contains(Normalizer.normalize(ApplicationContext.getInstance().getUserDataPath(), Normalizer.Form.NFKC))) {
            return "wrong";
        }
        return "right";
    }

    private void handleException(FileLock fileLock, FileOutputStream fos) {
        if (null != fileLock) {
            try {
                fileLock.release();
            }
            catch (IOException e) {
                LOGGER.error("lock file failed!!!!");
            }
        }
        if (null != fos) {
            try {
                fos.close();
            }
            catch (IOException e) {
                LOGGER.error("lock file failed!!!!");
            }
        }
    }

    private void sleepForever() {
        while (com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isBlockLcokRealese()) {
            try {
                TimeUnit.MILLISECONDS.sleep(300000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("lock file failed!!!!");
            }
        }
    }

    public void release() {
        for (FileLock fileLock : this.filLocks) {
            if (fileLock == null) continue;
            this.releaseFileLock(fileLock);
        }
    }

    private boolean isNeedLock() {
        return true;
    }

    private List<String> getLockFilePath(String lockFileName) {
        ArrayList<String> results = new ArrayList<String>();
        results.add(System.getProperty("java.io.tmpdir") + File.separator + lockFileName);
        results.add(ApplicationContext.getInstance().getUserDataPath() + lockFileName);
        return results;
    }

    private void releaseFileLock(FileLock lock) {
        if (null == lock) {
            return;
        }
        try {
            lock.release();
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(Thread.currentThread().getClass()).error("Release file lock failed.");
        }
    }

    public String getErrorLocaleDescription(TaskResult taskResult) {
        String errorLocaleDescription = "";
        String key = taskResult.getErrorMsgKey();
        String params = taskResult.getErrorMsgParams();
        errorLocaleDescription = params != null && !"".equals(params) ? ResourceUtil.getStringWithParams(key, params) : ResourceUtil.getString(key);
        taskResult.setErrorLocaleDescription(errorLocaleDescription);
        return errorLocaleDescription;
    }

    private class SleepForeverFreeLock
    implements Callable<TaskResult> {
        private String lockFilePath;

        public SleepForeverFreeLock(String lockFilePath) {
            this.lockFilePath = lockFilePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public TaskResult call() {
            TaskResult taskResult;
            FileOutputStream fos;
            FileLock fileLock;
            block8: {
                fileLock = null;
                fos = null;
                taskResult = null;
                fos = new FileOutputStream(FilePathUtils.checkFile((String)this.lockFilePath));
                fileLock = fos.getChannel().tryLock();
                if (null != fileLock) break block8;
                LOGGER.error("The file has locked.The shared path is " + SingleProcessSupport.this.isSharePath(this.lockFilePath));
                taskResult = new TaskResult();
                taskResult.setErrorLocaleDescription("toolbox.app.context.lock.fail;tool_name");
                TaskResult taskResult2 = taskResult;
                SingleProcessSupport.this.handleException(fileLock, fos);
                return taskResult2;
            }
            try {
                SingleProcessSupport.this.filLocks.add(fileLock);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("lock file success. The shared path is " + SingleProcessSupport.this.isSharePath(this.lockFilePath));
                }
                SingleProcessSupport.this.sleepForever();
            }
            catch (IOException e) {
                taskResult = new TaskResult();
                taskResult.setErrorLocaleDescription("toolbox.app.context.lock.notCreate.fail");
                LOGGER.error("lock file faild.The shared path is " + SingleProcessSupport.this.isSharePath(this.lockFilePath));
                TaskResult taskResult3 = taskResult;
                SingleProcessSupport.this.handleException(fileLock, fos);
                return taskResult3;
            }
            catch (Exception e2) {
                taskResult = new TaskResult();
                taskResult.setErrorLocaleDescription("toolbox.app.context.lock.notCreate.fail");
                LOGGER.error("lock file faild.The shared path is " + SingleProcessSupport.this.isSharePath(this.lockFilePath), e2);
                TaskResult taskResult4 = taskResult;
                {
                    catch (Throwable throwable) {
                        SingleProcessSupport.this.handleException(fileLock, fos);
                        throw throwable;
                    }
                }
                SingleProcessSupport.this.handleException(fileLock, fos);
                return taskResult4;
            }
            SingleProcessSupport.this.handleException(fileLock, fos);
            return taskResult;
        }
    }
}

