/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.chart.frame;

import com.huawei.ism.tool.obase.ui.chart.frame.ChassisInfo;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class PictureComponent
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon image;
    private ChassisInfo chassisInfo = null;
    private boolean highLight = false;

    public PictureComponent(ChassisInfo chassisInfo) {
        this.image = this.getImageIcon(chassisInfo);
        this.chassisInfo = chassisInfo;
        this.setFocusable(true);
        this.setOpaque(true);
    }

    public int getComponentHeight() {
        return this.chassisInfo.getHeight();
    }

    public int getStartU() {
        return this.chassisInfo.getStartU();
    }

    public ChassisInfo getChassisInfo() {
        return this.chassisInfo;
    }

    private ImageIcon getImageIcon(ChassisInfo chassis) {
        ChassisInfo.ChassisType tyle = chassis.getChassisType();
        if (ChassisInfo.ChassisType.CONTROLLER.equals((Object)tyle) || ChassisInfo.ChassisType.ENGINE.equals((Object)tyle)) {
            if (2 == chassis.getHeight()) {
                return ResourceUtil.getImage("diskchassis_2U.png");
            }
            return ResourceUtil.getImage("diskchassis_4U.png");
        }
        if (ChassisInfo.ChassisType.SUBRACK.equals((Object)tyle)) {
            if (2 == chassis.getHeight()) {
                return ResourceUtil.getImage("diskchassis_2U.png");
            }
            return ResourceUtil.getImage("diskchassis_4U.png");
        }
        if (ChassisInfo.ChassisType.SWITCH.equals((Object)tyle)) {
            return ResourceUtil.getImage("switch_1U.png");
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.image.getIconWidth(), this.image.getIconHeight());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isHighLight() {
        return this.highLight;
    }

    public void setHighLight(boolean isHighLight) {
        this.highLight = isHighLight;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics drawGraphics = graphics.create();
        drawGraphics.setColor(Color.white);
        if (this.image != null) {
            drawGraphics.fillRect(0, 0, this.image.getIconWidth(), this.image.getIconHeight());
            drawGraphics.drawImage(this.image.getImage(), 0, 0, this.image.getIconWidth(), this.image.getIconHeight(), this);
            if (this.isHighLight()) {
                drawGraphics.setColor(Color.GREEN);
            } else {
                drawGraphics.setColor(Color.black);
            }
            drawGraphics.drawRect(0, 0, this.image.getIconWidth() - 1, this.image.getIconHeight() - 1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.highLight = !this.highLight;
        this.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

