/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component;

import com.huawei.ism.tool.obase.ui.base.ToolAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPopupMenu;

public class PopupButton
extends JButton {
    private static final long serialVersionUID = -7408548226501043196L;
    private List<ToolAction> toolActions = new ArrayList<ToolAction>();

    public PopupButton(String text, List<ToolAction> actions) {
        this(text, false, actions.toArray(new ToolAction[actions.size()]));
        this.toolActions = actions;
    }

    public PopupButton(String text, final boolean autoSize, final ToolAction ... actions) {
        super(text);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JPopupMenu popmenu = new JPopupMenu();
                for (ToolAction action : actions) {
                    popmenu.add(action);
                    popmenu.setEnabled(action.isAvailable());
                }
                if (autoSize) {
                    popmenu.setPopupSize(PopupButton.this.getWidth(), PopupButton.this.getHeight() * actions.length);
                }
                popmenu.show(PopupButton.this, 0, PopupButton.this.getHeight() - 3);
            }
        });
    }

    public List<ToolAction> getActions() {
        return this.toolActions;
    }
}

