/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.treetable;

import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.treetable.MutliHyperLinkCellByTable;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTable;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MutliHyperLinkCell {
    private static MutliHyperlinkRenderer render = new MutliHyperlinkRenderer();
    private Map<String, ActionListener> hyperLinkMap = new HashMap<String, ActionListener>();
    private static final long serialVersionUID = 1808111220086856741L;

    public TableCellRenderer getRender() {
        return render;
    }

    public Map<String, ActionListener> getHyperActionMap() {
        return this.hyperLinkMap;
    }

    public void addHyperLinkCell(String text, ActionListener action) {
        this.hyperLinkMap.put(text, action);
    }

    static class MutliHyperlinkRenderer
    implements TableCellRenderer {
        private JPanel panel = new JPanel();
        private static final long serialVersionUID = 1L;

        public MutliHyperlinkRenderer() {
            this.panel.setOpaque(true);
            this.panel.setLayout(new BoxLayout(this.panel, 0));
        }

        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.panel.removeAll();
            if (!this.checkTable(table, value)) {
                return null;
            }
            MutliHyperLinkCell cell = this.getCell(value);
            if (cell != null) {
                Map<String, ActionListener> actionMap = cell.getHyperActionMap();
                for (Map.Entry<String, ActionListener> entry : actionMap.entrySet()) {
                    String text = entry.getKey();
                    this.panel.add(Box.createHorizontalStrut(12));
                    ToolHyperLinkLabel label = new ToolHyperLinkLabel(text);
                    this.panel.add(label);
                }
            }
            TreeTableUtils.setCompColor(this.panel, isSelected, (IsmTable)table, row);
            return this.panel;
        }

        protected boolean checkTable(JTable table, Object value) {
            return table instanceof TreeTable || table instanceof IsmTable && value instanceof MutliHyperLinkCellByTable;
        }

        protected MutliHyperLinkCell getCell(Object value) {
            if (value instanceof MutliHyperLinkCell) {
                return (MutliHyperLinkCell)value;
            }
            if (value instanceof MutliHyperLinkCellByTable) {
                return ((MutliHyperLinkCellByTable)((Object)value)).getMutliHyperLinkCell();
            }
            return null;
        }
    }
}

