/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.wizard;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.IWizardClosingObserver;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardConstants;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardStepGroup;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardStepItem;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ToolWizardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static int wizardDialogWidth = 785;
    private static int wizardDialogHeight = 500;
    private transient WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private WizardStepGroup stepsGroup = new WizardStepGroup();
    private Card currentCard;
    private Box navigationBar;
    private JPanel contentPane;
    private IWizardClosingObserver closeObserver;
    private String wizardName = "";
    private boolean hasHelpIcon = true;
    private boolean isShowMinimize;
    private boolean isShowMaxsize;

    public ToolWizardDialog(JFrame jFrame, List<String[]> stepName, boolean hasHelpIcon) {
        super((Frame)jFrame, true);
        this.hasHelpIcon = hasHelpIcon;
        this.init(stepName);
        this.initListener();
    }

    public ToolWizardDialog(Dialog dialog, List<String[]> stepName, boolean hasHelpIcon) {
        super(dialog, true);
        this.hasHelpIcon = hasHelpIcon;
        this.init(stepName);
        this.initListener();
    }

    public ToolWizardDialog(Window parent, List<String[]> stepNames, Image image) {
        super(parent);
        this.hasHelpIcon = true;
        this.setIconImage(image);
        this.init(stepNames);
        this.initListener();
    }

    public ToolWizardDialog(Window parent, List<String[]> stepNames, Image image, boolean hasHelpIcon) {
        super(parent);
        this.hasHelpIcon = hasHelpIcon;
        this.setIconImage(image);
        this.init(stepNames);
        this.initListener();
    }

    public ToolWizardDialog(Window parent, List<String[]> stepNames, Image image, boolean isShowMaxsize, boolean isShowMinimize) {
        super(parent);
        this.hasHelpIcon = true;
        if (parent instanceof Frame) {
            this.isShowMaxsize = isShowMaxsize;
            this.isShowMinimize = isShowMinimize;
            parent.setIconImage(image);
            parent.setVisible(true);
        } else {
            this.setIconImage(image);
        }
        this.init(stepNames);
        this.initListener();
    }

    public ToolWizardDialog(Window parent, List<String[]> stepNames, Image image, boolean hasHelpIcon, int width, int height) {
        super(parent);
        this.hasHelpIcon = hasHelpIcon;
        this.setIconImage(image);
        wizardDialogWidth = width;
        wizardDialogHeight = height;
        this.init(stepNames);
        this.initListener();
    }

    public ToolWizardDialog(JFrame frame, List<String[]> stepNames) {
        this(frame, stepNames, true);
    }

    public ToolWizardDialog(List<String[]> stepNames) {
        this((JFrame)null, stepNames, true);
    }

    public ToolWizardDialog(Dialog dialog, List<String[]> stepNames) {
        this(dialog, stepNames, true);
    }

    public void setObserver(IWizardClosingObserver observer) {
        this.closeObserver = observer;
    }

    public void setHelpActionCallBack(IHelpActionCallBack helpActionCallBack) {
        this.rootPaneUI.setHelpActionCallBack(helpActionCallBack);
    }

    public void setWizardName(String name) {
        this.wizardName = name;
    }

    public boolean isHasHelpIcon() {
        return this.hasHelpIcon;
    }

    public JPanel getUserContentPane() {
        return this.contentPane;
    }

    private void initListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ToolWizardDialog.this.confirmExit();
            }
        });
    }

    private void confirmExit() {
        if (null != this.closeObserver) {
            this.closeObserver.onClose();
        }
    }

    public void setFirstCard(Card firstCard) {
        this.setCurrentCard(firstCard);
    }

    public void chg2NextCard() {
        if (null != this.getCurrentCard().getNextCard()) {
            this.setCurrentCard(this.getCurrentCard().getNextCard());
        }
    }

    public void updateStepsGroup(List<String[]> stepNames, String title) {
        if (null == stepNames) {
            return;
        }
        ArrayList<WizardStepItem> stepList = new ArrayList<WizardStepItem>();
        int i = 1;
        for (String[] stepNameArray : stepNames) {
            WizardStepItem stepItem = new WizardStepItem(stepNameArray[0], stepNameArray[1], i);
            if (1 == i) {
                stepItem.setSelected(true);
            }
            ++i;
            stepList.add(stepItem);
        }
        this.setWizardName(title);
        this.setCurrentCard(this.getCurrentCard());
        this.stepsGroup.cleanSteps();
        this.stepsGroup.setSetps(stepList.toArray(new WizardStepItem[stepList.size()]));
        this.updateStepPane();
        this.stepsGroup.validate();
        this.stepsGroup.repaint();
    }

    public void init(List<String[]> stepNames) {
        this.rootPaneUI.setShowMaxsize(this.isShowMaxsize);
        this.rootPaneUI.setShowMinimize(this.isShowMinimize);
        this.getRootPane().setUI(this.rootPaneUI);
        if (null == stepNames) {
            return;
        }
        ArrayList<WizardStepItem> stepList = new ArrayList<WizardStepItem>();
        int i = 1;
        for (String[] stepNameArray : stepNames) {
            WizardStepItem stepItem = new WizardStepItem(stepNameArray[0], stepNameArray[1], i);
            if (1 == i) {
                stepItem.setSelected(true);
            }
            ++i;
            stepList.add(stepItem);
        }
        this.stepsGroup.setSetps(stepList.toArray(new WizardStepItem[stepList.size()]));
        this.contentPane = new JPanel(new BorderLayout());
        this.navigationBar = Box.createHorizontalBox();
        Box southBox = Box.createVerticalBox();
        southBox.add(Box.createVerticalStrut(12));
        southBox.add(this.navigationBar);
        JPanel stepPanel = new JPanel(new BorderLayout());
        stepPanel.add((Component)this.stepsGroup, "West");
        stepPanel.add((Component)this.contentPane, "Center");
        stepPanel.add((Component)southBox, "South");
        southBox.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 39));
        stepPanel.setBackground(WizardConstants.WIZARD_BACKGROUND);
        stepPanel.setPreferredSize(new Dimension(wizardDialogWidth, wizardDialogHeight));
        JPanel btnPanel = new JPanel();
        btnPanel.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 6));
        btnPanel.setBackground(WizardConstants.WIZARD_BUTTOM_LINE_COLOR);
        Container container = this.getContentPane();
        this.setLayout(new BorderLayout());
        container.add((Component)stepPanel, "Center");
        container.add((Component)btnPanel, "South");
        int height = this.getStepsGroupHeight();
        this.setSize(height / 3 * 4, height);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public void setCurrentCard(Card card) {
        if (null != card) {
            this.currentCard = card;
            this.contentPane.removeAll();
            this.contentPane.add(UiMethod.buildFrameSpace(card, 20));
            this.initNavigationHandle();
            this.updateNavigationBar();
            this.updateStepPane();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.wizardName).append(this.getCurStep(card) + 1).append(ResourceUtil.getString("toolbase.common.txt.commer"));
            String title = card.getTitle();
            stringBuffer.append(StringUtils.isNULLStr(title) ? "" : title);
            this.setTitle(stringBuffer.toString());
            this.contentPane.revalidate();
            this.contentPane.repaint();
            this.repaint();
        }
    }

    private int getCurStep(Card card) {
        int curStep = card.getStep();
        if (curStep < 100) {
            return curStep;
        }
        return curStep / 100;
    }

    public Card getCurrentCard() {
        return this.currentCard;
    }

    private void updateStepPane() {
        int curStep = this.currentCard.getStep();
        if (curStep >= 100) {
            curStep /= 100;
        }
        if (0 <= curStep && curStep < this.stepsGroup.getStepSize()) {
            this.stepsGroup.setSelect(curStep);
        }
    }

    private void initNavigationHandle() {
        if (!this.currentCard.actionInjected) {
            JButton cancelButton;
            Map naviBtns = this.currentCard.navigationButtons;
            if (naviBtns.containsKey((Object)Navigation.Previous)) {
                JButton previousButton = (JButton)naviBtns.get((Object)Navigation.Previous);
                previousButton.addActionListener(new PreviousBtnAction());
            }
            if (naviBtns.containsKey((Object)Navigation.Next)) {
                JButton nextButton = (JButton)naviBtns.get((Object)Navigation.Next);
                nextButton.addActionListener(new NexBtnAction());
            }
            if (naviBtns.containsKey((Object)Navigation.Complete)) {
                JButton completeButton = (JButton)naviBtns.get((Object)Navigation.Complete);
                completeButton.addActionListener(new CompleteBtnAction());
            }
            if (naviBtns.containsKey((Object)Navigation.Cancel)) {
                cancelButton = (JButton)naviBtns.get((Object)Navigation.Cancel);
                cancelButton.addActionListener(new CancelBtnAction());
            }
            if (naviBtns.containsKey((Object)Navigation.Skip)) {
                cancelButton = (JButton)naviBtns.get((Object)Navigation.Skip);
                cancelButton.addActionListener(new SkipBtnAction());
            }
            this.getRootPane().getActionMap().remove("ESCAPE");
            this.getRootPane().getActionMap().put("ESCAPE", new EscBtnAction());
            this.currentCard.actionInjected = true;
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && !this.currentCard.isValid(Navigation.Cancel)) {
            return;
        }
        super.processWindowEvent(e);
    }

    @Override
    public void dispose() {
        try {
            if (null != this.currentCard) {
                this.currentCard.doCancelTask();
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", e);
        }
        super.dispose();
    }

    private void updateNavigationBar() {
        Map naviBtns = this.currentCard.navigationButtons;
        this.navigationBar.removeAll();
        this.navigationBar.add(Box.createHorizontalGlue());
        if (naviBtns.containsKey((Object)Navigation.Previous)) {
            this.navigationBar.add((Component)naviBtns.get((Object)Navigation.Previous));
        }
        if (naviBtns.containsKey((Object)Navigation.Next)) {
            this.navigationBar.add(Box.createHorizontalStrut(10));
            this.navigationBar.add((Component)naviBtns.get((Object)Navigation.Next));
        }
        if (naviBtns.containsKey((Object)Navigation.Skip)) {
            this.navigationBar.add(Box.createHorizontalStrut(10));
            this.navigationBar.add((Component)naviBtns.get((Object)Navigation.Skip));
        }
        if (naviBtns.containsKey((Object)Navigation.Complete)) {
            this.navigationBar.add(Box.createHorizontalStrut(10));
            this.navigationBar.add((Component)naviBtns.get((Object)Navigation.Complete));
        }
        if (naviBtns.containsKey((Object)Navigation.Cancel)) {
            this.navigationBar.add(Box.createHorizontalStrut(15));
            this.navigationBar.add((Component)naviBtns.get((Object)Navigation.Cancel));
        }
        this.navigationBar.add(Box.createHorizontalStrut(20));
        if (naviBtns.containsKey((Object)Navigation.Next)) {
            JButton button = (JButton)naviBtns.get((Object)Navigation.Next);
            this.getRootPane().setDefaultButton(button);
            button.requestFocus();
        }
        if (naviBtns.containsKey((Object)Navigation.Complete)) {
            JButton btn = (JButton)naviBtns.get((Object)Navigation.Complete);
            this.getRootPane().setDefaultButton(btn);
            btn.requestFocus();
        }
    }

    public int getStepsGroupHeight() {
        return (int)this.stepsGroup.getPreferredSize().getHeight() + 6 + 39;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    public void updateStep(int stepIdx, String stepName, String stepDesc) {
        List<WizardStepItem> steps = this.stepsGroup.getStepList();
        if (steps.size() <= stepIdx || stepIdx <= -1) {
            return;
        }
        WizardStepItem item = steps.get(stepIdx);
        item.getStepLabel().setText(stepName);
        item.getDescriptionTextArea().setText(stepDesc);
    }

    public void setShowMinimize(boolean isShowMinimize) {
        this.isShowMinimize = isShowMinimize;
    }

    public boolean isShowMinimize() {
        return this.isShowMinimize;
    }

    public void setShowMaxsize(boolean isShowMaxsize) {
        this.isShowMaxsize = isShowMaxsize;
    }

    public boolean isShowMaxsize() {
        return this.isShowMaxsize;
    }

    public static abstract class Card
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Card previousCard;
        private boolean actionInjected;
        private Map<Navigation, JButton> navigationButtons = new HashMap<Navigation, JButton>();

        public Card() {
        }

        public Card getPreviousOriginCard() {
            return this.previousCard;
        }

        public void setPreviousCard(Card previousCard) {
            this.previousCard = previousCard;
        }

        public Card(Card previousCard, Navigation ... supportedNavigation) {
            this.initCard(previousCard, supportedNavigation);
        }

        public void initCard(Card prevCard, Navigation ... supportedNavigation) {
            this.setLayout(new BorderLayout());
            this.previousCard = prevCard;
            HashSet<Navigation> navigationList = new HashSet<Navigation>();
            if (null == supportedNavigation || 0 == supportedNavigation.length) {
                navigationList.add(Navigation.Previous);
                navigationList.add(Navigation.Next);
            } else {
                navigationList.addAll(Arrays.asList(supportedNavigation));
            }
            navigationList.add(Navigation.Cancel);
            Navigation tempNav = (Navigation)((Object)navigationList.toArray()[0]);
            for (Navigation navigation : navigationList) {
                if (navigation.toString().length() <= tempNav.toString().length()) continue;
                tempNav = navigation;
            }
            JButton tplBtn = UiMethod.createButton(tempNav.toString());
            this.navigationButtons.put(tempNav, tplBtn);
            for (Navigation navigation : navigationList) {
                if (navigation.equals((Object)tempNav)) continue;
                String name = navigation.toString();
                JButton button = UiMethod.createButton(name);
                this.navigationButtons.put(navigation, button);
            }
            this.updateNavigationBar();
        }

        public final void updateNavigationBar() {
            for (Navigation navi : this.navigationButtons.keySet()) {
                JButton button = this.navigationButtons.get((Object)navi);
                button.setEnabled(this.isValid(navi));
            }
        }

        public final Card getPreviousCard() {
            return this.previousCard;
        }

        public abstract String getTitle();

        public abstract int getStep();

        protected abstract Card getNextCard();

        protected abstract boolean isValid(Navigation var1);

        protected abstract boolean process(Navigation var1);

        public Map<Navigation, JButton> getNavigationButtons() {
            return this.navigationButtons;
        }

        protected void doCancelTask() {
        }
    }

    public static enum Navigation {
        Previous,
        Next,
        Complete,
        Cancel,
        Skip;

        String name;

        public String toString() {
            if (null != this.name) {
                return this.name;
            }
            String prefix = "toolbase.common.txt.";
            return ResourceUtil.getString(prefix + this.name().toLowerCase(Locale.getDefault()));
        }

        public Navigation setName(String namez) {
            this.name = namez;
            return this;
        }
    }

    private final class SkipBtnAction
    implements ActionListener {
        private SkipBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Card nextCard;
            boolean canSkip = ToolWizardDialog.this.currentCard.process(Navigation.Skip);
            if (canSkip && null != (nextCard = ToolWizardDialog.this.currentCard.getNextCard())) {
                ToolWizardDialog.this.setCurrentCard(nextCard);
            }
        }
    }

    private final class EscBtnAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private EscBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ToolWizardDialog.this.currentCard.isValid(Navigation.Cancel)) {
                return;
            }
            ToolWizardDialog.this.dispose();
        }
    }

    private final class NexBtnAction
    implements ActionListener {
        private NexBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Card nextCard;
            boolean succ = ToolWizardDialog.this.currentCard.process(Navigation.Next);
            if (succ && null != (nextCard = ToolWizardDialog.this.currentCard.getNextCard())) {
                ToolWizardDialog.this.setCurrentCard(nextCard);
            }
        }
    }

    private final class CompleteBtnAction
    implements ActionListener {
        private CompleteBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean succ = ToolWizardDialog.this.currentCard.process(Navigation.Complete);
            if (succ) {
                if (null != ToolWizardDialog.this.closeObserver) {
                    ToolWizardDialog.this.closeObserver.onComplete();
                }
                ToolWizardDialog.this.dispose();
            }
        }
    }

    private final class CancelBtnAction
    implements ActionListener {
        private CancelBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ToolWizardDialog.this.currentCard.process(Navigation.Cancel)) {
                ToolWizardDialog.this.confirmExit();
            }
        }
    }

    private final class PreviousBtnAction
    implements ActionListener {
        private PreviousBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Card previousCard;
            boolean succ = ToolWizardDialog.this.currentCard.process(Navigation.Previous);
            if (succ && null != (previousCard = ToolWizardDialog.this.currentCard.getPreviousCard())) {
                ToolWizardDialog.this.setCurrentCard(previousCard);
            }
        }
    }
}

