/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.entity.SecurityConfigEntity;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.XmlWriter;
import com.huawei.ism.util.SecurityConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SecurityConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfigUtil.class);
    private static final String XML_ROOT = "SecurityConfigEntity";
    private static final String NET_CARE_SWITCH_NODE = "netCareSwitch";

    public static SecurityConfigEntity getSecurityConfig() {
        return SecurityConfigUtil.parseXml2SecurityConfig(new File(SecurityConfig.getFilePath()));
    }

    private static SecurityConfigEntity parseXml2SecurityConfig(File file) {
        SecurityConfigEntity securityConfigEntity = new SecurityConfigEntity();
        try (FileInputStream inputStream = new FileInputStream(file);){
            Document doc = XmlUtils.parseDocument((InputStream)inputStream, (String)"utf-8");
            securityConfigEntity.setNetCareSwitch(Boolean.parseBoolean(XmlUtils.getChild((Element)doc.getDocumentElement(), (String)NET_CARE_SWITCH_NODE).getTextContent()));
            securityConfigEntity.setCompatibilityAlgorithmEnabled(Boolean.parseBoolean(XmlUtils.getChild((Element)doc.getDocumentElement(), (String)"compatibilityAlgorithmEnabled").getTextContent()));
            String privacyStatementAgreeValue = XmlUtils.getChild((Element)doc.getDocumentElement(), (String)"privacyStatementAgreeFlag").getTextContent();
            JSONObject agreeObject = JSONObject.parseObject((String)privacyStatementAgreeValue);
            for (Map.Entry entry : agreeObject.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof Boolean)) continue;
                securityConfigEntity.getPrivacyStatementAgreeJsonObj().addProperty((String)entry.getKey(), (Boolean)value);
            }
            String curUserAgreeValue = agreeObject.getString(ApplicationContext.getInstance().getCurToolkitUser());
            securityConfigEntity.setPrivacyStatementAgreeFlag(Boolean.parseBoolean(curUserAgreeValue));
        }
        catch (FileNotFoundException e) {
            log.error("file {} not found.", (Object)file.getName());
        }
        catch (Exception e) {
            log.error("parse security config xml error.", e);
        }
        return securityConfigEntity;
    }

    public static boolean writeConfigFile(SecurityConfigEntity securityConfigEntity) {
        try {
            File file = new File(SecurityConfig.getFilePath());
            XmlWriter.writeDomToXmlFile(SecurityConfigUtil.createConfigXml(securityConfigEntity), FilePathUtils.getCanonicalPath((File)file), true);
        }
        catch (ToolException e) {
            log.error("write security config fail.", e);
            return false;
        }
        return true;
    }

    private static Document createConfigXml(SecurityConfigEntity securityConfigEntity) throws ToolException {
        Document document = XmlWriter.createNewDocument();
        Element root = XmlWriter.createTagElement(document, XML_ROOT);
        Element netCareConfigNode = XmlWriter.createTagElement(document, NET_CARE_SWITCH_NODE);
        netCareConfigNode.setTextContent(String.valueOf(securityConfigEntity.isNetCareSwitch()));
        Element securityConfigNode = XmlWriter.createTagElement(document, "compatibilityAlgorithmEnabled");
        securityConfigNode.setTextContent(String.valueOf(securityConfigEntity.isCompatibilityAlgorithmEnabled()));
        Element privacyStatementNode = XmlWriter.createTagElement(document, "privacyStatementAgreeFlag");
        privacyStatementNode.setTextContent(String.valueOf(securityConfigEntity.isPrivacyStatementAgreeValue()));
        root.appendChild(netCareConfigNode);
        root.appendChild(securityConfigNode);
        root.appendChild(privacyStatementNode);
        document.appendChild(root);
        return document;
    }

    public static boolean isOnlySecurityAlgorithm() {
        return SecurityConfig.isOnlySecurityAlgorithm();
    }

    public static boolean modifySecurityAlgorithmConfig(boolean isSelected) {
        SecurityConfigEntity securityConfigEntity = SecurityConfigUtil.getSecurityConfig();
        securityConfigEntity.setCompatibilityAlgorithmEnabled(isSelected);
        return SecurityConfigUtil.writeConfigFile(securityConfigEntity);
    }
}

