/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.xml.cli;

import com.huawei.ism.tool.obase.constant.CliCmdModel;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.obase.xml.XmlNode;
import com.huawei.ism.tool.obase.xml.cli.CheckNode;
import com.huawei.ism.tool.obase.xml.cli.QueryNode;
import com.huawei.ism.tool.obase.xml.cli.ResultNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.w3c.dom.Element;

public class CliCmdNode
extends XmlNode {
    private CliCmdModel model = this.parseModel();
    private List<ResultNode> checkNodes = this.parseCheckNodes();

    public CliCmdNode(Element node) {
        super(node);
    }

    public List<ResultNode> getResultNodes() {
        return this.checkNodes;
    }

    public String getPocessor() {
        return this.getAttribute("processor");
    }

    public String getCommand() {
        return this.getAttribute("cmd");
    }

    private List<ResultNode> parseCheckNodes() {
        ArrayList<ResultNode> resultNodes = new ArrayList<ResultNode>();
        Collection<Element> subElement = XmlUtils.getChildren(this.getElement());
        for (Element element : subElement) {
            String tagName = element.getTagName();
            if ("check".equals(tagName)) {
                resultNodes.add(new CheckNode(element));
                continue;
            }
            if ("query".equals(tagName)) {
                resultNodes.add(new QueryNode(element));
                continue;
            }
            throw new IllegalArgumentException("The node \"" + element.toString() + "\" is unknown");
        }
        return resultNodes;
    }

    public CliCmdModel getModel() {
        return this.model;
    }

    private CliCmdModel parseModel() {
        String mode = this.getElement().getAttribute("mode");
        if (StringUtils.isNULLStr(mode)) {
            return CliCmdModel.CLI;
        }
        if ("debug".equals(mode)) {
            return CliCmdModel.LINUX;
        }
        if ("mml".equals(mode)) {
            return CliCmdModel.ARRAYMML;
        }
        throw new IllegalArgumentException("The cli model \"" + mode + "\" is unknown");
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append((Object)("CLICmdModel:" + this.getModel())).append((Object)("Pocessor:" + this.getPocessor())).append((Object)("Command:" + this.getCommand())).append((Object)("CheckNode:" + this.getResultNodes())).toString();
    }
}

