/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.client.DeployCampusCoreClient;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreParam;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BaseException;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.CampusCoreConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreParamVo;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Optional;
import java.util.function.Consumer;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class CampusCoreDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(CampusCoreDeployExternalTask.class);
    private static final String CAMPUS_CORE_VM = "eCampusCoreVm:";
    private static final String CAMPUS_CORE_SERVICE = "eCampusCoreService:";
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final CampusCoreConverter converter;
    private final DeployCampusCoreClient client;

    @Bean
    @ExternalTaskSubscription(value="startCampusCoreVmDeploy")
    public ExternalTaskHandler startCampusCoreVmDeploy() {
        return this.externalTaskDecorator.process(this.startHandler(arg_0 -> ((DeployCampusCoreClient)this.client).startDeployVmsTask(arg_0), CAMPUS_CORE_VM), this.retryVmTaskHandler(arg_0 -> ((DeployCampusCoreClient)this.client).retryDeployVmTask(arg_0), true, CAMPUS_CORE_VM));
    }

    @Bean
    @ExternalTaskSubscription(value="queryCampusCoreVmProgress")
    public ExternalTaskHandler queryCampusCoreVmProgress() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(CAMPUS_CORE_VM), this.retryVmTaskHandler(arg_0 -> ((DeployCampusCoreClient)this.client).retryDeployVmTask(arg_0), false, CAMPUS_CORE_VM));
    }

    @Bean
    @ExternalTaskSubscription(value="startCampusCoreDeploy")
    public ExternalTaskHandler startCampusCoreDeploy() {
        return this.externalTaskDecorator.process(this.startHandler(arg_0 -> ((DeployCampusCoreClient)this.client).startDeployCampusCoreService(arg_0), CAMPUS_CORE_SERVICE), this.retryVmTaskHandler(arg_0 -> ((DeployCampusCoreClient)this.client).retryDeployCampusCoreService(arg_0), true, CAMPUS_CORE_SERVICE));
    }

    @Bean
    @ExternalTaskSubscription(value="queryCampusCoreProgress")
    public ExternalTaskHandler queryCampusCoreProgress() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(CAMPUS_CORE_SERVICE), this.retryVmTaskHandler(arg_0 -> ((DeployCampusCoreClient)this.client).retryDeployCampusCoreService(arg_0), false, CAMPUS_CORE_SERVICE));
    }

    private ExternalTaskHandler queryDetailHandler(String type) {
        return (externalTask, externalTaskService) -> {
            Response response = this.client.queryCampusCoreTaskDetail(type.concat(externalTask.getProcessInstanceId()));
            if (!ResponseUtil.isSuccess((Response)response) || response.getData() == null) {
                log.error("query eCampusCore deploy details failed, response error.");
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.getData());
        };
    }

    private ExternalTaskHandler startHandler(Consumer<CampusCoreParam> action, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, true, type);
    }

    private ExternalTaskHandler retryVmTaskHandler(Consumer<CampusCoreParam> action, boolean isNotifyFinish, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, isNotifyFinish, type);
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, Consumer<CampusCoreParam> action, boolean isNotifyFinish, String type) {
        Optional<CampusCoreParamVo> campusCoreParamVo = Optional.ofNullable(this.bpmContextService.getContext(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class)).map(VirtualizationDeployProcessConfig::getCampusCoreParamVo);
        if (!campusCoreParamVo.isPresent()) {
            log.error("eCampusCore deploy failed, params not find.");
            return;
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        try {
            CampusCoreParamVo paramVo = campusCoreParamVo.get();
            action.accept(this.converter.toCampusCoreParam(paramVo, type.concat(externalTask.getProcessInstanceId())));
            startInstallResult.setSuccess(true);
        }
        catch (BaseException e) {
            log.error("eCampusCore deploy failed");
            startInstallResult.setSuccess(false);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    public CampusCoreDeployExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, CampusCoreConverter converter, DeployCampusCoreClient client) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.converter = converter;
        this.client = client;
    }
}

