/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.client.DayuDeployClient;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.context.DeployDayuContext;
import com.huawei.yinglong.river.sitedeployment.dcs.dayu.entity.DayuVmsParams;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.DeployDcsQueryActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.TaskStateEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.vo.DayuDeployParamsConvert;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class DayuDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(DayuDeployExternalTask.class);
    private static final String DEPLOY_VMS = "start_vms";
    private static final String DEPLOY_SERVICE = "start_service";
    private static final String RETRY_VMS = "retry_vms";
    private static final String RETRY_SERVICE = "retry_service";
    private static final List<TaskStateEnum> TASK_STATE_UPDATE_LIST = Arrays.asList(TaskStateEnum.END, TaskStateEnum.ERROR, TaskStateEnum.RUNNING, TaskStateEnum.PAUSE);
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final DayuDeployClient dayuDeployClient;
    private final DayuDeployParamsConvert convert;

    @Bean
    @ExternalTaskSubscription(value="startDayuVmDeploy")
    public ExternalTaskHandler startDayuVmDeploy() {
        return this.externalTaskDecorator.process(this.startDayuVmTaskHandler());
    }

    @Bean
    @ExternalTaskSubscription(value="startDayuDeploy")
    public ExternalTaskHandler startDayuDeploy() {
        return this.externalTaskDecorator.process(this.startServiceTaskHandler());
    }

    @Bean
    @ExternalTaskSubscription(value="queryDayuVmProgress")
    public ExternalTaskHandler queryDayuVmProgress() {
        return this.externalTaskDecorator.process(this.createTaskResultHandler(this.bpmContextService, "DAYU_VMS", () -> this.dayuDeployClient.queryDeployDayuTaskDetail(DeployDayuContext.getInstance().getDeployDayuVmsTaskId())), this.retryVmsTaskHandler());
    }

    @Bean
    @ExternalTaskSubscription(value="queryDayuProgress")
    public ExternalTaskHandler queryDayuProgress() {
        return this.externalTaskDecorator.process(this.createTaskResultHandler(this.bpmContextService, "DAYU_SERVICE", () -> this.dayuDeployClient.queryDeployDayuTaskDetail(DeployDayuContext.getInstance().getDeployDayuServiceTaskId())), this.retryServiceTaskHandler());
    }

    private ExternalTaskHandler startDayuVmTaskHandler() {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, DEPLOY_VMS, true);
    }

    private ExternalTaskHandler startServiceTaskHandler() {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, DEPLOY_SERVICE, true);
    }

    private ExternalTaskHandler retryVmsTaskHandler() {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, RETRY_VMS, false);
    }

    private ExternalTaskHandler retryServiceTaskHandler() {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, RETRY_SERVICE, false);
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, String action, boolean isNotifyFinish) {
        VirtualizationDeployProcessConfig processConfig = (VirtualizationDeployProcessConfig)this.bpmContextService.getContextWithoutDecrypt(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class);
        DayuVmsParams dayuVmsParams = this.convert.toDayuParams(processConfig.getDayuParamsVo());
        this.dayuDeployClient.updateEDataInsightParams(dayuVmsParams);
        boolean isExecuteSuccess = false;
        switch (action) {
            case "start_vms": {
                isExecuteSuccess = this.dayuDeployClient.startDeployDayuVms();
                break;
            }
            case "start_service": {
                isExecuteSuccess = this.dayuDeployClient.startDeployDayuService();
                break;
            }
            case "retry_vms": {
                isExecuteSuccess = this.dayuDeployClient.retryDeployVmTask();
                break;
            }
            case "retry_service": {
                isExecuteSuccess = this.dayuDeployClient.retryDayuServiceTask();
                break;
            }
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        startInstallResult.setSuccess(isExecuteSuccess);
        if (!startInstallResult.isSuccess()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    private ExternalTaskHandler createTaskResultHandler(BpmContextService bpmContextService, String module, Supplier<DeployTaskInfoVo> supplier) {
        return (externalTask, externalTaskService) -> {
            DeployTaskInfoVo taskInfoVo = (DeployTaskInfoVo)supplier.get();
            if (TASK_STATE_UPDATE_LIST.stream().anyMatch(state -> state.isSameState(taskInfoVo.getState()))) {
                bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)new DeployDcsQueryActivityResult(taskInfoVo.getChildren()));
            }
            if (TaskStateEnum.END.isSameState(taskInfoVo.getState())) {
                log.info("query {} deploy detail, it has end.", (Object)module);
                bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            } else if (TaskStateEnum.ERROR.isSameState(taskInfoVo.getState())) {
                log.error("query {} deploy detail, it has error.", (Object)module);
                bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            } else if (TaskStateEnum.PAUSE.isSameState(taskInfoVo.getState())) {
                log.warn("query {} deploy detail, it has pause.", (Object)module);
                bpmContextService.notifyInvocationPaused(externalTask, externalTaskService);
            } else {
                log.info("query {} deploy detail, result state = {}.", (Object)module, (Object)taskInfoVo.getState());
            }
        };
    }

    public DayuDeployExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, DayuDeployClient dayuDeployClient, DayuDeployParamsConvert convert) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.dayuDeployClient = dayuDeployClient;
        this.convert = convert;
    }
}

