/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Result;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.application.VmDeployFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.vm.param.VmParam;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import com.huawei.yinglong.virtualization.deploy.utils.VmParamUtils;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class DeployVmExternalTask {
    private static final Logger log = LoggerFactory.getLogger(DeployVmExternalTask.class);
    private final VmDeployFitImpl vmDeployImpl;
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;

    @ExternalTaskSubscription(value="startDeployVm")
    @Bean
    public ExternalTaskHandler startDeployVm() {
        return this.externalTaskDecorator.process(this.createVmDeployTaskHandler(arg_0 -> ((VmDeployFitImpl)this.vmDeployImpl).start(arg_0), true), this.createVmDeployTaskHandler(this::retryAllItems, true));
    }

    @ExternalTaskSubscription(value="queryDeployVmProgress")
    @Bean
    public ExternalTaskHandler queryDeployVmProgress() {
        return this.externalTaskDecorator.process(DeployFcResultUtils.createQueryDeployDmeDetailTaskHandler(this.bpmContextService, "VM", () -> this.vmDeployImpl.queryDeployDetails("VM")), this.createVmDeployTaskHandler(this::retryAllItems, false));
    }

    private Result retryAllItems(VmParam vmParam) {
        this.resetVmDatastoreName(vmParam);
        this.vmDeployImpl.updateParam(vmParam);
        return this.vmDeployImpl.retryAll().getResult();
    }

    private void resetVmDatastoreName(VmParam vmParam) {
        CollectionUtils.emptyIfNull((Collection)vmParam.getVmNode()).forEach(vmNode -> {
            vmNode.setDatastoreSystemName("");
            vmNode.setDatastoreDataName("");
        });
    }

    private ExternalTaskHandler createVmDeployTaskHandler(Function<VmParam, Result> executor, boolean isNotifyFinish) {
        return (externalTask, externalTaskService) -> {
            VirtualizationDeployProcessConfig processConfig = (VirtualizationDeployProcessConfig)this.bpmContextService.getContext(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class);
            Map<String, String> dmeDatas = processConfig.getDmeData();
            log.info("prepare to start vm deploy. data size = {}.", (Object)dmeDatas.size());
            if (!VmParamUtils.isAutoCreateVm(dmeDatas)) {
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                log.error("not auto create vm.");
                return;
            }
            Result result = (Result)executor.apply(VmParamUtils.createVmParam(dmeDatas));
            DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
            startInstallResult.setSuccess(result.getCode() == 0);
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
            if (!startInstallResult.isSuccess()) {
                log.error("start vm deploy failed, {}", (Object)result.getDescription());
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
            if (isNotifyFinish) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            }
        };
    }

    public DeployVmExternalTask(VmDeployFitImpl vmDeployImpl, BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator) {
        this.vmDeployImpl = vmDeployImpl;
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
    }
}

