/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamVrmVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.VrmInstallParamsVo;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.application.DmeInstallServiceFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.application.DmeInstallTaskFitImpl;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class DmeDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(DmeDeployExternalTask.class);
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final DmeInstallServiceFitImpl dmeInstallServiceImpl;
    private final DmeInstallTaskFitImpl dmeInstallTaskImpl;

    @ExternalTaskSubscription(value="startDmeDeploy")
    @Bean
    public ExternalTaskHandler startDmeDeploy() {
        return this.externalTaskDecorator.process(this.createDmeDataDeployTaskHandler(true));
    }

    private ExternalTaskHandler createDmeDataDeployTaskHandler(boolean isNotifyFinish) {
        return (externalTask, externalTaskService) -> {
            DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
            VirtualizationDeployProcessConfig processConfig = (VirtualizationDeployProcessConfig)this.bpmContextService.getContext(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class);
            Map<String, String> dmeDatas = processConfig.getDmeData();
            this.tryToPutExtraParams(processConfig, dmeDatas);
            log.info("prepare to start dme deploy. data size = {}.", (Object)dmeDatas.size());
            this.buildExtractParams(dmeDatas);
            this.dmeInstallServiceImpl.start(dmeDatas);
            startInstallResult.setSuccess(true);
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
            if (isNotifyFinish) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            }
        };
    }

    void buildExtractParams(Map<String, String> dmeDatas) {
        dmeDatas.put("DMEData_deploy_data_protection", "NO");
        dmeDatas.put("DMEData_deploy_data_container", "NO");
        dmeDatas.put("DMEData_deploy_lite_ca", "NO");
        dmeDatas.put("DMEData_graph_password", "");
    }

    private void tryToPutExtraParams(VirtualizationDeployProcessConfig processConfig, Map<String, String> dmeDatas) {
        List<FcInstallParamsVo> deployFcList = processConfig.getDeployFc();
        if (CollectionUtils.isEmpty(deployFcList)) {
            log.info("not need to put extra param to dme.");
            return;
        }
        Optional.ofNullable(deployFcList.get(0)).map(FcInstallParamsVo::getVrm).map(VrmInstallParamsVo::getVrm).ifPresent(vrmVo -> this.buildExtractParams(dmeDatas, (InsParamVrmVo)vrmVo));
    }

    void buildExtractParams(Map<String, String> dmeDatas, InsParamVrmVo vrmVo) {
        dmeDatas.put("vm_gandalf_password", vrmVo.getGandalfPwd());
        dmeDatas.put("vm_root_password", vrmVo.getRootPwd());
        if (Objects.equals(vrmVo.getUserMode(), "three")) {
            dmeDatas.put("vm_secadmin_password", vrmVo.getSecAdminPwd());
        }
        log.info("put extra param to dme datas, userMode={}.", (Object)vrmVo.getUserMode());
    }

    @ExternalTaskSubscription(value="queryDmeDeployDetail")
    @Bean
    public ExternalTaskHandler queryDmeDeployDetail() {
        return this.externalTaskDecorator.process(DeployFcResultUtils.createQueryDeployDmeDetailTaskHandler(this.bpmContextService, "eDME", () -> this.dmeInstallTaskImpl.queryDeployDetails("")), this.createDmeDataDeployTaskHandler(false));
    }

    public DmeDeployExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, DmeInstallServiceFitImpl dmeInstallServiceImpl, DmeInstallTaskFitImpl dmeInstallTaskImpl) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.dmeInstallServiceImpl = dmeInstallServiceImpl;
        this.dmeInstallTaskImpl = dmeInstallTaskImpl;
    }
}

