/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.impl.DeployEbackupFitImpl;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class EBackupDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(EBackupDeployExternalTask.class);
    private final DeployEbackupFitImpl deployEbackupImpl;
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;

    @Bean
    @ExternalTaskSubscription(value="startEBackupDeploy")
    public ExternalTaskHandler startEBackupDeploy() {
        return this.externalTaskDecorator.process(this.createEbackupDeployTaskHandler(arg_0 -> ((DeployEbackupFitImpl)this.deployEbackupImpl).startDeployEbackup(arg_0), true), this.createEbackupDeployTaskHandler(this::retryAllItems, true));
    }

    @Bean
    @ExternalTaskSubscription(value="queryDeployEBackupProgress")
    public ExternalTaskHandler queryEBackupDeployDetail() {
        return this.externalTaskDecorator.process(this.createQueryDeployEbackupDetailTaskHandler(this.bpmContextService, arg_0 -> ((DeployEbackupFitImpl)this.deployEbackupImpl).queryDeployDetails(arg_0)), this.createEbackupDeployTaskHandler(this::retryAllItems, false));
    }

    private ExternalTaskHandler createEbackupDeployTaskHandler(Function<EbackupParams, Response<Boolean>> executor, boolean isNotifyFinish) {
        return (externalTask, externalTaskService) -> {
            Optional<EbackupParams> opEbackupParams = this.getEbackupParams(this.bpmContextService, externalTask);
            if (!opEbackupParams.isPresent()) {
                log.error("start eBackup deploy failed, not find params.");
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            Response response = (Response)executor.apply(opEbackupParams.get());
            DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
            startInstallResult.setSuccess(ResponseUtil.isSuccess((Response)response) && (Boolean)response.getData() != false);
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
            if (!startInstallResult.isSuccess()) {
                log.error("start eBackup deploy failed, {}", (Object)response);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
            if (isNotifyFinish) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            }
        };
    }

    private Response<Boolean> retryAllItems(EbackupParams params) {
        this.resetVmDatastoreName(params);
        this.deployEbackupImpl.updateEbackupParams(params);
        return this.deployEbackupImpl.retryAllItems(params.getTaskId());
    }

    private void resetVmDatastoreName(EbackupParams params) {
        Optional.ofNullable(params.getTemplateInfo()).ifPresent(templateInfo -> templateInfo.setDatastoreName(""));
        CollectionUtils.emptyIfNull((Collection)params.getEbackupVmInfo()).forEach(vmInfo -> vmInfo.setDatastoreName(""));
    }

    private ExternalTaskHandler createQueryDeployEbackupDetailTaskHandler(BpmContextService bpmContextService, Function<String, Response<DeployTaskInfoVo>> executor) {
        return (externalTask, externalTaskService) -> {
            Optional<EbackupParams> opEbackupParams = this.getEbackupParams(bpmContextService, externalTask);
            if (!opEbackupParams.isPresent()) {
                log.error("query eBackup deploy details failed, not find params.");
                return;
            }
            Response taskInfoVoResponse = (Response)executor.apply(opEbackupParams.get().getTaskId());
            if (!ResponseUtil.isSuccess((Response)taskInfoVoResponse) || taskInfoVoResponse.getData() == null) {
                log.error("query eBackup deploy details failed, response error:{}.", (Object)ResponseUtil.isSuccess((Response)taskInfoVoResponse));
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)taskInfoVoResponse.getData());
        };
    }

    private Optional<EbackupParams> getEbackupParams(BpmContextService bpmContextService, ExternalTask externalTask) {
        VirtualizationDeployProcessConfig processConfig = (VirtualizationDeployProcessConfig)bpmContextService.getContext(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class);
        Optional<EbackupParams> opUltraVRParams = Optional.ofNullable(processConfig.getEbackupParams());
        opUltraVRParams.ifPresent(ultraVRParams -> log.info("UltraVR deploy, find params taskId:{}, vm size:{}.", (Object)ultraVRParams.getTaskId(), (Object)ultraVRParams.getEbackupVmInfo().size()));
        return opUltraVRParams;
    }

    public EBackupDeployExternalTask(DeployEbackupFitImpl deployEbackupImpl, BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator) {
        this.deployEbackupImpl = deployEbackupImpl;
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
    }
}

