/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.fusioncube.clinet.FusionCubeClient;
import com.huawei.yinglong.river.sitedeployment.fusioncube.entity.FusionCube82Params;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.DeployDcsQueryActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.TaskStateEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class FusionCubeDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(FusionCubeDeployExternalTask.class);
    private static final String FUSION_CUBE_MIGRATION_TYPE = "fusionCubeMigrationVm:";
    private static final String START_VM = "startVm";
    private static final String RETRY_VM = "retryVm";
    private static final List<TaskStateEnum> TASK_STATE_UPDATE_LIST = Arrays.asList(TaskStateEnum.END, TaskStateEnum.ERROR, TaskStateEnum.RUNNING, TaskStateEnum.PAUSE);
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final FusionCubeClient fusionCubeClient;

    @Bean
    @ExternalTaskSubscription(value="startFusionCubeDeploy")
    public ExternalTaskHandler startFusionCubeDeploy() {
        return this.externalTaskDecorator.process(this.startHandler());
    }

    private ExternalTaskHandler startHandler() {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, true, START_VM);
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, boolean isNotifyFinish, String action) {
        VirtualizationDeployProcessConfig processConfig = (VirtualizationDeployProcessConfig)this.bpmContextService.getContext(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class);
        FusionCube82Params fusionCube82Params = processConfig.getFusionCube82Params();
        fusionCube82Params.setTaskId(externalTask.getProcessInstanceId());
        switch (action) {
            case "startVm": {
                this.fusionCubeClient.startDeployTask(fusionCube82Params);
                break;
            }
            case "retryVm": {
                this.fusionCubeClient.retryDeployTask(fusionCube82Params);
            }
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        startInstallResult.setSuccess(true);
        if (!startInstallResult.isSuccess()) {
            log.error("retry fusionCube deploy failed");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    @Bean
    @ExternalTaskSubscription(value="queryDeployFusionCubeProgress")
    public ExternalTaskHandler queryFusionCubeDeployDetail() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(), this.retryTaskHandler());
    }

    private ExternalTaskHandler retryTaskHandler() {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, false, RETRY_VM);
    }

    private ExternalTaskHandler queryDetailHandler() {
        return this::updateResult;
    }

    void updateResult(ExternalTask externalTask, ExternalTaskService externalTaskService) {
        DeployTaskInfoVo taskInfoVo = (DeployTaskInfoVo)this.fusionCubeClient.querySdnTaskDetail(externalTask.getProcessInstanceId()).getData();
        if (TASK_STATE_UPDATE_LIST.stream().anyMatch(state -> state.isSameState(taskInfoVo.getState()))) {
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)new DeployDcsQueryActivityResult(taskInfoVo.getChildren()));
        }
        if (TaskStateEnum.END.isSameState(taskInfoVo.getState())) {
            log.info("query  deploy detail, it has end.");
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        } else if (TaskStateEnum.ERROR.isSameState(taskInfoVo.getState())) {
            log.error("query  deploy detail, it has error.");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        } else if (TaskStateEnum.PAUSE.isSameState(taskInfoVo.getState())) {
            log.warn("query  deploy detail, it has pause.");
            this.bpmContextService.notifyInvocationPaused(externalTask, externalTaskService);
        } else {
            log.info("query deploy detail, result state = {}.", (Object)taskInfoVo.getState());
        }
    }

    public FusionCubeDeployExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, FusionCubeClient fusionCubeClient) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.fusionCubeClient = fusionCubeClient;
    }
}

