/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BaseException;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.client.DeployHiCloudClient;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudParam;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.HiCloudConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudParamVo;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Optional;
import java.util.function.Consumer;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class HiCloudDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(HiCloudDeployExternalTask.class);
    private static final String HI_CLOUD_VM = "hiCloudVm:";
    private static final String HI_CLOUD_SERVICE = "hiCloudService:";
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final HiCloudConverter converter;
    private final DeployHiCloudClient client;

    @Bean
    @ExternalTaskSubscription(value="startHiCloudVmDeploy")
    public ExternalTaskHandler startHiCloudVmDeploy() {
        return this.externalTaskDecorator.process(this.startHandler(arg_0 -> ((DeployHiCloudClient)this.client).startDeployVmsTask(arg_0), HI_CLOUD_VM), this.retryVmTaskHandler(arg_0 -> ((DeployHiCloudClient)this.client).retryDeployVmTask(arg_0), true, HI_CLOUD_VM));
    }

    @Bean
    @ExternalTaskSubscription(value="queryHiCloudVmProgress")
    public ExternalTaskHandler queryHiCloudVmProgress() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(HI_CLOUD_VM), this.retryVmTaskHandler(arg_0 -> ((DeployHiCloudClient)this.client).retryDeployVmTask(arg_0), false, HI_CLOUD_VM));
    }

    @Bean
    @ExternalTaskSubscription(value="startHiCloudDeploy")
    public ExternalTaskHandler startHiCloudDeploy() {
        return this.externalTaskDecorator.process(this.startHandler(arg_0 -> ((DeployHiCloudClient)this.client).startDeployHiCloudService(arg_0), HI_CLOUD_SERVICE), this.retryVmTaskHandler(arg_0 -> ((DeployHiCloudClient)this.client).retryHiCloudServiceTask(arg_0), true, HI_CLOUD_SERVICE));
    }

    @Bean
    @ExternalTaskSubscription(value="queryHiCloudProgress")
    public ExternalTaskHandler queryHiCloudProgress() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(HI_CLOUD_SERVICE), this.retryVmTaskHandler(arg_0 -> ((DeployHiCloudClient)this.client).retryHiCloudServiceTask(arg_0), false, HI_CLOUD_SERVICE));
    }

    private ExternalTaskHandler retryVmTaskHandler(Consumer<HiCloudParam> action, boolean isNotifyFinish, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, isNotifyFinish, type);
    }

    private ExternalTaskHandler startHandler(Consumer<HiCloudParam> action, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, true, type);
    }

    private ExternalTaskHandler queryDetailHandler(String type) {
        return (externalTask, externalTaskService) -> {
            Response response = this.client.queryHiCloudTaskDetail(type.concat(externalTask.getProcessInstanceId()));
            if (!ResponseUtil.isSuccess((Response)response) || response.getData() == null) {
                log.error("query HiCloud deploy details failed, response error.");
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.getData());
        };
    }

    private void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, Consumer<HiCloudParam> action, boolean isNotifyFinish, String type) {
        Optional<HiCloudParamVo> param = this.getHiCloudParam(externalTask);
        if (!param.isPresent()) {
            log.error("HiCloud deploy failed, params not find.");
            return;
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        try {
            HiCloudParamVo paramVo = param.get();
            action.accept(this.converter.toHiCloudParam(paramVo, paramVo.getGeneral(), type.concat(externalTask.getProcessInstanceId())));
            startInstallResult.setSuccess(true);
        }
        catch (BaseException e) {
            log.error("HiCloud deploy failed");
            startInstallResult.setSuccess(false);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    private Optional<HiCloudParamVo> getHiCloudParam(ExternalTask externalTask) {
        return Optional.ofNullable(this.bpmContextService.getContext(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class)).map(VirtualizationDeployProcessConfig::getHiCloudParamVo);
    }

    public HiCloudDeployExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, HiCloudConverter converter, DeployHiCloudClient client) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.converter = converter;
        this.client = client;
    }
}

