/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.CnaInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamNodeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.TaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployos.entity.DeployOsBaseInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployos.entity.DeployOsParams;
import com.huawei.yinglong.river.sitedeployment.dcs.os.fit.impl.DeployOsFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class HostDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(HostDeployExternalTask.class);
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final DeployOsFitImpl deployOsImpl;

    @ExternalTaskSubscription(value="startHostDeploy")
    @Bean
    public ExternalTaskHandler startHostDeploy() {
        return this.externalTaskDecorator.process(DeployFcResultUtils.createStartDeployFcTaskHandler(this.bpmContextService, "Host", this::startDeployOsTask), DeployFcResultUtils.createRetryDeployFcTaskHandler(this.bpmContextService, "Host", true, this::updateDeployOsTaskParam, arg_0 -> ((DeployOsFitImpl)this.deployOsImpl).retryDeployOsService(arg_0)));
    }

    @ExternalTaskSubscription(value="queryHostDeployDetail")
    @Bean
    public ExternalTaskHandler queryHostDeployDetail() {
        return this.externalTaskDecorator.process(DeployFcResultUtils.createQueryDeployFcDetailTaskHandler(this.bpmContextService, "Host", arg_0 -> ((DeployOsFitImpl)this.deployOsImpl).queryDeployDetails(arg_0)), DeployFcResultUtils.createRetryDeployFcTaskHandler(this.bpmContextService, "Host", false, this::updateDeployOsTaskParam, arg_0 -> ((DeployOsFitImpl)this.deployOsImpl).retryDeployOsService(arg_0)));
    }

    private Response<Boolean> updateDeployOsTaskParam(FcInstallParamsVo paramsVo) {
        return this.createDeployOsTaskHandler(paramsVo, arg_0 -> ((DeployOsFitImpl)this.deployOsImpl).updateDeployOsParam(arg_0));
    }

    private Response<String> startDeployOsTask(FcInstallParamsVo paramsVo) {
        return this.createDeployOsTaskHandler(paramsVo, arg_0 -> ((DeployOsFitImpl)this.deployOsImpl).startDeployOsService(arg_0));
    }

    <T> Response<T> createDeployOsTaskHandler(FcInstallParamsVo paramsVo, Function<DeployOsParams, Response<T>> handler) {
        CnaInstallParamsVo cnaParamVo = paramsVo.getCna();
        TaskInfoVo taskInfoVo = paramsVo.getTask();
        if (cnaParamVo == null || cnaParamVo.getNodes() == null || taskInfoVo == null) {
            log.error("cna param or nodes or task info is null.");
            return ResponseUtil.failed((String)"invalid param of cna or task.", (String)"check params!");
        }
        Optional<InsParamNodeVo> opNodeVo = cnaParamVo.getNodes().stream().filter(InsParamNodeVo::getIsMaster).findFirst();
        if (!opNodeVo.isPresent()) {
            log.error("not find cna master node.");
            return ResponseUtil.failed((String)"invalid param of cna master node.", (String)"check params!");
        }
        InsParamNodeVo nodeVo = opNodeVo.get();
        return handler.apply(DeployOsParams.builder().taskId(paramsVo.getTask().getTaskId()).osType(Integer.valueOf(IsoImageArch.of(taskInfoVo.getCnaIsoFileName()).getOsType())).isoImagesPath(this.getIsoImageFile(taskInfoVo)).baseInfo(DeployOsBaseInfo.builder().bmcIp(nodeVo.getBmcIp()).bmcPassword(nodeVo.getBmcPwd()).bmcUser(nodeVo.getBmcUsername()).hostName(nodeVo.getHostName()).cnaIp(nodeVo.getHostIp()).cnaSubNetMask(nodeVo.getNetmask()).cnaGateway(nodeVo.getGateway()).manageVlan(nodeVo.getVlanId()).manageIpEth(nodeVo.getEthName()).grubPassword(cnaParamVo.getGrubPwd()).cnaPassword(cnaParamVo.getRootPwd()).build()).build());
    }

    private String getIsoImageFile(TaskInfoVo taskInfoVo) {
        return FilePathValidatorUtils.getSafePath((File)new File(taskInfoVo.getPackagePath(), taskInfoVo.getCnaIsoFileName())).orElse("");
    }

    public HostDeployExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, DeployOsFitImpl deployOsImpl) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.deployOsImpl = deployOsImpl;
    }

    private static enum IsoImageArch {
        X86_64(0, "X86_64"),
        X86(0, "X86"),
        ARM_64(1, "ARM_64"),
        ARM(1, "ARM");

        private final int osType;
        private final String osFlag;

        private static IsoImageArch of(String fileName) {
            return Arrays.stream(IsoImageArch.values()).filter(arch -> fileName.toUpperCase(Locale.ROOT).contains(arch.getOsFlag())).findFirst().orElse(X86_64);
        }

        private IsoImageArch(int osType, String osFlag) {
            this.osType = osType;
            this.osFlag = osFlag;
        }

        public int getOsType() {
            return this.osType;
        }

        public String getOsFlag() {
            return this.osFlag;
        }
    }
}

