/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.client.DeploySdnClient;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.context.SdnContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sdn.entity.SdnParam;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.SdnConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.DeployDcsQueryActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.TaskStateEnum;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class SdnDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(SdnDeployExternalTask.class);
    private static final String SDN_TYPE = "sdnVm:";
    private static final String START_VM = "startVm";
    private static final String RETRY_VM = "retryVm";
    private static final List<TaskStateEnum> TASK_STATE_UPDATE_LIST = Arrays.asList(TaskStateEnum.END, TaskStateEnum.ERROR, TaskStateEnum.RUNNING, TaskStateEnum.PAUSE);
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final DeploySdnClient deploySdnClient;
    private final SdnConverter converter;

    @Bean
    @ExternalTaskSubscription(value="startSdnDeploy")
    public ExternalTaskHandler startSdnDeploy() {
        return this.externalTaskDecorator.process(this.startHandler());
    }

    private ExternalTaskHandler startHandler() {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, true, START_VM);
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, boolean isNotifyFinish, String action) {
        VirtualizationDeployProcessConfig processConfig = (VirtualizationDeployProcessConfig)this.bpmContextService.getContext(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class);
        SdnParam sdnParam = this.converter.toSdnParam(processConfig.getSdnParamVo(), SDN_TYPE.concat(externalTask.getProcessInstanceId()));
        SdnContext.getInstance().setSdnParam(sdnParam);
        switch (action) {
            case "startVm": {
                this.deploySdnClient.startDeployTask();
                break;
            }
            case "retryVm": {
                this.deploySdnClient.retryDeployTask();
            }
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        startInstallResult.setSuccess(true);
        if (!startInstallResult.isSuccess()) {
            log.error("retry dayu deploy failed");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    @Bean
    @ExternalTaskSubscription(value="queryDeploySdnProgress")
    public ExternalTaskHandler querySdnDeployDetail() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(), this.retryTaskHandler());
    }

    private ExternalTaskHandler retryTaskHandler() {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, false, RETRY_VM);
    }

    private ExternalTaskHandler queryDetailHandler() {
        return this::updateResult;
    }

    void updateResult(ExternalTask externalTask, ExternalTaskService externalTaskService) {
        DeployTaskInfoVo taskInfoVo = (DeployTaskInfoVo)this.deploySdnClient.querySdnTaskDetail(SDN_TYPE.concat(externalTask.getProcessInstanceId())).getData();
        if (TASK_STATE_UPDATE_LIST.stream().anyMatch(state -> state.isSameState(taskInfoVo.getState()))) {
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)new DeployDcsQueryActivityResult(taskInfoVo.getChildren()));
        }
        if (TaskStateEnum.END.isSameState(taskInfoVo.getState())) {
            log.info("query  deploy detail, it has end.");
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        } else if (TaskStateEnum.ERROR.isSameState(taskInfoVo.getState())) {
            log.error("query  deploy detail, it has error.");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        } else if (TaskStateEnum.PAUSE.isSameState(taskInfoVo.getState())) {
            log.warn("query  deploy detail, it has pause.");
            this.bpmContextService.notifyInvocationPaused(externalTask, externalTaskService);
        } else {
            log.info("query deploy detail, result state = {}.", (Object)taskInfoVo.getState());
        }
    }

    public SdnDeployExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, DeploySdnClient deploySdnClient, SdnConverter converter) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.deploySdnClient = deploySdnClient;
        this.converter = converter;
    }
}

