/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BaseException;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.client.DeploySfsClient;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsParam;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.SfsConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.vo.sfs.SfsParamVo;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Optional;
import java.util.function.Consumer;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class SfsDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(SfsDeployExternalTask.class);
    private static final String SFS_VM = "SfsVm:";
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final SfsConverter sfsConverter;
    private final DeploySfsClient deploySfsClient;

    @Bean
    @ExternalTaskSubscription(value="startSfsDeploy")
    public ExternalTaskHandler startSfsDeploy() {
        return this.externalTaskDecorator.process(this.startHandler(arg_0 -> ((DeploySfsClient)this.deploySfsClient).startDeployTask(arg_0), SFS_VM), this.retryTaskHandler(arg_0 -> ((DeploySfsClient)this.deploySfsClient).retryDeployTask(arg_0), true, SFS_VM));
    }

    @Bean
    @ExternalTaskSubscription(value="queryDeploySfsProgress")
    public ExternalTaskHandler querySfsDeployDetail() {
        return this.externalTaskDecorator.process(this.queryDetailHandler(SFS_VM), this.retryTaskHandler(arg_0 -> ((DeploySfsClient)this.deploySfsClient).retryDeployTask(arg_0), false, SFS_VM));
    }

    private ExternalTaskHandler queryDetailHandler(String type) {
        return (externalTask, externalTaskService) -> {
            Response response = this.deploySfsClient.querySfsTaskDetail(type.concat(externalTask.getProcessInstanceId()));
            if (!ResponseUtil.isSuccess((Response)response) || response.getData() == null) {
                log.error("query Sfs deploy details failed, response error.");
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.getData());
        };
    }

    private ExternalTaskHandler startHandler(Consumer<SfsParam> action, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, true, type);
    }

    private ExternalTaskHandler retryTaskHandler(Consumer<SfsParam> action, boolean isNotifyFinish, String type) {
        return (externalTask, externalTaskService) -> this.startOrRetryDeployAction(externalTask, externalTaskService, action, isNotifyFinish, type);
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, Consumer<SfsParam> action, boolean isNotifyFinish, String type) {
        Optional<SfsParamVo> param = Optional.ofNullable(this.bpmContextService.getContext(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class)).map(VirtualizationDeployProcessConfig::getSfsParamVo);
        if (!param.isPresent()) {
            log.error("Sfs deploy failed, params not find.");
            return;
        }
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        try {
            SfsParamVo paramVo = param.get();
            action.accept(this.sfsConverter.toSfsParam(paramVo, type.concat(externalTask.getProcessInstanceId())));
            startInstallResult.setSuccess(true);
        }
        catch (BaseException e) {
            log.error("Sfs deploy failed");
            startInstallResult.setSuccess(false);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    public SfsDeployExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, SfsConverter sfsConverter, DeploySfsClient deploySfsClient) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.sfsConverter = sfsConverter;
        this.deploySfsClient = deploySfsClient;
    }
}

