/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.fit.impl.DeployUltraVRFitImpl;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.VirtualizationDeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Optional;
import java.util.function.Function;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class UltraVRDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(UltraVRDeployExternalTask.class);
    private final DeployUltraVRFitImpl deployUltraVRImpl;
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;

    @Bean
    @ExternalTaskSubscription(value="startUltraVRDeploy")
    public ExternalTaskHandler startUltraVRDeploy() {
        return this.externalTaskDecorator.process(this.createUltraVRDeployTaskHandler(arg_0 -> ((DeployUltraVRFitImpl)this.deployUltraVRImpl).startDeployUltraVR(arg_0), true), this.createUltraVRDeployTaskHandler(this::retryAllItems, true));
    }

    @Bean
    @ExternalTaskSubscription(value="queryDeployUltraVRProgress")
    public ExternalTaskHandler queryUltraVRDeployDetail() {
        return this.externalTaskDecorator.process(this.createQueryDeployUltraVRDetailTaskHandler(this.bpmContextService, arg_0 -> ((DeployUltraVRFitImpl)this.deployUltraVRImpl).queryDeployDetails(arg_0)), this.createUltraVRDeployTaskHandler(this::retryAllItems, false));
    }

    private Response<Boolean> retryAllItems(UltraVRParams params) {
        this.resetVmDatastoreName(params);
        this.deployUltraVRImpl.updateUltraVRParams(params);
        return this.deployUltraVRImpl.retryAllItems(params.getTaskId());
    }

    private void resetVmDatastoreName(UltraVRParams params) {
        Optional.ofNullable(params).ifPresent(param -> param.setDatastoreName(""));
        Optional.ofNullable(params).map(UltraVRParams::getTemplateInfo).ifPresent(templateInfo -> templateInfo.setDatastoreName(""));
    }

    private ExternalTaskHandler createUltraVRDeployTaskHandler(Function<UltraVRParams, Response<Boolean>> executor, boolean isNotifyFinish) {
        return (externalTask, externalTaskService) -> {
            Optional<UltraVRParams> opUltraVRParams = this.getUltraVRParams(this.bpmContextService, externalTask);
            if (!opUltraVRParams.isPresent()) {
                log.error("start UltraVR deploy failed, not find params.");
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            Response response = (Response)executor.apply(opUltraVRParams.get());
            DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
            startInstallResult.setSuccess(ResponseUtil.isSuccess((Response)response) && (Boolean)response.getData() != false);
            this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
            if (!startInstallResult.isSuccess()) {
                log.error("start UltraVR deploy failed, {}", (Object)response);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            if (isNotifyFinish) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            }
        };
    }

    private ExternalTaskHandler createQueryDeployUltraVRDetailTaskHandler(BpmContextService bpmContextService, Function<String, Response<DeployTaskInfoVo>> executor) {
        return (externalTask, externalTaskService) -> {
            Optional<UltraVRParams> opUltraVRParams = this.getUltraVRParams(bpmContextService, externalTask);
            if (!opUltraVRParams.isPresent()) {
                log.error("query UltraVR deploy details failed, not find params.");
                return;
            }
            Response taskInfoVoResponse = (Response)executor.apply(opUltraVRParams.get().getTaskId());
            if (!ResponseUtil.isSuccess((Response)taskInfoVoResponse) || taskInfoVoResponse.getData() == null) {
                log.error("query UltraVR deploy details failed, response error:{}.", (Object)ResponseUtil.isSuccess((Response)taskInfoVoResponse));
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)taskInfoVoResponse.getData());
        };
    }

    private Optional<UltraVRParams> getUltraVRParams(BpmContextService bpmContextService, ExternalTask externalTask) {
        VirtualizationDeployProcessConfig processConfig = (VirtualizationDeployProcessConfig)bpmContextService.getContext(externalTask.getExecutionId(), VirtualizationDeployProcessConfig.class);
        Optional<UltraVRParams> opUltraVRParams = Optional.ofNullable(processConfig.getUltraVRParams());
        opUltraVRParams.ifPresent(ultraVRParams -> log.info("UltraVR deploy, find params taskId:{}, manageIp:{}.", (Object)ultraVRParams.getTaskId(), (Object)ultraVRParams.getIp()));
        return opUltraVRParams;
    }

    public UltraVRDeployExternalTask(DeployUltraVRFitImpl deployUltraVRImpl, BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator) {
        this.deployUltraVRImpl = deployUltraVRImpl;
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
    }
}

