/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.a3000;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.client.NpuClient;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NpuConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.entity.NpuIpConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.exception.NpuException;
import com.huawei.yinglong.river.sitedeployment.dcs.npu.task.subtask.NpuConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.NpuPlaneInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerBasicInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerInfo;
import com.huawei.yinglong.virtualization.deploy.utils.DeployA3000Utils;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class DriverPluginInstallExternalTask {
    private static final Logger log = LoggerFactory.getLogger(DriverPluginInstallExternalTask.class);
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final NpuClient npuClient;

    @ExternalTaskSubscription(value="startDriverPluginInstall")
    @Bean
    public ExternalTaskHandler startDriverPluginInstall() {
        return this.externalTaskDecorator.process((externalTask, externalTaskService) -> this.startOrRetryDeployActionNoException(externalTask, externalTaskService, true));
    }

    private void startOrRetryDeployActionNoException(ExternalTask externalTask, ExternalTaskService externalTaskService, boolean isNotifyFinish) {
        try {
            this.startOrRetryDeployAction(externalTask, externalTaskService, isNotifyFinish);
        }
        catch (NpuException e) {
            log.error("start or retry deploy driver plugin failed.", (Throwable)e);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService, e.getErrorMessage());
        }
        catch (Exception e) {
            log.error("start or retry deploy driver plugin exception.", (Throwable)e);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }

    private void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, boolean isNotifyFinish) {
        A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
        if (Objects.isNull(processConfig) || Objects.isNull(processConfig.getContainerInfo())) {
            log.error("start deploy a3000 driver failed, not find container params.");
            return;
        }
        NpuConfig npuConfig = this.buildConfigParam(processConfig);
        boolean isExecuteSuccess = this.npuClient.startDeployStorage(npuConfig);
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        startInstallResult.setSuccess(isExecuteSuccess);
        if (!startInstallResult.isSuccess()) {
            log.error("start driver deploy failed");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    @NotNull
    NpuConfig buildConfigParam(A3000DeployProcessConfig param) {
        String softwarePath = param.getSoftwarePath();
        NpuConfig npuConfig = NpuConfig.builder().taskId(param.getTaskId()).masterIp(param.getMetaVisionInfo().getManageIp()).devicePluginPath(this.getFilePath(softwarePath, ConsistencyPattern::isA3000DevicePluginPackage)).devicePluginYamlPaths(this.getFilePaths(softwarePath, ConsistencyPattern::isA3000DevicePluginYaml)).dockerRuntimePath(this.getFilePath(softwarePath, ConsistencyPattern::isA3000DockerRuntimePackage)).exporterPath(this.getFilePath(softwarePath, ConsistencyPattern::isA3000NpuExporterPackage)).iBMAPath(this.getFilePath(softwarePath, ConsistencyPattern::isA3000IBMAZipPackage)).exporterYamlPaths(this.getFilePaths(softwarePath, ConsistencyPattern::isA3000ExporterYaml)).npuIpConfigs(this.buildNpuIpConfigs(param)).nodeInfos(this.buildNodes(param)).username("admin").build();
        npuConfig.setNpuDriverPath(this.getFilePath(softwarePath, ConsistencyPattern::isA3000NpuDriverPackage));
        npuConfig.setPassword(param.getMetaVisionInfo().getAdminPwd());
        npuConfig.setOrgAdminPwd(param.getMetaVisionInfo().getOrgAdminPwd());
        return npuConfig;
    }

    private List<NpuIpConfig> buildNpuIpConfigs(A3000DeployProcessConfig param) {
        List<NpuPlaneInfo> planes = param.getNpuPlaneInfos();
        if (planes != null && planes.size() == 4) {
            int[] idx = new int[]{0};
            return planes.stream().map(plane -> {
                int n = idx[0];
                idx[0] = n + 1;
                return new NpuIpConfig().setIndex(n).setNpuStartIp(plane.getNpuStartIp()).setNetmask(plane.getNetmask()).setGateway(plane.getGateway());
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<NpuConfigCmd> buildNodes(A3000DeployProcessConfig param) {
        return param.getServerInfos().stream().map(serverInfo -> this.buildCmdNode(param.getServerBasicInfo(), (ServerInfo)serverInfo, param.getSoftwarePath())).collect(Collectors.toList());
    }

    @NotNull
    private NpuConfigCmd buildCmdNode(ServerBasicInfo serverBasicInfo, ServerInfo serverInfo, String softwarePath) {
        NpuConfigCmd cmd = new NpuConfigCmd();
        cmd.setIp(serverInfo.getManagerIp());
        cmd.setUserName("manageromm");
        cmd.setPassword(serverBasicInfo.getInterconnectPwd());
        cmd.setRootPassword(serverBasicInfo.getRootPwd());
        cmd.setDriverType(serverInfo.getNpuDriverType());
        cmd.setNpuDriverPath(this.getFilePath(softwarePath, fileName -> this.isDriverFileMatch((String)fileName, serverInfo.getNpuDriverType())));
        cmd.setMaster("Master".equals(serverInfo.getNodeType()));
        return cmd;
    }

    private boolean isDriverFileMatch(String fileName, String driverName) {
        String version = driverName.replace("Ascend", "") + "-";
        return fileName.contains(version) || fileName.contains(version.toLowerCase(Locale.ENGLISH));
    }

    private String getFilePath(String softwareFilePath, Predicate<String> predicate) {
        List specialFileNames = FileOperateUtils.getSpecialFileNames((File)new File(softwareFilePath), predicate);
        if (specialFileNames.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)File.separator, softwareFilePath, (CharSequence)specialFileNames.get(0));
    }

    private List<String> getFilePaths(String softwareFilePath, Predicate<String> predicate) {
        List specialFileNames = FileOperateUtils.getSpecialFileNames((File)new File(softwareFilePath), predicate);
        if (specialFileNames.isEmpty()) {
            return Collections.emptyList();
        }
        return specialFileNames.stream().map(file -> String.join((CharSequence)File.separator, softwareFilePath, file)).collect(Collectors.toList());
    }

    @ExternalTaskSubscription(value="queryDriverPluginInstallProgress")
    @Bean
    public ExternalTaskHandler queryDriverPluginInstallProgress() {
        return this.externalTaskDecorator.process(this::createQueryDetailTaskHandler, (externalTask, externalTaskService) -> this.startOrRetryDeployActionNoException(externalTask, externalTaskService, false));
    }

    private void createQueryDetailTaskHandler(ExternalTask externalTask, ExternalTaskService externalTaskService) {
        A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
        if (Objects.isNull(processConfig) || CollectionUtils.isEmpty(processConfig.getStorageInfo())) {
            log.error("query deploy a3000 driver failed, not find container params.");
            return;
        }
        Optional response = this.npuClient.queryNpuTaskDetail(processConfig.getTaskId());
        if (!response.isPresent()) {
            log.error("query deploy a3000 driver details failed, response error:{}.", (Object)response);
            return;
        }
        DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.get());
    }

    public DriverPluginInstallExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, NpuClient npuClient) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.npuClient = npuClient;
    }
}

