/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.a3000;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.client.EcontainerClient;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.ComponentConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.ComponentInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.ComponentInstallDto;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.ContainerNetwork;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.ContainerRuntime;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.EcontainerDeployParamEntity;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.Login;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.NicInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.Node;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.NodePool;
import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.exececption.EcontainerException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.EcontainerInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.NetworkPlaneInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerBasicInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageLogicInfo;
import com.huawei.yinglong.virtualization.deploy.utils.DeployA3000Utils;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class EcontainerDeployExternalTask {
    private static final Logger log = LoggerFactory.getLogger(EcontainerDeployExternalTask.class);
    private final EcontainerClient econtainerClient;
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;

    @ExternalTaskSubscription(value="startEContainerDeploy")
    @Bean
    public ExternalTaskHandler startEContainerDeploy() {
        return this.externalTaskDecorator.process((externalTask, externalTaskService) -> this.startOrRetryDeployActionNoException(externalTask, externalTaskService, true));
    }

    private void startOrRetryDeployActionNoException(ExternalTask externalTask, ExternalTaskService externalTaskService, boolean isNotifyFinish) {
        try {
            this.startOrRetryDeployAction(externalTask, externalTaskService, isNotifyFinish);
        }
        catch (EcontainerException e) {
            log.error("start or retry deploy eContainer failed.", (Throwable)e);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService, e.getErrorMessage());
        }
        catch (Exception e) {
            log.error("start or retry deploy eContainer exception.", (Throwable)e);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }

    private void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, boolean isNotifyFinish) {
        A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
        if (Objects.isNull(processConfig) || Objects.isNull(processConfig.getContainerInfo())) {
            log.error("start deploy a3000 eContainer failed, not find server params.");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            return;
        }
        EcontainerDeployParamEntity entity = this.toEcontainerParamEntity(processConfig);
        boolean isExecuteSuccess = this.econtainerClient.startDeployEcontainer(processConfig.getTaskId(), entity);
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        startInstallResult.setSuccess(isExecuteSuccess);
        if (!startInstallResult.isSuccess()) {
            log.error("retry eContainer deploy failed");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    @ExternalTaskSubscription(value="queryEContainerDeployProgress")
    @Bean
    public ExternalTaskHandler queryEContainerDeployProgress() {
        return this.externalTaskDecorator.process(this.createQueryDetailTaskHandler(), (externalTask, externalTaskService) -> this.startOrRetryDeployActionNoException(externalTask, externalTaskService, false));
    }

    private ExternalTaskHandler createQueryDetailTaskHandler() {
        return (externalTask, externalTaskService) -> {
            A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
            if (Objects.isNull(processConfig) || CollectionUtils.isEmpty(processConfig.getStorageInfo())) {
                log.error("query deploy a3000 eContainer failed, not find server params.");
                return;
            }
            Optional response = this.econtainerClient.queryDeployTaskDetail(processConfig.getTaskId());
            if (!response.isPresent()) {
                log.error("query deploy a3000 eContainer details failed, response error:{}.", (Object)response);
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.get());
        };
    }

    EcontainerDeployParamEntity toEcontainerParamEntity(A3000DeployProcessConfig processConfig) {
        EcontainerInfo containerInfo = processConfig.getContainerInfo();
        EcontainerDeployParamEntity paramEntity = EcontainerDeployParamEntity.builder().path(processConfig.getSoftwarePath()).nodePools(this.buildNodePools(processConfig)).manageNic(this.buildNic(containerInfo.getManageFloatIp(), processConfig.getNetworkInfo().get(1))).businessNic(this.buildNic(containerInfo.getBusinessFloatIp(), processConfig.getNetworkInfo().get(3))).managerControlInitpasswd(processConfig.getMetaVisionInfo().getOrgAdminPwd()).managerControlTrapIp(processConfig.getMetaVisionInfo().getTrapIp()).canAudit(containerInfo.isOpenAuditLog()).multusEnable(containerInfo.isMultusEnable()).imageRepoSize(containerInfo.getImageCapacity()).containerNetwork(this.buildContainerNetWork(containerInfo)).adminPwd(containerInfo.getAdminPwd()).dns(containerInfo.getDnsIps()).ntpIp(containerInfo.getNtpIps()).componentInstallDto(this.buildComponent(processConfig.getStorageInfo())).build();
        paramEntity.fill();
        return paramEntity;
    }

    private ComponentInfo toStorageInfo(StorageInfo storageInfo) {
        return ComponentInfo.builder().urls(this.buildStorageUrls(storageInfo)).pools(Collections.singletonList(storageInfo.getPoolInfo().getPoolName())).username(storageInfo.getUsername()).password(storageInfo.getLoginPwd()).portals(Collections.singletonList(storageInfo.getLogicInfo().stream().map(StorageLogicInfo::getIp).filter(StringUtils::isNotEmpty).findFirst().orElse(""))).build();
    }

    private List<String> buildStorageUrls(StorageInfo storageInfo) {
        return storageInfo.getLogicInfo().stream().map(StorageLogicInfo::getManageIp).filter(StringUtils::isNotEmpty).map(ip -> StringUtils.formatTxt((String)"https://%s:8088", (Object[])new Object[]{ip})).collect(Collectors.toList());
    }

    private ContainerNetwork buildContainerNetWork(EcontainerInfo containerInfo) {
        return ContainerNetwork.builder().containerNetworkCategory(containerInfo.getNetworkType()).podCidr(containerInfo.getContainerNetworkCIDR()).serviceCidr(containerInfo.getServiceNetworkCIDR()).build();
    }

    private NicInfo buildNic(String ip, NetworkPlaneInfo networkPlaneInfo) {
        return NicInfo.builder().ip(ip).defaultGateway(networkPlaneInfo.getGateway()).netmask(networkPlaneInfo.getNetmask()).build();
    }

    private ComponentInstallDto buildComponent(List<StorageInfo> storageInfos) {
        List componentInfos = storageInfos.stream().map(this::toStorageInfo).collect(Collectors.toList());
        return ComponentInstallDto.builder().config(JsonUtils.toJson((Object)new ComponentConfig(componentInfos))).build();
    }

    private List<NodePool> buildNodePools(A3000DeployProcessConfig processConfig) {
        Map<String, List<ServerInfo>> nodeType = processConfig.getServerInfos().stream().collect(Collectors.groupingBy(ServerInfo::getNodeType));
        return nodeType.entrySet().stream().map(entry -> this.buildNodePool(processConfig, (List)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList());
    }

    NodePool buildNodePool(A3000DeployProcessConfig processConfig, List<ServerInfo> serverInfos, String key) {
        List nodes = serverInfos.stream().map(serverInfo -> this.toNode((ServerInfo)serverInfo, processConfig.getServerBasicInfo())).collect(Collectors.toList());
        boolean isMasterCluster = "Master".equals(key);
        return NodePool.builder().nodeDtoList(nodes).name(key + "-nodePool").defaultType(isMasterCluster).nodeNamingRule(isMasterCluster ? "cluster-master" : "cluster-worker").specNodeCount(nodes.size()).nodeArch("ARM".equals(processConfig.getServerBasicInfo().getArch()) ? "aarch64" : "x86_64").runtime(Objects.equals(ContainerRuntime.DOCKER.getName(), processConfig.getContainerInfo().getType()) ? ContainerRuntime.DOCKER : ContainerRuntime.ISULA).build();
    }

    private Node toNode(ServerInfo serverInfo, ServerBasicInfo serverBasicInfo) {
        return Node.builder().manageIpAddress(serverInfo.getManagerIp()).businessIpAddress(serverInfo.getBusinessIp()).storageIpAddress(serverInfo.getStorageIp()).rootLogin(Login.builder().user("root").password(serverBasicInfo.getRootPwd()).build()).sshLogin(Login.builder().user("gandalf").password(serverBasicInfo.getGandalfPwd()).build()).toolSshLogin(Login.builder().user("manageromm").password(serverBasicInfo.getInterconnectPwd()).build()).build();
    }

    public EcontainerDeployExternalTask(EcontainerClient econtainerClient, BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator) {
        this.econtainerClient = econtainerClient;
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
    }
}

