/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.a3000;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.entity.MateVisionManageInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.exception.TakeoverException;
import com.huawei.yinglong.river.sitedeployment.dcs.fusioncube.task.MetaVisionManageClient;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.MetaVisionManageConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.utils.DeployA3000Utils;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class MetaVisionManageExternalTask {
    private static final Logger log = LoggerFactory.getLogger(MetaVisionManageExternalTask.class);
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final MetaVisionManageClient client;
    private final MetaVisionManageConverter converter;

    @ExternalTaskSubscription(value="startMetaVisionManage")
    @Bean
    public ExternalTaskHandler startMetaVisionManage() {
        return this.externalTaskDecorator.process(this.createMetaVisionManageTaskHandler((arg_0, arg_1) -> ((MetaVisionManageClient)this.client).startMetaVisionManage(arg_0, arg_1), true), this.createMetaVisionManageTaskHandler((arg_0, arg_1) -> ((MetaVisionManageClient)this.client).startMetaVisionManage(arg_0, arg_1), true));
    }

    @ExternalTaskSubscription(value="queryMetaVisionManageProgress")
    @Bean
    public ExternalTaskHandler queryMetaVisionManageProgress() {
        return this.externalTaskDecorator.process(this.createQueryDetailTaskHandler(), this.createMetaVisionManageTaskHandler((arg_0, arg_1) -> ((MetaVisionManageClient)this.client).startMetaVisionManage(arg_0, arg_1), false));
    }

    private ExternalTaskHandler createMetaVisionManageTaskHandler(BiPredicate<String, MateVisionManageInfo> executor, boolean isNotifyFinish) {
        return (externalTask, externalTaskService) -> {
            try {
                A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
                if (Objects.isNull(processConfig)) {
                    log.error("start deploy a3000 os failed, not find server params.");
                    this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                    return;
                }
                MateVisionManageInfo manageInfo = this.converter.toMetaVisionManageInfo(processConfig);
                boolean result = executor.test(processConfig.getTaskId(), manageInfo);
                DcsDeployStartActivityResult activityResult = new DcsDeployStartActivityResult();
                activityResult.setSuccess(result);
                this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)activityResult);
                if (!activityResult.isSuccess()) {
                    log.error("start deploy a3000 MataVision Manage failed");
                    this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                    return;
                }
                if (isNotifyFinish) {
                    this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                }
            }
            catch (TakeoverException e) {
                log.error("start or retry takeover MetaVision failed.", (Throwable)e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService, e.getErrorMessage());
            }
            catch (Exception e) {
                log.error("start or retry takeover MetaVision exception.", (Throwable)e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    private ExternalTaskHandler createQueryDetailTaskHandler() {
        return (externalTask, externalTaskService) -> {
            A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
            if (Objects.isNull(processConfig)) {
                log.error("query deploy a3000 MetaVision failed.");
                return;
            }
            Optional taskInfoVo = this.client.queryMetaVisionManageTask(processConfig.getTaskId());
            if (!taskInfoVo.isPresent()) {
                log.error("query deploy a3000 MetaVision failed.");
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)taskInfoVo.get());
        };
    }

    public MetaVisionManageExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, MetaVisionManageClient client, MetaVisionManageConverter converter) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.client = client;
        this.converter = converter;
    }
}

