/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.a3000;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.params.A3000OsDeployParams;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.fit.impl.A3000DeployOsFitImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.OsInstallConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.NetworkPlaneType;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.NetworkPlaneInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerInfo;
import com.huawei.yinglong.virtualization.deploy.utils.DeployA3000Utils;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class OsInstallExternalTask {
    private static final Logger log = LoggerFactory.getLogger(OsInstallExternalTask.class);
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final A3000DeployOsFitImpl a3000DeployOsFit;
    private final OsInstallConverter converter;

    @ExternalTaskSubscription(value="startOsInstall")
    @Bean
    public ExternalTaskHandler startOsInstall() {
        return this.externalTaskDecorator.process(this.createDeployOsTaskHandler((arg_0, arg_1) -> ((A3000DeployOsFitImpl)this.a3000DeployOsFit).startDeployOsService(arg_0, arg_1), true), this.createDeployOsTaskHandler(this::retryAllItems, true));
    }

    @ExternalTaskSubscription(value="queryOsInstallProgress")
    @Bean
    public ExternalTaskHandler queryOsInstallProgress() {
        return this.externalTaskDecorator.process(this.createQueryDetailTaskHandler(), this.createDeployOsTaskHandler(this::retryAllItems, false));
    }

    private Response<String> retryAllItems(String taskId, List<A3000OsDeployParams> deployParams) {
        return this.a3000DeployOsFit.retryDeployOsService(taskId);
    }

    private ExternalTaskHandler createQueryDetailTaskHandler() {
        return (externalTask, externalTaskService) -> {
            A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
            if (Objects.isNull(processConfig) || CollectionUtils.isEmpty(processConfig.getServerInfos())) {
                log.error("query deploy a3000 os failed, not find server params.");
                return;
            }
            Response response = this.a3000DeployOsFit.queryDeployDetails(processConfig.getTaskId());
            if (!ResponseUtil.isSuccess((Response)response) || Objects.isNull(response.getData())) {
                log.error("query deploy a3000 os details failed, response error:{}.", (Object)response);
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.getData());
        };
    }

    private ExternalTaskHandler createDeployOsTaskHandler(BiFunction<String, List<A3000OsDeployParams>, Response<String>> executor, boolean isNotifyFinish) {
        return (externalTask, externalTaskService) -> {
            try {
                A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
                if (Objects.isNull(processConfig) || CollectionUtils.isEmpty(processConfig.getServerInfos())) {
                    log.error("start deploy a3000 os failed, not find server params.");
                    this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                    return;
                }
                Response response = (Response)executor.apply(processConfig.getTaskId(), processConfig.getServerInfos().stream().map(serverInfo -> this.toDeployOs((ServerInfo)serverInfo, processConfig)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
                DcsDeployStartActivityResult activityResult = new DcsDeployStartActivityResult();
                activityResult.setSuccess(ResponseUtil.isSuccess((Response)response) && StringUtils.isNotEmpty((CharSequence)((CharSequence)response.getData())));
                this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)activityResult);
                if (!activityResult.isSuccess()) {
                    log.error("start deploy a3000 os failed, {}", (Object)response);
                    this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                    return;
                }
                if (isNotifyFinish) {
                    this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                }
            }
            catch (DeployOsException e) {
                log.error("start or retry deploy os install failed.", (Throwable)e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService, e.getErrorMessage());
            }
            catch (Exception e) {
                log.error("start or retry deploy os install exception.", (Throwable)e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    private Optional<A3000OsDeployParams> toDeployOs(ServerInfo serverInfo, A3000DeployProcessConfig processConfig) {
        if (Objects.isNull(processConfig.getServerBasicInfo()) || Objects.isNull(serverInfo.getBmcInfo()) || Objects.isNull(processConfig.getServerDiskInfo())) {
            log.error("not found server basic, disk info or bmc info, {}.", (Object)Objects.isNull(serverInfo.getBmcInfo()));
            return Optional.empty();
        }
        Optional<NetworkPlaneInfo> manageNetworkPlane = DeployA3000Utils.getNetworkPlane(processConfig, NetworkPlaneType.MANAGEMENT);
        Optional<NetworkPlaneInfo> storageNetworkPlane = DeployA3000Utils.getNetworkPlane(processConfig, NetworkPlaneType.STORAGE);
        Optional<NetworkPlaneInfo> businessNetworkPlane = DeployA3000Utils.getNetworkPlane(processConfig, NetworkPlaneType.BUSINESS);
        if (!(manageNetworkPlane.isPresent() && storageNetworkPlane.isPresent() && businessNetworkPlane.isPresent())) {
            log.info("not find network plane, {} / {} / {}.", new Object[]{manageNetworkPlane, storageNetworkPlane, businessNetworkPlane});
            return Optional.empty();
        }
        return Optional.of(new A3000OsDeployParams().setIsoImagesPath(processConfig.getSoftwarePath()).setManagerIp(serverInfo.getManagerIp()).setDevName(serverInfo.getName()).setPortName(manageNetworkPlane.get().getNetCardName()).setArch(processConfig.getServerBasicInfo().getArch()).setRootPwd(processConfig.getServerBasicInfo().getRootPwd()).setInterconnectPwd(serverInfo.getInterconnectPwd()).setNetmask(manageNetworkPlane.get().getNetmask()).setGateway(manageNetworkPlane.get().getGateway()).setNetworkPlaneInfoList(Arrays.asList(this.converter.toPlaneInfo(serverInfo.getModel(), serverInfo.getStorageIp(), storageNetworkPlane.get()), this.converter.toPlaneInfo(serverInfo.getModel(), serverInfo.getBusinessIp(), businessNetworkPlane.get()), this.converter.toPlaneInfo(serverInfo.getModel(), serverInfo.getManagerIp(), manageNetworkPlane.get()))).setDiskInfo(this.converter.toDiskInfo(processConfig.getServerDiskInfo())).setBmcInfo(this.converter.toBmcInfo(serverInfo.getBmcInfo())));
    }

    public OsInstallExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, A3000DeployOsFitImpl a3000DeployOsFit, OsInstallConverter converter) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.a3000DeployOsFit = a3000DeployOsFit;
        this.converter = converter;
    }
}

