/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.a3000;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.engine.ExternalTaskDecorator;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.client.StorageClient;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.entity.DeviceConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.storage.exception.DeployException;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.StorageConverter;
import com.huawei.yinglong.virtualization.deploy.entity.DcsDeployStartActivityResult;
import com.huawei.yinglong.virtualization.deploy.entity.NetworkPlaneType;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.NetworkPlaneInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageInfo;
import com.huawei.yinglong.virtualization.deploy.utils.DeployA3000Utils;
import com.huawei.yinglong.virtualization.deploy.utils.DeployFcResultUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class StorageConfigExternalTask {
    private static final Logger log = LoggerFactory.getLogger(StorageConfigExternalTask.class);
    private final BpmContextService bpmContextService;
    private final ExternalTaskDecorator externalTaskDecorator;
    private final StorageConverter convert;
    private final StorageClient storageClient;

    @ExternalTaskSubscription(value="startStorageConfig")
    @Bean
    public ExternalTaskHandler startStorageConfig() {
        return this.externalTaskDecorator.process((externalTask, externalTaskService) -> this.startOrRetryDeployActionNoException(externalTask, externalTaskService, true));
    }

    @ExternalTaskSubscription(value="queryStorageConfigProgress")
    @Bean
    public ExternalTaskHandler queryStorageConfigProgress() {
        return this.externalTaskDecorator.process(this.createQueryDetailTaskHandler(), (externalTask, externalTaskService) -> this.startOrRetryDeployActionNoException(externalTask, externalTaskService, false));
    }

    void startOrRetryDeployActionNoException(ExternalTask externalTask, ExternalTaskService externalTaskService, boolean isNotifyFinish) {
        try {
            this.startOrRetryDeployAction(externalTask, externalTaskService, isNotifyFinish);
        }
        catch (DeployException e) {
            log.error("start or retry deploy storage config failed.", (Throwable)e);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService, e.getErrorMessage());
        }
        catch (Exception e) {
            log.error("start or retry deploy storage config exception.", (Throwable)e);
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }

    void startOrRetryDeployAction(ExternalTask externalTask, ExternalTaskService externalTaskService, boolean isNotifyFinish) {
        A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
        if (Objects.isNull(processConfig) || CollectionUtils.isEmpty(processConfig.getStorageInfo())) {
            log.error("start deploy a3000 storage failed, not find storage params.");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            return;
        }
        Optional<NetworkPlaneInfo> networkPlane = DeployA3000Utils.getNetworkPlane(processConfig, NetworkPlaneType.STORAGE);
        if (!networkPlane.isPresent()) {
            log.error("start deploy a3000 storage failed, not find storage plane params.");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            return;
        }
        List deviceConfigs = processConfig.getStorageInfo().stream().peek(storage -> storage.setNetmask(((NetworkPlaneInfo)networkPlane.get()).getNetmask()).setGateway(((NetworkPlaneInfo)networkPlane.get()).getGateway())).map(storage -> this.convert.toDeviceConfig(processConfig.getSoftwarePath(), (StorageInfo)storage)).collect(Collectors.toList());
        boolean isExecuteSuccess = this.storageClient.startDeployStorage(processConfig.getTaskId(), (DeviceConfig)deviceConfigs.get(0));
        DcsDeployStartActivityResult startInstallResult = new DcsDeployStartActivityResult();
        startInstallResult.setSuccess(isExecuteSuccess);
        if (!startInstallResult.isSuccess()) {
            log.error("start storage deploy failed");
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
        this.bpmContextService.updateActivityResult(externalTask.getExecutionId(), (ActivityResult)startInstallResult);
        if (isNotifyFinish) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        }
    }

    private ExternalTaskHandler createQueryDetailTaskHandler() {
        return (externalTask, externalTaskService) -> {
            A3000DeployProcessConfig processConfig = DeployA3000Utils.getProcessConfig(externalTask.getExecutionId(), this.bpmContextService);
            if (Objects.isNull(processConfig) || CollectionUtils.isEmpty(processConfig.getStorageInfo())) {
                log.error("query deploy a3000 storage failed, not find server params.");
                return;
            }
            Optional response = this.storageClient.queryStorageTaskDetail(processConfig.getTaskId());
            if (!response.isPresent()) {
                log.error("query deploy a3000 storage details failed, response error:{}.", (Object)response);
                return;
            }
            DeployFcResultUtils.handleDeployDetailResult(this.bpmContextService, externalTask, externalTaskService, (DeployTaskInfoVo)response.get());
        };
    }

    public StorageConfigExternalTask(BpmContextService bpmContextService, ExternalTaskDecorator externalTaskDecorator, StorageConverter convert, StorageClient storageClient) {
        this.bpmContextService = bpmContextService;
        this.externalTaskDecorator = externalTaskDecorator;
        this.convert = convert;
        this.storageClient = storageClient;
    }
}

