/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.converter;

import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreGlobalParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCorePasswordParam;
import com.huawei.yinglong.river.sitedeployment.dcs.campuscore.entity.CampusCoreVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.DiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.KmcCryptUtils;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreConstant;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreGlobalVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreLevelVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.campuscore.CampusCoreVmVo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(imports={CampusCoreConstant.class})
public interface CampusCoreConverter {
    @Mappings(value={@Mapping(target="fcLoginInfo", expression="java(paramVo.getCampusCoreBaseVo().getFcLoginInfo())"), @Mapping(target="campusCorePasswordParam", expression="java(toCampusCorePasswordParam(paramVo))"), @Mapping(target="campusCoreVmParams", expression="java(toCampusCoreVmParams(paramVo))"), @Mapping(target="campusCoreGlobalParam", expression="java(toCampusCoreGlobalParam(paramVo.getCampusCoreGlobalVo()))"), @Mapping(target="campusCoreBaseParam", source="paramVo.campusCoreBaseVo"), @Mapping(target="campusCoreLevelParam", source="paramVo.campusCoreLevelVo")})
    public CampusCoreParam toCampusCoreParam(CampusCoreParamVo var1, String var2);

    default public List<CampusCoreVmParam> toCampusCoreVmParams(CampusCoreParamVo paramVo) {
        if (CollectionUtils.isEmpty(paramVo.getCampusCoreVmVos())) {
            return Collections.emptyList();
        }
        return paramVo.getCampusCoreVmVos().stream().map(campusCoreVmVo -> this.toCampusCoreVmParam((CampusCoreVmVo)campusCoreVmVo, paramVo.getCampusCoreLevelVo())).collect(Collectors.toList());
    }

    @Mappings(value={@Mapping(target="diskCmd", expression="java(toDiskCmd(vmParam))"), @Mapping(target="nicConfigs", expression="java(toNicConfigs(vmParam, campusCoreLevelVo))"), @Mapping(target="cpuCores", source="vmParam.cpu")})
    public CampusCoreVmParam toCampusCoreVmParam(CampusCoreVmVo var1, CampusCoreLevelVo var2);

    default public List<VmNicConfigCmd> toNicConfigs(CampusCoreVmVo vmParam, CampusCoreLevelVo campusCoreLevelVo) {
        return Arrays.asList(VmNicConfigCmd.builder().ip(vmParam.getOmIp()).portGroupName(campusCoreLevelVo.getManagePortGroup()).netmask(campusCoreLevelVo.getNetmask()).gateway(campusCoreLevelVo.getManageGateway()).build(), VmNicConfigCmd.builder().ip(CampusCoreConstant.vmServiceIp.get(vmParam.getHostName())).portGroupName(campusCoreLevelVo.getManagePortGroup()).netmask(campusCoreLevelVo.getNetmask()).build());
    }

    @Mapping(target="language", expression="java(CampusCoreConstant.vmLanguage.get(campusCoreGlobalVo.getLanguage()))")
    public CampusCoreGlobalParam toCampusCoreGlobalParam(CampusCoreGlobalVo var1);

    default public List<DiskCmd> toDiskCmd(CampusCoreVmVo vmParam) {
        return CollectionUtils.emptyIfNull(vmParam.getDataDisks()).stream().filter(disk -> disk > 0).map(size -> DiskCmd.builder().dateStoreName(vmParam.getDataStore()).quantityGB(size.intValue()).build()).collect(Collectors.toList());
    }

    default public CampusCorePasswordParam toCampusCorePasswordParam(CampusCoreParamVo paramVo) {
        CampusCorePasswordParam campusCorePasswordParam = new CampusCorePasswordParam();
        campusCorePasswordParam.setTemplatePwd(KmcCryptUtils.encrypt((String)paramVo.getCampusCoreBaseVo().getTemplatePwd()));
        campusCorePasswordParam.setInterfaceUserPwd(KmcCryptUtils.encrypt((String)paramVo.getCampusCoreLevelVo().getInterfaceUserPwd()));
        campusCorePasswordParam.setDefaultPwd(KmcCryptUtils.encrypt((String)paramVo.getCampusCoreBaseVo().getDefaultPwd()));
        campusCorePasswordParam.setDefaultPwdSecond(KmcCryptUtils.encrypt((String)paramVo.getCampusCoreBaseVo().getDefaultPwdSecond()));
        campusCorePasswordParam.setRootPwd(KmcCryptUtils.encrypt((String)paramVo.getCampusCoreGlobalVo().getRootPwd()));
        campusCorePasswordParam.setSysPwd(KmcCryptUtils.encrypt((String)paramVo.getCampusCoreGlobalVo().getSysPwd()));
        return campusCorePasswordParam;
    }
}

