/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.converter;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.EcontainerDeployParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.BmcInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.EcontainerInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.InterconnectInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.MetaVisionInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.NetworkPlaneInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerBasicInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.SnmpInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageLogicInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StoragePoolInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.SwitchInfo;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerBaseParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerMetaVisionEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerNetworkPlaneEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerServerParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerStorageLogicParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerStorageParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerSwitchParamEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface EcontainerConverter {
    @Mappings(value={@Mapping(target="containerInfo", source="entity.serverBasicInfo"), @Mapping(target="serverBasicInfo", source="entity.serverBasicInfo"), @Mapping(target="serverDiskInfo", source="entity.serverBasicInfo"), @Mapping(target="serverInfos", expression="java(toServerList(entity.getServerBasicInfo(), entity.getServerInfos()))"), @Mapping(target="networkInfo", source="entity.networkInfos"), @Mapping(target="switchInfos", source="entity.switchInfos"), @Mapping(target="storageInfo", source="entity.storageInfos"), @Mapping(target="npuPlaneInfos", source="entity.npuPlaneInfos"), @Mapping(target="metaVisionInfo", source="entity.metaVisionInfo")})
    public A3000DeployProcessConfig toA3000DeployConfig(EcontainerParamEntity var1);

    @Mappings(value={@Mapping(target="containerInfo", source="entity.serverBasicInfo"), @Mapping(target="serverBasicInfo", source="entity.serverBasicInfo"), @Mapping(target="serverDiskInfo", source="entity.serverBasicInfo"), @Mapping(target="serverInfos", expression="java(toServerList(entity.getServerBasicInfo(), entity.getServerInfos()))"), @Mapping(target="networkInfo", source="entity.networkInfos"), @Mapping(target="switchInfos", source="entity.switchInfos"), @Mapping(target="storageInfo", source="entity.storageInfos"), @Mapping(target="npuPlaneInfos", source="entity.npuPlaneInfos"), @Mapping(target="metaVisionInfo", source="entity.metaVisionInfo")})
    public A3000DeployProcessConfig toA3000ExpansionDeployConfig(EcontainerParamEntity var1);

    default public List<ServerInfo> toServerList(EcontainerBaseParamEntity serverBasicInfo, List<EcontainerServerParamEntity> serverInfos) {
        return CollectionUtils.emptyIfNull(serverInfos).stream().map(server -> this.toServerInfo(serverBasicInfo, (EcontainerServerParamEntity)server)).collect(Collectors.toList());
    }

    public ServerBasicInfo toServerBasicInfo(EcontainerBaseParamEntity var1);

    public MetaVisionInfo toMetaVisionInfo(EcontainerMetaVisionEntity var1);

    @Mappings(value={@Mapping(target="dnsIps", expression="java(toDnsIps(serverBasicInfo))"), @Mapping(target="ntpIps", expression="java(toNtpIps(serverBasicInfo))"), @Mapping(target="openAuditLog", source="isOpenAuditLog"), @Mapping(target="multusEnable", source="isMultusEnable")})
    public EcontainerInfo toEcontainerInfo(EcontainerBaseParamEntity var1);

    default public List<String> toDnsIps(EcontainerBaseParamEntity serverBasicInfo) {
        if (StringUtils.isNotEmpty((CharSequence)serverBasicInfo.getDnsIps())) {
            return Arrays.asList(serverBasicInfo.getDnsIps().split(","));
        }
        return Collections.emptyList();
    }

    default public List<String> toNtpIps(EcontainerBaseParamEntity serverBasicInfo) {
        if (StringUtils.isNotEmpty((CharSequence)serverBasicInfo.getNtpIps())) {
            return Arrays.asList(serverBasicInfo.getDnsIps().split(","));
        }
        return Collections.emptyList();
    }

    public NetworkPlaneInfo toNetworkInfo(EcontainerNetworkPlaneEntity var1);

    @Mapping(target="snmpInfo", source="switchParamEntity")
    public SwitchInfo toSwitchInfo(EcontainerSwitchParamEntity var1);

    public SnmpInfo toSwitchSnmpInfo(EcontainerSwitchParamEntity var1);

    @Mapping(target="bmcInfo", source="serverParamEntity")
    public ServerInfo toServerInfo(EcontainerBaseParamEntity var1, EcontainerServerParamEntity var2);

    @Mapping(target="username", source="ibmcUsername")
    public BmcInfo toBmcInfo(EcontainerServerParamEntity var1);

    public SnmpInfo toSnmpInfo(EcontainerServerParamEntity var1);

    @Mappings(value={@Mapping(target="interconnectInfo", source="entity"), @Mapping(target="poolInfo", source="entity"), @Mapping(target="logicInfo", source="entity.logicInfos"), @Mapping(target="AManagerIp", expression="java(getLogicFieldValue(entity, \"CTE0-A\", EcontainerStorageLogicParamEntity::getManageIp))"), @Mapping(target="BManagerIp", expression="java(getLogicFieldValue(entity, \"CTE0-B\", EcontainerStorageLogicParamEntity::getManageIp))"), @Mapping(target="sn", expression="java(getLogicFieldValue(entity, \"CTE0-A\", EcontainerStorageLogicParamEntity::getSn))")})
    public StorageInfo toStorageInfo(EcontainerStorageParamEntity var1);

    default public List<StorageLogicInfo> toStorageLogicInfos(List<EcontainerStorageLogicParamEntity> entities) {
        Map<String, LogicMergeCell> cteLogicCellMap = CollectionUtils.emptyIfNull(entities).stream().filter(entry -> entry.getSlotId() > 0).collect(Collectors.toMap(this::getStorageLogicCteName, entity -> LogicMergeCell.builder().cabinet(entity.getCabinet()).slotId(entity.getSlotId()).sn(entity.getSn()).build(), (cteName1, cteName2) -> cteName1));
        return CollectionUtils.emptyIfNull(entities).stream().filter(entity -> !StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{entity.getManageIp(), entity.getIp()})).map(entity -> this.toStorageLogicInfo((EcontainerStorageLogicParamEntity)entity, (LogicMergeCell)cteLogicCellMap.get(this.getStorageLogicCteName((EcontainerStorageLogicParamEntity)entity)))).collect(Collectors.toList());
    }

    default public String getStorageLogicCteName(EcontainerStorageLogicParamEntity entity) {
        if (StringUtils.isEmpty((CharSequence)entity.getId())) {
            return "";
        }
        if (entity.getId().length() >= 4) {
            return entity.getId().substring(0, 4);
        }
        return entity.getId();
    }

    @Mappings(value={@Mapping(target="slotId", source="logicCte.slotId"), @Mapping(target="sn", source="logicCte.sn"), @Mapping(target="cabinet", source="logicCte.cabinet")})
    public StorageLogicInfo toStorageLogicInfo(EcontainerStorageLogicParamEntity var1, LogicMergeCell var2);

    default public String getLogicFieldValue(EcontainerStorageParamEntity storageParamEntity, String controllerId, Function<EcontainerStorageLogicParamEntity, String> logicFiledGetter) {
        return CollectionUtils.emptyIfNull(storageParamEntity.getLogicInfos()).stream().filter(logicInfo -> Objects.equals(controllerId, logicInfo.getId())).map(logicFiledGetter).findFirst().orElse("");
    }

    public InterconnectInfo toInterconnectInformation(EcontainerStorageParamEntity var1);

    public StoragePoolInfo toStoragePoolInformation(EcontainerStorageParamEntity var1);

    @Mapping(target="path", source="softwarePath")
    public EcontainerDeployParamEntity toEcontainerParamEntity(A3000DeployProcessConfig var1);

    public static class LogicMergeCell {
        private int slotId;
        private String sn;
        private String cabinet;

        LogicMergeCell(int slotId, String sn, String cabinet) {
            this.slotId = slotId;
            this.sn = sn;
            this.cabinet = cabinet;
        }

        public static LogicMergeCellBuilder builder() {
            return new LogicMergeCellBuilder();
        }

        public int getSlotId() {
            return this.slotId;
        }

        public String getSn() {
            return this.sn;
        }

        public String getCabinet() {
            return this.cabinet;
        }

        public static class LogicMergeCellBuilder {
            private int slotId;
            private String sn;
            private String cabinet;

            LogicMergeCellBuilder() {
            }

            public LogicMergeCellBuilder slotId(int slotId) {
                this.slotId = slotId;
                return this;
            }

            public LogicMergeCellBuilder sn(String sn) {
                this.sn = sn;
                return this;
            }

            public LogicMergeCellBuilder cabinet(String cabinet) {
                this.cabinet = cabinet;
                return this;
            }

            public LogicMergeCell build() {
                return new LogicMergeCell(this.slotId, this.sn, this.cabinet);
            }

            public String toString() {
                return "EcontainerConverter.LogicMergeCell.LogicMergeCellBuilder(slotId=" + this.slotId + ", sn=" + this.sn + ", cabinet=" + this.cabinet + ")";
            }
        }
    }
}

