/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.converter;

import com.huawei.yinglong.river.sitedeployment.dcs.econtainer.entity.EcontainerDeployParamEntity;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.EcontainerConverter;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.A3000DeployProcessConfig;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.BmcInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.EcontainerInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.InterconnectInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.MetaVisionInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.NetworkPlaneInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.NpuPlaneInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerBasicInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerDiskInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.ServerInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.SnmpInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StorageLogicInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.StoragePoolInfo;
import com.huawei.yinglong.virtualization.deploy.entity.a3000.SwitchInfo;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerBaseParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerMetaVisionEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerNetworkPlaneEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerNpuPlaneEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerServerParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerStorageLogicParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerStorageParamEntity;
import com.huawei.yinglong.virtualization.deploy.entity.export.econtainer.EcontainerSwitchParamEntity;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class EcontainerConverterImpl
implements EcontainerConverter {
    @Override
    public A3000DeployProcessConfig toA3000DeployConfig(EcontainerParamEntity entity) {
        if (entity == null) {
            return null;
        }
        A3000DeployProcessConfig a3000DeployProcessConfig = new A3000DeployProcessConfig();
        a3000DeployProcessConfig.setContainerInfo(this.toEcontainerInfo(entity.getServerBasicInfo()));
        a3000DeployProcessConfig.setServerBasicInfo(this.toServerBasicInfo(entity.getServerBasicInfo()));
        a3000DeployProcessConfig.setServerDiskInfo(this.econtainerBaseParamEntityToServerDiskInfo(entity.getServerBasicInfo()));
        a3000DeployProcessConfig.setNetworkInfo(this.econtainerNetworkPlaneEntityListToNetworkPlaneInfoList(entity.getNetworkInfos()));
        a3000DeployProcessConfig.setSwitchInfos(this.econtainerSwitchParamEntityListToSwitchInfoList(entity.getSwitchInfos()));
        a3000DeployProcessConfig.setStorageInfo(this.econtainerStorageParamEntityListToStorageInfoList(entity.getStorageInfos()));
        a3000DeployProcessConfig.setNpuPlaneInfos(this.econtainerNpuPlaneEntityListToNpuPlaneInfoList(entity.getNpuPlaneInfos()));
        a3000DeployProcessConfig.setMetaVisionInfo(this.toMetaVisionInfo(entity.getMetaVisionInfo()));
        a3000DeployProcessConfig.setServerInfos(this.toServerList(entity.getServerBasicInfo(), entity.getServerInfos()));
        return a3000DeployProcessConfig;
    }

    @Override
    public A3000DeployProcessConfig toA3000ExpansionDeployConfig(EcontainerParamEntity entity) {
        if (entity == null) {
            return null;
        }
        A3000DeployProcessConfig a3000DeployProcessConfig = new A3000DeployProcessConfig();
        a3000DeployProcessConfig.setContainerInfo(this.toEcontainerInfo(entity.getServerBasicInfo()));
        a3000DeployProcessConfig.setServerBasicInfo(this.toServerBasicInfo(entity.getServerBasicInfo()));
        a3000DeployProcessConfig.setServerDiskInfo(this.econtainerBaseParamEntityToServerDiskInfo(entity.getServerBasicInfo()));
        a3000DeployProcessConfig.setNetworkInfo(this.econtainerNetworkPlaneEntityListToNetworkPlaneInfoList(entity.getNetworkInfos()));
        a3000DeployProcessConfig.setSwitchInfos(this.econtainerSwitchParamEntityListToSwitchInfoList(entity.getSwitchInfos()));
        a3000DeployProcessConfig.setStorageInfo(this.econtainerStorageParamEntityListToStorageInfoList(entity.getStorageInfos()));
        a3000DeployProcessConfig.setNpuPlaneInfos(this.econtainerNpuPlaneEntityListToNpuPlaneInfoList(entity.getNpuPlaneInfos()));
        a3000DeployProcessConfig.setMetaVisionInfo(this.toMetaVisionInfo(entity.getMetaVisionInfo()));
        a3000DeployProcessConfig.setServerInfos(this.toServerList(entity.getServerBasicInfo(), entity.getServerInfos()));
        return a3000DeployProcessConfig;
    }

    @Override
    public ServerBasicInfo toServerBasicInfo(EcontainerBaseParamEntity serverBasicInfo) {
        if (serverBasicInfo == null) {
            return null;
        }
        ServerBasicInfo serverBasicInfo1 = new ServerBasicInfo();
        serverBasicInfo1.setArch(serverBasicInfo.getArch());
        serverBasicInfo1.setTimezoneRegion(serverBasicInfo.getTimezoneRegion());
        serverBasicInfo1.setTimezoneArea(serverBasicInfo.getTimezoneArea());
        serverBasicInfo1.setGandalfPwd(serverBasicInfo.getGandalfPwd());
        serverBasicInfo1.setRootPwd(serverBasicInfo.getRootPwd());
        serverBasicInfo1.setInterconnectPwd(serverBasicInfo.getInterconnectPwd());
        return serverBasicInfo1;
    }

    @Override
    public MetaVisionInfo toMetaVisionInfo(EcontainerMetaVisionEntity metaVisionEntity) {
        if (metaVisionEntity == null) {
            return null;
        }
        MetaVisionInfo metaVisionInfo = new MetaVisionInfo();
        metaVisionInfo.setManageIp(metaVisionEntity.getManageIp());
        metaVisionInfo.setAdminPwd(metaVisionEntity.getAdminPwd());
        metaVisionInfo.setOrgAdminPwd(metaVisionEntity.getOrgAdminPwd());
        metaVisionInfo.setTrapIp(metaVisionEntity.getTrapIp());
        return metaVisionInfo;
    }

    @Override
    public EcontainerInfo toEcontainerInfo(EcontainerBaseParamEntity serverBasicInfo) {
        if (serverBasicInfo == null) {
            return null;
        }
        EcontainerInfo econtainerInfo = new EcontainerInfo();
        if (serverBasicInfo.getIsOpenAuditLog() != null) {
            econtainerInfo.setOpenAuditLog(Boolean.parseBoolean(serverBasicInfo.getIsOpenAuditLog()));
        }
        if (serverBasicInfo.getIsMultusEnable() != null) {
            econtainerInfo.setMultusEnable(Boolean.parseBoolean(serverBasicInfo.getIsMultusEnable()));
        }
        econtainerInfo.setType(serverBasicInfo.getType());
        econtainerInfo.setManageFloatIp(serverBasicInfo.getManageFloatIp());
        econtainerInfo.setBusinessFloatIp(serverBasicInfo.getBusinessFloatIp());
        econtainerInfo.setAdminPwd(serverBasicInfo.getAdminPwd());
        econtainerInfo.setNetworkType(serverBasicInfo.getNetworkType());
        econtainerInfo.setServiceNetworkCIDR(serverBasicInfo.getServiceNetworkCIDR());
        econtainerInfo.setContainerNetworkCIDR(serverBasicInfo.getContainerNetworkCIDR());
        econtainerInfo.setImageCapacity(serverBasicInfo.getImageCapacity());
        econtainerInfo.setDnsIps(this.toDnsIps(serverBasicInfo));
        econtainerInfo.setNtpIps(this.toNtpIps(serverBasicInfo));
        return econtainerInfo;
    }

    @Override
    public NetworkPlaneInfo toNetworkInfo(EcontainerNetworkPlaneEntity networkPlane) {
        if (networkPlane == null) {
            return null;
        }
        NetworkPlaneInfo networkPlaneInfo = new NetworkPlaneInfo();
        networkPlaneInfo.setPortType(networkPlane.getPortType());
        networkPlaneInfo.setBondMode(networkPlane.getBondMode());
        networkPlaneInfo.setBondName(networkPlane.getBondName());
        networkPlaneInfo.setNetCardName(networkPlane.getNetCardName());
        networkPlaneInfo.setNetworkPlaneName(networkPlane.getNetworkPlaneName());
        networkPlaneInfo.setNetmask(networkPlane.getNetmask());
        networkPlaneInfo.setGateway(networkPlane.getGateway());
        return networkPlaneInfo;
    }

    @Override
    public SwitchInfo toSwitchInfo(EcontainerSwitchParamEntity switchParamEntity) {
        if (switchParamEntity == null) {
            return null;
        }
        SwitchInfo switchInfo = new SwitchInfo();
        switchInfo.setSnmpInfo(this.toSwitchSnmpInfo(switchParamEntity));
        switchInfo.setModel(switchParamEntity.getModel());
        switchInfo.setCabinet(switchParamEntity.getCabinet());
        switchInfo.setSlotId(switchParamEntity.getSlotId());
        switchInfo.setManagerIp(switchParamEntity.getManagerIp());
        return switchInfo;
    }

    @Override
    public SnmpInfo toSwitchSnmpInfo(EcontainerSwitchParamEntity switchParamEntity) {
        if (switchParamEntity == null) {
            return null;
        }
        SnmpInfo snmpInfo = new SnmpInfo();
        snmpInfo.setUsername(switchParamEntity.getUsername());
        snmpInfo.setPort(switchParamEntity.getPort());
        snmpInfo.setAuthAlgorithm(switchParamEntity.getAuthAlgorithm());
        snmpInfo.setAuthPwd(switchParamEntity.getAuthPwd());
        snmpInfo.setSecurityLevel(switchParamEntity.getSecurityLevel());
        snmpInfo.setEncAlgorithm(switchParamEntity.getEncAlgorithm());
        snmpInfo.setEncPwd(switchParamEntity.getEncPwd());
        return snmpInfo;
    }

    @Override
    public ServerInfo toServerInfo(EcontainerBaseParamEntity serverBasicInfo, EcontainerServerParamEntity serverParamEntity) {
        if (serverBasicInfo == null && serverParamEntity == null) {
            return null;
        }
        ServerInfo serverInfo = new ServerInfo();
        if (serverBasicInfo != null) {
            serverInfo.setInterconnectPwd(serverBasicInfo.getInterconnectPwd());
            serverInfo.setGandalfPwd(serverBasicInfo.getGandalfPwd());
        }
        if (serverParamEntity != null) {
            serverInfo.setBmcInfo(this.toBmcInfo(serverParamEntity));
            serverInfo.setModel(serverParamEntity.getModel());
            serverInfo.setCabinet(serverParamEntity.getCabinet());
            serverInfo.setSlotId(serverParamEntity.getSlotId());
            serverInfo.setName(serverParamEntity.getName());
            serverInfo.setSn(serverParamEntity.getSn());
            serverInfo.setNodeType(serverParamEntity.getNodeType());
            serverInfo.setNpuDriverType(serverParamEntity.getNpuDriverType());
            serverInfo.setManagerIp(serverParamEntity.getManagerIp());
            serverInfo.setBusinessIp(serverParamEntity.getBusinessIp());
            serverInfo.setStorageIp(serverParamEntity.getStorageIp());
            serverInfo.setFc2mgmtPwd(serverParamEntity.getFc2mgmtPwd());
        }
        return serverInfo;
    }

    @Override
    public BmcInfo toBmcInfo(EcontainerServerParamEntity serverParamEntity) {
        if (serverParamEntity == null) {
            return null;
        }
        BmcInfo bmcInfo = new BmcInfo();
        bmcInfo.setUsername(serverParamEntity.getIbmcUsername());
        bmcInfo.setCurrentIp(serverParamEntity.getCurrentIp());
        bmcInfo.setTargetIp(serverParamEntity.getTargetIp());
        bmcInfo.setOrgPwd(serverParamEntity.getOrgPwd());
        bmcInfo.setNewPwd(serverParamEntity.getNewPwd());
        bmcInfo.setFc2mgmtPwd(serverParamEntity.getFc2mgmtPwd());
        return bmcInfo;
    }

    @Override
    public SnmpInfo toSnmpInfo(EcontainerServerParamEntity serverParamEntity) {
        if (serverParamEntity == null) {
            return null;
        }
        SnmpInfo snmpInfo = new SnmpInfo();
        return snmpInfo;
    }

    @Override
    public StorageInfo toStorageInfo(EcontainerStorageParamEntity entity) {
        if (entity == null) {
            return null;
        }
        StorageInfo storageInfo = new StorageInfo();
        storageInfo.setInterconnectInfo(this.toInterconnectInformation(entity));
        storageInfo.setPoolInfo(this.toStoragePoolInformation(entity));
        storageInfo.setLogicInfo(this.toStorageLogicInfos(entity.getLogicInfos()));
        storageInfo.setModel(entity.getModel());
        storageInfo.setName(entity.getName());
        storageInfo.setCurrentManageIp(entity.getCurrentManageIp());
        storageInfo.setUsername(entity.getUsername());
        storageInfo.setLoginPwd(entity.getLoginPwd());
        storageInfo.setLicenseName(entity.getLicenseName());
        storageInfo.setAManagerIp(this.getLogicFieldValue(entity, "CTE0-A", EcontainerStorageLogicParamEntity::getManageIp));
        storageInfo.setBManagerIp(this.getLogicFieldValue(entity, "CTE0-B", EcontainerStorageLogicParamEntity::getManageIp));
        storageInfo.setSn(this.getLogicFieldValue(entity, "CTE0-A", EcontainerStorageLogicParamEntity::getSn));
        return storageInfo;
    }

    @Override
    public StorageLogicInfo toStorageLogicInfo(EcontainerStorageLogicParamEntity entity, EcontainerConverter.LogicMergeCell logicCte) {
        if (entity == null && logicCte == null) {
            return null;
        }
        StorageLogicInfo storageLogicInfo = new StorageLogicInfo();
        if (entity != null) {
            storageLogicInfo.setPortType(entity.getPortType());
            storageLogicInfo.setBondName(entity.getBondName());
            storageLogicInfo.setNetCardName(entity.getNetCardName());
            storageLogicInfo.setId(entity.getId());
            storageLogicInfo.setManageIp(entity.getManageIp());
            storageLogicInfo.setIp(entity.getIp());
        }
        if (logicCte != null) {
            storageLogicInfo.setSlotId(logicCte.getSlotId());
            storageLogicInfo.setSn(logicCte.getSn());
            storageLogicInfo.setCabinet(logicCte.getCabinet());
        }
        return storageLogicInfo;
    }

    @Override
    public InterconnectInfo toInterconnectInformation(EcontainerStorageParamEntity storageParamEntity) {
        if (storageParamEntity == null) {
            return null;
        }
        InterconnectInfo interconnectInfo = new InterconnectInfo();
        interconnectInfo.setAccount(storageParamEntity.getAccount());
        interconnectInfo.setAccountPwd(storageParamEntity.getAccountPwd());
        return interconnectInfo;
    }

    @Override
    public StoragePoolInfo toStoragePoolInformation(EcontainerStorageParamEntity storageParamEntity) {
        if (storageParamEntity == null) {
            return null;
        }
        StoragePoolInfo storagePoolInfo = new StoragePoolInfo();
        storagePoolInfo.setPoolName(storageParamEntity.getPoolName());
        storagePoolInfo.setCapacity(storageParamEntity.getCapacity());
        return storagePoolInfo;
    }

    @Override
    public EcontainerDeployParamEntity toEcontainerParamEntity(A3000DeployProcessConfig a3000DeployProcessConfig) {
        if (a3000DeployProcessConfig == null) {
            return null;
        }
        EcontainerDeployParamEntity.EcontainerDeployParamEntityBuilder econtainerDeployParamEntity = EcontainerDeployParamEntity.builder();
        econtainerDeployParamEntity.path(a3000DeployProcessConfig.getSoftwarePath());
        return econtainerDeployParamEntity.build();
    }

    protected ServerDiskInfo econtainerBaseParamEntityToServerDiskInfo(EcontainerBaseParamEntity econtainerBaseParamEntity) {
        if (econtainerBaseParamEntity == null) {
            return null;
        }
        ServerDiskInfo serverDiskInfo = new ServerDiskInfo();
        serverDiskInfo.setDiskSizeOfRoot(econtainerBaseParamEntity.getDiskSizeOfRoot());
        serverDiskInfo.setDiskSizeOfHome(econtainerBaseParamEntity.getDiskSizeOfHome());
        serverDiskInfo.setDiskSizeOfRepo(econtainerBaseParamEntity.getDiskSizeOfRepo());
        serverDiskInfo.setDiskSizeOfLog(econtainerBaseParamEntity.getDiskSizeOfLog());
        serverDiskInfo.setDiskSizeOfK8s(econtainerBaseParamEntity.getDiskSizeOfK8s());
        serverDiskInfo.setDiskSizeOfK8sDb(econtainerBaseParamEntity.getDiskSizeOfK8sDb());
        serverDiskInfo.setDiskSizeOfK8sCri(econtainerBaseParamEntity.getDiskSizeOfK8sCri());
        return serverDiskInfo;
    }

    protected List<NetworkPlaneInfo> econtainerNetworkPlaneEntityListToNetworkPlaneInfoList(List<EcontainerNetworkPlaneEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<NetworkPlaneInfo> list1 = new ArrayList<NetworkPlaneInfo>(list.size());
        for (EcontainerNetworkPlaneEntity econtainerNetworkPlaneEntity : list) {
            list1.add(this.toNetworkInfo(econtainerNetworkPlaneEntity));
        }
        return list1;
    }

    protected List<SwitchInfo> econtainerSwitchParamEntityListToSwitchInfoList(List<EcontainerSwitchParamEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<SwitchInfo> list1 = new ArrayList<SwitchInfo>(list.size());
        for (EcontainerSwitchParamEntity econtainerSwitchParamEntity : list) {
            list1.add(this.toSwitchInfo(econtainerSwitchParamEntity));
        }
        return list1;
    }

    protected List<StorageInfo> econtainerStorageParamEntityListToStorageInfoList(List<EcontainerStorageParamEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<StorageInfo> list1 = new ArrayList<StorageInfo>(list.size());
        for (EcontainerStorageParamEntity econtainerStorageParamEntity : list) {
            list1.add(this.toStorageInfo(econtainerStorageParamEntity));
        }
        return list1;
    }

    protected NpuPlaneInfo econtainerNpuPlaneEntityToNpuPlaneInfo(EcontainerNpuPlaneEntity econtainerNpuPlaneEntity) {
        if (econtainerNpuPlaneEntity == null) {
            return null;
        }
        NpuPlaneInfo npuPlaneInfo = new NpuPlaneInfo();
        npuPlaneInfo.setPortName(econtainerNpuPlaneEntity.getPortName());
        npuPlaneInfo.setNpuStartIp(econtainerNpuPlaneEntity.getNpuStartIp());
        npuPlaneInfo.setNpuEndIp(econtainerNpuPlaneEntity.getNpuEndIp());
        npuPlaneInfo.setNetmask(econtainerNpuPlaneEntity.getNetmask());
        npuPlaneInfo.setGateway(econtainerNpuPlaneEntity.getGateway());
        return npuPlaneInfo;
    }

    protected List<NpuPlaneInfo> econtainerNpuPlaneEntityListToNpuPlaneInfoList(List<EcontainerNpuPlaneEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<NpuPlaneInfo> list1 = new ArrayList<NpuPlaneInfo>(list.size());
        for (EcontainerNpuPlaneEntity econtainerNpuPlaneEntity : list) {
            list1.add(this.econtainerNpuPlaneEntityToNpuPlaneInfo(econtainerNpuPlaneEntity));
        }
        return list1;
    }
}

