/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.converter;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.DiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudPassword;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.entity.IpNodeInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.entity.OmIp;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.entity.OmVip;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.entity.TemplateParameter;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.entity.TenantIp;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.entity.TenantVip;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.entity.TenantVipNode;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.task.service.subtask.entity.VipNodeInfo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudConstant;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudGeneralVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPasswordVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPlanVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudVmVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper
public interface HiCloudConverter {
    @Mappings(value={@Mapping(target="hiCloudPassword", expression="java(toHiCloudPassword(param.getPassword(), param.getService().getUserGatewayPwd()))"), @Mapping(target="serviceParam", source="param.service"), @Mapping(target="vmParams", expression="java(toHiCloudVmParams(param))"), @Mapping(target="gkitVmParam", expression="java(toHiCloudGkitVmParams(param).orElse(null))"), @Mapping(target="templateParam", expression="java(toTemplateParam(param))")})
    public HiCloudParam toHiCloudParam(HiCloudParamVo var1, HiCloudGeneralVo var2, String var3);

    public HiCloudPassword toHiCloudPassword(HiCloudPasswordVo var1, String var2);

    default public TemplateParameter toTemplateParam(HiCloudParamVo param) {
        TemplateParameter.TemplateParameterBuilder builder = TemplateParameter.builder();
        this.buildOm(builder, param.findVmByName("paas-core"), param.getPlan());
        this.buildTenantIp(builder, param);
        this.buildTenantVip(builder, param.findVmByName("platform-node1"), param.getPlan());
        return builder.clockIp(param.getGeneral().getPaasManageNtpIp()).dmeScIp(param.getService().getDmeScIp()).dmeOcIp(param.getService().getDmeOcIp()).smOption(param.getService().getSmOption()).build();
    }

    default public void buildOm(TemplateParameter.TemplateParameterBuilder builder, HiCloudVmVo paasCore, HiCloudPlanVo plan) {
        builder.omIp(OmIp.builder().ipNodeinfo(IpNodeInfo.builder().omIp(paasCore.getOmIp()).appOmIp(paasCore.getOmIp()).externalIp(paasCore.getOmIp()).build()).build()).omVip(OmVip.builder().omVipInfo(VipNodeInfo.builder().vip(plan.getFloatIp()).nodes(Collections.singletonList("paas-core")).build()).appOmVipInfo(VipNodeInfo.builder().vip(plan.getFloatIp()).nodes(Collections.singletonList("paas-core")).build()).externalVipInfo(VipNodeInfo.builder().vip(plan.getFloatIp()).nodes(Collections.singletonList("paas-core")).build()).build());
    }

    default public void buildTenantIp(TemplateParameter.TemplateParameterBuilder builder, HiCloudParamVo param) {
        HiCloudVmVo node1 = param.findVmByName("platform-node1");
        HiCloudVmVo node2 = param.findVmByName("platform-node2");
        HiCloudVmVo node3 = param.findVmByName("platform-node3");
        builder.tenantIp(TenantIp.builder().platformNode1(IpNodeInfo.builder().appOmIp(node1.getOmIp()).externalIp(node1.getOmIp()).serviceIp(node1.getOmIp()).build()).platformNode2(IpNodeInfo.builder().appOmIp(node2.getOmIp()).externalIp(node2.getOmIp()).serviceIp(node2.getOmIp()).build()).platformNode3(IpNodeInfo.builder().appOmIp(node3.getOmIp()).serviceIp(node3.getOmIp()).build()).build());
    }

    default public void buildTenantVip(TemplateParameter.TemplateParameterBuilder builder, HiCloudVmVo node1, HiCloudPlanVo plan) {
        builder.tenantVip(TenantVip.builder().appOmVip(Collections.singletonList(TenantVipNode.builder().keepAliveDName(VipNodeInfo.builder().vip(plan.getKeepalivedVip1()).nodes(Arrays.asList("platform-node1", "platform-node2")).build()).build())).externalVip(Collections.singletonList(TenantVipNode.builder().keepAliveDName(VipNodeInfo.builder().vip(plan.getKeepalivedVip2()).nodes(Arrays.asList("platform-node1", "platform-node2")).build()).build())).serviceVip(this.buildServiceVip(plan)).build());
    }

    default public List<TenantVipNode> buildServiceVip(HiCloudPlanVo planVo) {
        ArrayList<TenantVipNode> serviceVip = new ArrayList<TenantVipNode>();
        serviceVip.add(TenantVipNode.builder().keepAliveDName(VipNodeInfo.builder().vip(planVo.getKeepalivedVip3()).nodes(HiCloudConstant.KEEP_ALIVED_NAME_NODES).build()).build());
        serviceVip.add(TenantVipNode.builder().gaussDbName(VipNodeInfo.builder().vip(planVo.getGaussdbVip()).nodes(HiCloudConstant.GAUSS_DB_NAME_NODES).build()).build());
        return serviceVip;
    }

    default public Optional<HiCloudVmParam> toHiCloudGkitVmParams(HiCloudParamVo param) {
        if (CollectionUtils.isEmpty(param.getVmParams()) || Objects.isNull(param.getPlan())) {
            return Optional.empty();
        }
        return param.getVmParams().stream().filter(HiCloudVmVo::isGkit).findFirst().map(vmParam -> this.toHiCloudVmParam((HiCloudVmVo)vmParam, param.getPlan(), param.getPassword()));
    }

    default public List<HiCloudVmParam> toHiCloudVmParams(HiCloudParamVo param) {
        if (CollectionUtils.isEmpty(param.getVmParams()) || Objects.isNull(param.getPlan())) {
            return Collections.emptyList();
        }
        return param.getVmParams().stream().filter(vmParam -> !vmParam.isGkit()).map(vmParam -> this.toHiCloudVmParam((HiCloudVmVo)vmParam, param.getPlan(), param.getPassword())).collect(Collectors.toList());
    }

    @Mappings(value={@Mapping(target="paasPassword", expression="java(toHiCloudVmPaasPassword(vmParam, password))"), @Mapping(target="rootPassword", expression="java(toHiCloudVmRootPassword(vmParam, password))"), @Mapping(target="nicConfigs", expression="java(toNicConfigs(vmParam, plan))"), @Mapping(target="memorySizeGb", source="vmParam.memory"), @Mapping(target="diskCmds", expression="java(toDiskCmds(vmParam))"), @Mapping(target="cpuCores", source="vmParam.cpu"), @Mapping(target="datastoreName", source="vmParam.dataStoreName"), @Mapping(target="appOmIp", source="vmParam.omIp")})
    public HiCloudVmParam toHiCloudVmParam(HiCloudVmVo var1, HiCloudPlanVo var2, HiCloudPasswordVo var3);

    default public String toHiCloudVmRootPassword(HiCloudVmVo vmParam, HiCloudPasswordVo password) {
        return vmParam.isManagePlan() ? password.getRootPwd() : password.getDataRootPwd();
    }

    default public String toHiCloudVmPaasPassword(HiCloudVmVo vmParam, HiCloudPasswordVo password) {
        return vmParam.isManagePlan() ? password.getPaasPwd() : password.getDataPaasPwd();
    }

    default public List<DiskCmd> toDiskCmds(HiCloudVmVo vmParam) {
        return CollectionUtils.emptyIfNull(vmParam.getDataDisks()).stream().map(size -> DiskCmd.builder().dateStoreName(vmParam.getDataStoreName()).quantityGB(size.intValue()).build()).collect(Collectors.toList());
    }

    default public List<VmNicConfigCmd> toNicConfigs(HiCloudVmVo vmParam, HiCloudPlanVo plan) {
        return Collections.singletonList(VmNicConfigCmd.builder().ip(vmParam.getOmIp()).portGroupName(plan.getPortGroup()).netmask(plan.getMask()).gateway(plan.getGateway()).build());
    }

    default public VmNicConfigCmd buildNicConfig(String ip, String portGroupName, String netmask) {
        return VmNicConfigCmd.builder().ip(ip).portGroupName(portGroupName).netmask(netmask).build();
    }
}

