/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.virtualization.deploy.bpm.converter;

import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudPassword;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudServiceParam;
import com.huawei.yinglong.river.sitedeployment.dcs.hicloud.entity.HiCloudVmParam;
import com.huawei.yinglong.virtualization.deploy.bpm.converter.HiCloudConverter;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudGeneralVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPasswordVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudPlanVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudServiceParamVo;
import com.huawei.yinglong.virtualization.deploy.entity.vo.hicloud.HiCloudVmVo;
import org.springframework.stereotype.Component;

@Component
public class HiCloudConverterImpl
implements HiCloudConverter {
    @Override
    public HiCloudParam toHiCloudParam(HiCloudParamVo param, HiCloudGeneralVo general, String taskId) {
        if (param == null && general == null && taskId == null) {
            return null;
        }
        HiCloudParam.HiCloudParamBuilder hiCloudParam = HiCloudParam.builder();
        if (param != null) {
            hiCloudParam.serviceParam(this.hiCloudServiceParamVoToHiCloudServiceParam(param.getService()));
        }
        if (general != null) {
            hiCloudParam.packagePath(general.getPackagePath());
            hiCloudParam.fcLoginInfo(general.getFcLoginInfo());
        }
        hiCloudParam.taskId(taskId);
        hiCloudParam.hiCloudPassword(this.toHiCloudPassword(param.getPassword(), param.getService().getUserGatewayPwd()));
        hiCloudParam.vmParams(this.toHiCloudVmParams(param));
        hiCloudParam.gkitVmParam((HiCloudVmParam)this.toHiCloudGkitVmParams(param).orElse(null));
        hiCloudParam.templateParam(this.toTemplateParam(param));
        return hiCloudParam.build();
    }

    @Override
    public HiCloudPassword toHiCloudPassword(HiCloudPasswordVo password, String userGatewayPwd) {
        if (password == null && userGatewayPwd == null) {
            return null;
        }
        HiCloudPassword.HiCloudPasswordBuilder hiCloudPassword = HiCloudPassword.builder();
        if (password != null) {
            hiCloudPassword.svcServiceStagePwd(password.getSvcServiceStagePwd());
            hiCloudPassword.svcCfePwd(password.getSvcCfePwd());
            hiCloudPassword.svcPomPwd(password.getSvcPomPwd());
            hiCloudPassword.tenantPwd(password.getTenantPwd());
            hiCloudPassword.installPwd(password.getInstallPwd());
            hiCloudPassword.paasPwd(password.getPaasPwd());
            hiCloudPassword.sshPwd(password.getSshPwd());
            hiCloudPassword.rootPwd(password.getRootPwd());
            hiCloudPassword.dataPaasPwd(password.getDataPaasPwd());
            hiCloudPassword.dataRootPwd(password.getDataRootPwd());
            hiCloudPassword.adminPwd(password.getAdminPwd());
            hiCloudPassword.securityPwd(password.getSecurityPwd());
            hiCloudPassword.auditPwd(password.getAuditPwd());
        }
        hiCloudPassword.userGatewayPwd(userGatewayPwd);
        return hiCloudPassword.build();
    }

    @Override
    public HiCloudVmParam toHiCloudVmParam(HiCloudVmVo vmParam, HiCloudPlanVo plan, HiCloudPasswordVo password) {
        if (vmParam == null && plan == null && password == null) {
            return null;
        }
        HiCloudVmParam.HiCloudVmParamBuilder hiCloudVmParam = HiCloudVmParam.builder();
        if (vmParam != null) {
            hiCloudVmParam.memorySizeGb(vmParam.getMemory());
            hiCloudVmParam.cpuCores(vmParam.getCpu());
            hiCloudVmParam.datastoreName(vmParam.getDataStoreName());
            hiCloudVmParam.appOmIp(vmParam.getOmIp());
            hiCloudVmParam.hostName(vmParam.getHostName());
            hiCloudVmParam.cnaName(vmParam.getCnaName());
            hiCloudVmParam.sysDisk(vmParam.getSysDisk());
        }
        hiCloudVmParam.paasPassword(this.toHiCloudVmPaasPassword(vmParam, password));
        hiCloudVmParam.rootPassword(this.toHiCloudVmRootPassword(vmParam, password));
        hiCloudVmParam.nicConfigs(this.toNicConfigs(vmParam, plan));
        hiCloudVmParam.diskCmds(this.toDiskCmds(vmParam));
        return hiCloudVmParam.build();
    }

    protected HiCloudServiceParam hiCloudServiceParamVoToHiCloudServiceParam(HiCloudServiceParamVo hiCloudServiceParamVo) {
        if (hiCloudServiceParamVo == null) {
            return null;
        }
        HiCloudServiceParam.HiCloudServiceParamBuilder hiCloudServiceParam = HiCloudServiceParam.builder();
        hiCloudServiceParam.dmeScIp(hiCloudServiceParamVo.getDmeScIp());
        hiCloudServiceParam.dmeOcIp(hiCloudServiceParamVo.getDmeOcIp());
        hiCloudServiceParam.smOption(hiCloudServiceParamVo.getSmOption());
        return hiCloudServiceParam.build();
    }
}

